/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.network.packet;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import com.the9grounds.aeadditions.part.PartECBase;
import com.the9grounds.aeadditions.util.StorageChannels;
import com.the9grounds.aeadditions.util.TileUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PacketBufferEC
extends PacketBuffer {
    public PacketBufferEC(ByteBuf wrapped) {
        super(wrapped);
    }

    public String readString() {
        return super.func_150789_c(1024);
    }

    public void writeFluidStack(@Nullable IAEFluidStack fluidStack) {
        if (fluidStack == null) {
            this.writeLong(-1L);
        } else {
            this.writeLong(fluidStack.getStackSize());
            this.writeFluid(fluidStack.getFluid());
        }
    }

    @Nullable
    public IAEFluidStack readFluidStack() {
        long amount = this.readLong();
        if (amount > 0L) {
            Fluid fluid = this.readFluid();
            if (fluid == null) {
                return null;
            }
            return (IAEFluidStack)((IAEFluidStack)StorageChannels.FLUID.createStack((Object)new FluidStack(fluid, 1))).setStackSize(amount);
        }
        return null;
    }

    public void writeFluid(Fluid fluid) {
        if (fluid == null) {
            this.func_180714_a("");
            return;
        }
        this.func_180714_a(fluid.getName());
    }

    @Nullable
    public Fluid readFluid() {
        String fluidName = this.readString();
        return FluidRegistry.getFluid((String)fluidName);
    }

    public void writePart(PartECBase part) {
        IPartHost host = part.getHost();
        if (host == null || host.getTile() == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        TileEntity tileEntity = host.getTile();
        this.func_179255_a(tileEntity.func_174877_v());
        this.writeByte(part.getSide().ordinal());
    }

    @Nullable
    public <P extends IPart> P readPart(World world) {
        if (!this.readBoolean()) {
            return null;
        }
        BlockPos pos = this.func_179259_c();
        AEPartLocation location = AEPartLocation.fromOrdinal((int)this.readByte());
        IPartHost host = TileUtil.getTile((IBlockAccess)world, pos, IPartHost.class);
        if (host == null) {
            return null;
        }
        return (P)host.getPart(location);
    }

    public void writeTile(TileEntity tileEntity) {
        if (tileEntity == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.func_179255_a(tileEntity.func_174877_v());
    }

    @Nullable
    public TileEntity readTile(World world) {
        return this.readTile(world, TileEntity.class);
    }

    @Nullable
    public <T> T readTile(World world, Class<T> tileClass) {
        if (!this.readBoolean()) {
            return null;
        }
        BlockPos pos = this.func_179259_c();
        return TileUtil.getTile((IBlockAccess)world, pos, tileClass);
    }

    public void writeAEFluidStacks(IItemList<IAEFluidStack> fluidStackList) throws IOException {
        for (IAEFluidStack stack : fluidStackList) {
            this.writeFluidStack(stack);
        }
    }

    public IItemList<IAEFluidStack> readAEFluidStacks() throws IOException {
        IItemList fluidStackList = StorageChannels.FLUID.createList();
        while (this.readableBytes() > 0) {
            IAEFluidStack fluidStack = this.readFluidStack();
            if (fluidStack == null) continue;
            fluidStackList.add((IAEStack)fluidStack);
        }
        return fluidStackList;
    }
}

