/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.network.packet.part;

import appeng.api.util.AEPartLocation;
import com.the9grounds.aeadditions.container.fluid.ContainerFluidInterface;
import com.the9grounds.aeadditions.gui.gas.GuiFluidInterface;
import com.the9grounds.aeadditions.network.packet.IPacketHandlerClient;
import com.the9grounds.aeadditions.network.packet.Packet;
import com.the9grounds.aeadditions.network.packet.PacketBufferEC;
import com.the9grounds.aeadditions.network.packet.PacketId;
import com.the9grounds.aeadditions.util.GuiUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketFluidInterface
extends Packet {
    FluidStack[] tank;
    String[] filter;

    public PacketFluidInterface(FluidStack[] tank2, String[] filter) {
        this.tank = tank2;
        this.filter = filter;
    }

    @Override
    protected void writeData(PacketBufferEC data) throws IOException {
        int i;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("lengthTank", this.tank.length);
        for (i = 0; i < this.tank.length; ++i) {
            if (this.tank[i] == null) continue;
            tag.func_74782_a("tank#" + i, (NBTBase)this.tank[i].writeToNBT(new NBTTagCompound()));
        }
        tag.func_74768_a("lengthFilter", this.filter.length);
        for (i = 0; i < this.filter.length; ++i) {
            if (this.filter[i] == null) continue;
            tag.func_74778_a("filter#" + i, this.filter[i]);
        }
        data.func_150786_a(tag);
    }

    @Override
    public PacketId getPacketId() {
        return PacketId.FLUID_INTERFACE;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferEC data, EntityPlayer player) throws IOException {
            int i;
            NBTTagCompound tag = data.func_150793_b();
            FluidStack[] tank2 = new FluidStack[tag.func_74762_e("lengthTank")];
            for (int i2 = 0; i2 < tank2.length; ++i2) {
                tank2[i2] = tag.func_74764_b("tank#" + i2) ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("tank#" + i2)) : null;
            }
            String[] filter = new String[tag.func_74762_e("lengthFilter")];
            for (int i3 = 0; i3 < filter.length; ++i3) {
                filter[i3] = tag.func_74764_b("filter#" + i3) ? tag.func_74779_i("filter#" + i3) : "";
            }
            GuiFluidInterface gui = GuiUtil.getGui(GuiFluidInterface.class);
            ContainerFluidInterface container = GuiUtil.getContainer(gui, ContainerFluidInterface.class);
            if (container == null) {
                return;
            }
            for (i = 0; i < tank2.length; ++i) {
                container.fluidInterface.setFluidTank(AEPartLocation.fromOrdinal((int)i), tank2[i]);
            }
            for (i = 0; i < filter.length; ++i) {
                if (gui.filter[i] == null) continue;
                gui.filter[i].setFluid(FluidRegistry.getFluid((String)filter[i]));
            }
        }
    }
}

