/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.tileentity;

import com.the9grounds.aeadditions.tileentity.TileBase;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityCertusTank
extends TileBase {
    private FluidStack lastBeforeUpdate = null;
    public FluidTank tank = new FluidTank(32000){

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            if (!nbt.func_74764_b("Empty")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                this.setFluid(fluid);
            } else {
                this.setFluid(null);
            }
            return this;
        }
    };

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public void compareAndUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            FluidStack current = this.tank.getFluid();
            if (current != null) {
                if (this.lastBeforeUpdate != null) {
                    if (Math.abs(current.amount - this.lastBeforeUpdate.amount) >= 500) {
                        this.updateBlock();
                        this.lastBeforeUpdate = current.copy();
                    } else if (this.lastBeforeUpdate.amount < this.tank.getCapacity() && current.amount == this.tank.getCapacity() || this.lastBeforeUpdate.amount == this.tank.getCapacity() && current.amount < this.tank.getCapacity()) {
                        this.updateBlock();
                        this.lastBeforeUpdate = current.copy();
                    }
                } else {
                    this.updateBlock();
                    this.lastBeforeUpdate = current.copy();
                }
            } else if (this.lastBeforeUpdate != null) {
                this.updateBlock();
                this.lastBeforeUpdate = null;
            }
        }
    }

    public FluidStack drain(FluidStack fluid, boolean doDrain, boolean findMainTank) {
        TileEntity offTE;
        if (findMainTank) {
            Fluid offFluid;
            int yOff = 0;
            TileEntity offTE2 = this.field_145850_b.func_175625_s(this.field_174879_c);
            TileEntityCertusTank mainTank = this;
            while (offTE2 != null && offTE2 instanceof TileEntityCertusTank && (offFluid = ((TileEntityCertusTank)offTE2).getFluid()) != null && offFluid == fluid.getFluid()) {
                mainTank = (TileEntityCertusTank)this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(yOff));
                offTE2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(++yOff));
            }
            return mainTank != null ? mainTank.drain(fluid, doDrain, false) : null;
        }
        FluidStack drained = this.tank.drain(fluid.amount, doDrain);
        this.compareAndUpdate();
        if ((drained == null || drained.amount < fluid.amount) && (offTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof TileEntityCertusTank) {
            TileEntityCertusTank tank2 = (TileEntityCertusTank)offTE;
            FluidStack externallyDrained = tank2.drain(new FluidStack(fluid.getFluid(), fluid.amount - (drained != null ? drained.amount : 0)), doDrain, false);
            if (externallyDrained != null) {
                return new FluidStack(fluid.getFluid(), (drained != null ? drained.amount : 0) + externallyDrained.amount);
            }
            return drained;
        }
        return drained;
    }

    public int fill(FluidStack fluid, boolean doFill, boolean findMainTank) {
        TileEntity offTE;
        if (findMainTank) {
            Fluid offFluid;
            int yOff = 0;
            TileEntity offTE2 = this.field_145850_b.func_175625_s(this.field_174879_c);
            TileEntityCertusTank mainTank = this;
            while (offTE2 != null && offTE2 instanceof TileEntityCertusTank && ((offFluid = ((TileEntityCertusTank)offTE2).getFluid()) == null || offFluid == fluid.getFluid())) {
                mainTank = (TileEntityCertusTank)this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(yOff));
                offTE2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(++yOff));
            }
            return mainTank != null ? mainTank.fill(fluid, doFill, false) : 0;
        }
        int filled = this.tank.fill(fluid, doFill);
        this.compareAndUpdate();
        if (filled < fluid.amount && (offTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) instanceof TileEntityCertusTank) {
            TileEntityCertusTank tank2 = (TileEntityCertusTank)offTE;
            return filled + tank2.fill(new FluidStack(fluid.getFluid(), fluid.amount - filled), doFill, false);
        }
        return filled;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public Fluid getFluid() {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid != null && tankFluid.amount > 0 ? tankFluid.getFluid() : null;
    }

    public Fluid getRenderFluid() {
        return this.tank.getFluid() != null ? this.tank.getFluid().getFluid() : null;
    }

    public float getRenderScale() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public IFluidTankProperties[] getTankInfo(boolean goToMainTank) {
        if (!goToMainTank) {
            return this.tank.getTankProperties();
        }
        int amount = 0;
        int capacity = 0;
        Fluid fluid = null;
        int yOff = 1;
        TileEntity offTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(EnumFacing.DOWN, yOff));
        TileEntityCertusTank mainTank = this;
        while (offTE != null && offTE instanceof TileEntityCertusTank && (((TileEntityCertusTank)offTE).getFluid() == null || this.getFluid() == null || ((TileEntityCertusTank)offTE).getFluid() == this.getFluid())) {
            mainTank = (TileEntityCertusTank)this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(EnumFacing.DOWN, yOff));
            offTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(EnumFacing.DOWN, ++yOff));
        }
        BlockPos posBaseTank = this.field_174879_c.func_177967_a(EnumFacing.DOWN, yOff - 1);
        yOff = 0;
        offTE = this.field_145850_b.func_175625_s(posBaseTank.func_177967_a(EnumFacing.UP, yOff));
        while (offTE != null && offTE instanceof TileEntityCertusTank && ((mainTank = (TileEntityCertusTank)offTE).getFluid() == null || this.getFluid() == null || mainTank.getFluid() == this.getFluid())) {
            IFluidTankProperties info = mainTank.getTankInfo(false)[0];
            if (info != null) {
                capacity += info.getCapacity();
                if (info.getContents() != null) {
                    amount += info.getContents().amount;
                    if (info.getContents().getFluid() != null) {
                        fluid = info.getContents().getFluid();
                    }
                }
            }
            offTE = this.field_145850_b.func_175625_s(posBaseTank.func_177967_a(EnumFacing.UP, ++yOff));
        }
        return new IFluidTankProperties[]{new FluidTankProperties(fluid != null ? new FluidStack(fluid, amount) : null, capacity)};
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readFromNBTWithoutCoords(tag);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tag) {
        this.tank.readFromNBT(tag);
    }

    public void setFluid(FluidStack fluidStack) {
        this.tank.setFluid(fluidStack);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeToNBTWithoutCoords(tag);
        return tag;
    }

    public void writeToNBTWithoutCoords(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return TileEntityCertusTank.this.getTankInfo(true);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || TileEntityCertusTank.this.tank.getFluid() != null && resource.getFluid() != TileEntityCertusTank.this.tank.getFluid().getFluid()) {
                return 0;
            }
            TileEntityCertusTank.this.func_70296_d();
            return TileEntityCertusTank.this.fill(resource, doFill, true);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (TileEntityCertusTank.this.tank.getFluid() == null || resource == null || resource.getFluid() != TileEntityCertusTank.this.tank.getFluid().getFluid()) {
                return null;
            }
            TileEntityCertusTank.this.func_70296_d();
            return TileEntityCertusTank.this.drain(resource, doDrain, true);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (TileEntityCertusTank.this.tank.getFluid() == null) {
                return null;
            }
            TileEntityCertusTank.this.func_70296_d();
            return this.drain(new FluidStack(TileEntityCertusTank.this.tank.getFluid(), maxDrain), doDrain);
        }
    }
}

