/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.tileentity;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import com.the9grounds.aeadditions.api.IECTileEntity;
import com.the9grounds.aeadditions.api.IFluidInterface;
import com.the9grounds.aeadditions.api.crafting.IFluidCraftingPatternDetails;
import com.the9grounds.aeadditions.container.IContainerListener;
import com.the9grounds.aeadditions.container.fluid.ContainerFluidInterface;
import com.the9grounds.aeadditions.crafting.CraftingPattern;
import com.the9grounds.aeadditions.crafting.CraftingPattern2;
import com.the9grounds.aeadditions.gridblock.ECFluidGridBlock;
import com.the9grounds.aeadditions.gui.gas.GuiFluidInterface;
import com.the9grounds.aeadditions.gui.widget.fluid.IFluidSlotListener;
import com.the9grounds.aeadditions.integration.Capabilities;
import com.the9grounds.aeadditions.integration.waila.IWailaTile;
import com.the9grounds.aeadditions.network.IGuiProvider;
import com.the9grounds.aeadditions.registries.ItemEnum;
import com.the9grounds.aeadditions.tileentity.TileBase;
import com.the9grounds.aeadditions.util.AEUtils;
import com.the9grounds.aeadditions.util.EmptyMeItemMonitor;
import com.the9grounds.aeadditions.util.ItemHandlerUtil;
import com.the9grounds.aeadditions.util.ItemUtils;
import com.the9grounds.aeadditions.util.MachineSource;
import com.the9grounds.aeadditions.util.StorageChannels;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityFluidInterface
extends TileBase
implements IActionHost,
IECTileEntity,
IFluidInterface,
IFluidSlotListener,
IStorageMonitorable,
ICraftingProvider,
IWailaTile,
ITickable,
IGuiProvider {
    List<IContainerListener> listeners = new ArrayList<IContainerListener>();
    private ECFluidGridBlock gridBlock;
    private IGridNode node = null;
    public FluidTank[] tanks = new FluidTank[6];
    public String[] fluidFilter = new String[this.tanks.length];
    public IFluidHandler[] fluidHandlers = new IFluidHandler[6];
    public boolean doNextUpdate = false;
    private boolean wasIdle = false;
    private int tickCount = 0;
    private boolean update = false;
    private List<ICraftingPatternDetails> patternHandlers = new ArrayList<ICraftingPatternDetails>();
    private HashMap<ICraftingPatternDetails, IFluidCraftingPatternDetails> patternConvert = new HashMap();
    public final FluidInterfaceInventory inventory;
    private IAEItemStack toExport = null;
    private final Item encodedPattern = AEApi.instance().definitions().items().encodedPattern().maybeItem().orElse(null);
    private List<IAEStack> export = new ArrayList<IAEStack>();
    private List<IAEStack> removeFromExport = new ArrayList<IAEStack>();
    private List<IAEStack> addToExport = new ArrayList<IAEStack>();
    private boolean isFirstGetGridNode = true;
    private boolean markForSave = false;

    public TileEntityFluidInterface() {
        this.inventory = new FluidInterfaceInventory();
        this.gridBlock = new ECFluidGridBlock(this);
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidTank tank2 = this.tanks[i] = new FluidTank(10000){

                public FluidTank readFromNBT(NBTTagCompound nbt) {
                    if (!nbt.func_74764_b("Empty")) {
                        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                        this.setFluid(fluid);
                    } else {
                        this.setFluid(null);
                    }
                    return this;
                }

                protected void onContentsChanged() {
                    TileEntityFluidInterface.this.saveData();
                }
            };
            this.fluidFilter[i] = "";
            this.fluidHandlers[i] = new FluidHandler(tank2, i);
        }
    }

    private void forceUpdate() {
        this.updateBlock();
        for (IContainerListener listener : this.listeners) {
            if (listener == null) continue;
            listener.updateContainer();
        }
        this.doNextUpdate = false;
    }

    public IGridNode getActionableNode() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return null;
        }
        if (this.node == null) {
            this.node = AEApi.instance().grid().createGridNode((IGridBlock)this.gridBlock);
        }
        return this.node;
    }

    public AECableType getCableConnectionType(AEPartLocation aePartLocation) {
        return AECableType.DENSE_SMART;
    }

    @Override
    public Fluid getFilter(AEPartLocation side) {
        if (side == null || side == AEPartLocation.INTERNAL) {
            return null;
        }
        return FluidRegistry.getFluid((String)this.fluidFilter[side.ordinal()]);
    }

    @Override
    public IFluidTank getFluidTank(AEPartLocation side) {
        if (side == null || side == AEPartLocation.INTERNAL) {
            return null;
        }
        return this.tanks[side.ordinal()];
    }

    public IGridNode getGridNode(AEPartLocation dir) {
        if (FMLCommonHandler.instance().getSide().isClient() && (this.field_145850_b == null || this.field_145850_b.field_72995_K)) {
            return null;
        }
        if (this.isFirstGetGridNode) {
            this.isFirstGetGridNode = false;
            this.getActionableNode().updateState();
        }
        return this.node;
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> iStorageChannel) {
        if (iStorageChannel == StorageChannels.ITEM) {
            return new EmptyMeItemMonitor();
        }
        return this.getInventory(AEPartLocation.INTERNAL, iStorageChannel);
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Override
    public IInventory getPatternInventory() {
        return this.inventory;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public List<String> getWailaBody(List<String> list, NBTTagCompound tag, EnumFacing side) {
        int i;
        if (side == null) {
            return list;
        }
        list.add(I18n.func_74838_a((String)("com.the9grounds.aeadditions.tooltip.direction." + side.ordinal())));
        FluidTank[] tanks = new FluidTank[6];
        for (i = 0; i < tanks.length; ++i) {
            tanks[i] = new FluidTank(10000){

                public FluidTank readFromNBT(NBTTagCompound nbt) {
                    if (!nbt.func_74764_b("Empty")) {
                        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                        this.setFluid(fluid);
                    } else {
                        this.setFluid(null);
                    }
                    return this;
                }
            };
        }
        for (i = 0; i < tanks.length; ++i) {
            if (!tag.func_74764_b("tank#" + i)) continue;
            tanks[i].readFromNBT(tag.func_74775_l("tank#" + i));
        }
        FluidTank tank2 = tanks[side.ordinal()];
        if (tank2 == null || tank2.getFluid() == null || tank2.getFluid().getFluid() == null) {
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.fluid") + ": " + I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.empty1"));
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.amount") + ": 0mB / 10000mB");
        } else {
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.fluid") + ": " + tank2.getFluid().getLocalizedName());
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.amount") + ": " + tank2.getFluidAmount() + "mB / 10000mB");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        for (int i = 0; i < this.tanks.length; ++i) {
            tag.func_74782_a("tank#" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public boolean isBusy() {
        return !this.export.isEmpty();
    }

    private ItemStack makeCraftingPatternItem(ICraftingPatternDetails details) {
        if (details == null) {
            return null;
        }
        NBTTagList in = new NBTTagList();
        NBTTagList out = new NBTTagList();
        for (IAEItemStack s : details.getInputs()) {
            if (s == null) {
                in.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            in.func_74742_a((NBTBase)s.createItemStack().func_77955_b(new NBTTagCompound()));
        }
        for (IAEItemStack s : details.getOutputs()) {
            if (s == null) {
                out.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            out.func_74742_a((NBTBase)s.createItemStack().func_77955_b(new NBTTagCompound()));
        }
        NBTTagCompound itemTag = new NBTTagCompound();
        itemTag.func_74782_a("in", (NBTBase)in);
        itemTag.func_74782_a("out", (NBTBase)out);
        itemTag.func_74757_a("crafting", details.isCraftable());
        ItemStack pattern = new ItemStack(this.encodedPattern);
        pattern.func_77982_d(itemTag);
        return pattern;
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeToNBTWithoutExport(new NBTTagCompound());
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.patternHandlers = new ArrayList<ICraftingPatternDetails>();
        this.patternConvert.clear();
        for (ItemStack currentPatternStack : this.inventory.inv) {
            ICraftingPatternDetails p;
            ICraftingPatternItem currentPattern;
            if (currentPatternStack == null || currentPatternStack.func_190926_b() || currentPatternStack.func_77973_b() == null || !(currentPatternStack.func_77973_b() instanceof ICraftingPatternItem) || (currentPattern = (ICraftingPatternItem)currentPatternStack.func_77973_b()).getPatternForItem(currentPatternStack, this.field_145850_b) == null) continue;
            CraftingPattern2 pattern = new CraftingPattern2(currentPattern.getPatternForItem(currentPatternStack, this.field_145850_b));
            this.patternHandlers.add(pattern);
            ItemStack is = this.makeCraftingPatternItem(pattern);
            if (is == null || (p = ((ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.field_145850_b)) == null) continue;
            this.patternConvert.put(p, pattern);
            craftingTracker.addCraftingOption((ICraftingMedium)this, p);
        }
    }

    private void pushItems() {
        EnumFacing[] facings;
        for (IAEStack s : this.removeFromExport) {
            this.export.remove(s);
            this.markForSave = true;
        }
        this.removeFromExport.clear();
        for (IAEStack s : this.addToExport) {
            this.export.add(s);
            this.markForSave = true;
        }
        this.addToExport.clear();
        if (!this.func_145830_o() || this.export.isEmpty()) {
            return;
        }
        for (EnumFacing facing : facings = EnumFacing.field_82609_l) {
            IAEFluidStack fluid;
            IFluidHandler handler;
            int amount;
            TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tile == null) continue;
            IAEStack stack0 = this.export.iterator().next();
            IAEStack stack = stack0.copy();
            if (stack instanceof IAEItemStack) {
                ISidedInventory inv;
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                    ItemStack itemStack;
                    IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                    if (!ItemHandlerUtil.insertItemStack(itemHandler, itemStack = ((IAEItemStack)stack).createItemStack(), false).func_190926_b()) continue;
                    ItemHandlerUtil.insertItemStack(itemHandler, itemStack, true);
                    this.removeFromExport.add(stack0);
                    this.markForSave = true;
                    return;
                }
                if (!(tile instanceof IInventory)) continue;
                if (tile instanceof ISidedInventory) {
                    inv = (ISidedInventory)tile;
                    for (int i : inv.func_180463_a(facing.func_176734_d())) {
                        if (!inv.func_180462_a(i, ((IAEItemStack)stack).createItemStack(), facing.func_176734_d())) continue;
                        if (inv.func_70301_a(i).func_190926_b()) {
                            inv.func_70299_a(i, ((IAEItemStack)stack).createItemStack());
                            this.removeFromExport.add(stack0);
                            this.markForSave = true;
                            return;
                        }
                        if (!ItemUtils.areItemEqualsIgnoreStackSize(inv.func_70301_a(i), ((IAEItemStack)stack).createItemStack())) continue;
                        int max = inv.func_70297_j_();
                        int current = inv.func_70301_a(i).func_190916_E();
                        int outStack = (int)stack.getStackSize();
                        if (max == current) continue;
                        if (current + outStack <= max) {
                            ItemStack s = inv.func_70301_a(i).func_77946_l();
                            s.func_190920_e(s.func_190916_E() + outStack);
                            inv.func_70299_a(i, s);
                            this.removeFromExport.add(stack0);
                            this.markForSave = true;
                            return;
                        }
                        ItemStack s = inv.func_70301_a(i).func_77946_l();
                        s.func_190920_e(max);
                        inv.func_70299_a(i, s);
                        this.removeFromExport.add(stack0);
                        stack.setStackSize((long)(outStack - max + current));
                        this.addToExport.add(stack);
                        this.markForSave = true;
                        return;
                    }
                    continue;
                }
                inv = (IInventory)tile;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    if (!inv.func_94041_b(i, ((IAEItemStack)stack).createItemStack())) continue;
                    if (inv.func_70301_a(i).func_190926_b()) {
                        inv.func_70299_a(i, ((IAEItemStack)stack).createItemStack());
                        this.removeFromExport.add(stack0);
                        this.markForSave = true;
                        return;
                    }
                    if (!ItemUtils.areItemEqualsIgnoreStackSize(inv.func_70301_a(i), ((IAEItemStack)stack).createItemStack())) continue;
                    int max = inv.func_70297_j_();
                    int current = inv.func_70301_a(i).func_190916_E();
                    int outStack = (int)stack.getStackSize();
                    if (max == current) continue;
                    if (current + outStack <= max) {
                        ItemStack s = inv.func_70301_a(i).func_77946_l();
                        s.func_190920_e(s.func_190916_E() + outStack);
                        inv.func_70299_a(i, s);
                        this.removeFromExport.add(stack0);
                        this.markForSave = true;
                        return;
                    }
                    ItemStack s = inv.func_70301_a(i).func_77946_l();
                    s.func_190920_e(max);
                    inv.func_70299_a(i, s);
                    this.removeFromExport.add(stack0);
                    this.markForSave = true;
                    stack.setStackSize((long)(outStack - max + current));
                    this.addToExport.add(stack);
                    this.markForSave = true;
                    return;
                }
                continue;
            }
            if (!(stack instanceof IAEFluidStack) || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) || (amount = (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())).fill((fluid = (IAEFluidStack)stack).getFluidStack().copy(), false)) == 0) continue;
            if ((long)amount == fluid.getStackSize()) {
                handler.fill(fluid.getFluidStack().copy(), true);
                this.removeFromExport.add(stack0);
                this.markForSave = true;
                return;
            }
            IAEFluidStack aeFluidStack = fluid.copy();
            aeFluidStack.setStackSize(aeFluidStack.getStackSize() - (long)amount);
            FluidStack fluidStack = fluid.getFluidStack().copy();
            fluidStack.amount = amount;
            handler.fill(fluidStack, true);
            this.removeFromExport.add(stack0);
            this.addToExport.add((IAEStack)aeFluidStack);
            this.markForSave = true;
            return;
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patDetails, InventoryCrafting table) {
        boolean markForSave = false;
        if (this.isBusy() || !this.patternConvert.containsKey(patDetails)) {
            return false;
        }
        ICraftingPatternDetails patternDetails = this.patternConvert.get(patDetails);
        if (patternDetails instanceof CraftingPattern) {
            IAEFluidStack extractFluid;
            Long amount;
            CraftingPattern patter = (CraftingPattern)patternDetails;
            HashMap<Fluid, Long> fluids = new HashMap<Fluid, Long>();
            for (IAEFluidStack stack : patter.getCondensedFluidInputs()) {
                if (fluids.containsKey(stack.getFluid())) {
                    amount = (Long)fluids.get(stack.getFluid()) + stack.getStackSize();
                    fluids.remove(stack.getFluid());
                    fluids.put(stack.getFluid(), amount);
                    continue;
                }
                fluids.put(stack.getFluid(), stack.getStackSize());
            }
            IGrid grid = this.node.getGrid();
            if (grid == null) {
                return false;
            }
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            if (storage == null) {
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).extractItems((IAEStack)AEUtils.createFluidStack(new FluidStack(fluid, (int)(amount + 0L))), Actionable.SIMULATE, (IActionSource)new MachineSource(this));
                if (extractFluid != null && extractFluid.getStackSize() == amount.longValue()) continue;
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).extractItems((IAEStack)AEUtils.createFluidStack(new FluidStack(fluid, (int)(amount + 0L))), Actionable.MODULATE, (IActionSource)new MachineSource(this));
                this.export.add((IAEStack)extractFluid);
                markForSave = true;
            }
            for (IAEItemStack s : patter.getCondensedInputs()) {
                if (s == null) continue;
                if (s.getItem() == ItemEnum.FLUIDPATTERN.getItem()) {
                    this.toExport = s.copy();
                    continue;
                }
                this.export.add((IAEStack)s);
                markForSave = true;
            }
        }
        if (markForSave) {
            this.func_70296_d();
        }
        return true;
    }

    public void readFilter(NBTTagCompound tag) {
        for (int i = 0; i < this.fluidFilter.length; ++i) {
            if (!tag.func_74764_b("fluid#" + i)) continue;
            this.fluidFilter[i] = tag.func_74779_i("fluid#" + i);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < this.tanks.length; ++i) {
            if (tag.func_74764_b("tank#" + i)) {
                this.tanks[i].readFromNBT(tag.func_74775_l("tank#" + i));
            }
            if (!tag.func_74764_b("filter#" + i)) continue;
            this.fluidFilter[i] = tag.func_74779_i("filter#" + i);
        }
        if (this.func_145830_o()) {
            IGridNode node = this.getGridNode(AEPartLocation.INTERNAL);
            if (tag.func_74764_b("nodes") && node != null) {
                node.loadFromNBT("node0", tag.func_74775_l("nodes"));
                node.updateState();
            }
        }
        if (tag.func_74764_b("inventory")) {
            this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        }
        if (tag.func_74764_b("export")) {
            this.readOutputFromNBT(tag.func_74775_l("export"));
        }
    }

    private void readOutputFromNBT(NBTTagCompound tag) {
        IAEFluidStack s;
        int j;
        this.addToExport.clear();
        this.removeFromExport.clear();
        this.export.clear();
        int i = tag.func_74762_e("remove");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("remove-" + j + "-isItem")) {
                s = AEUtils.createItemStack(new ItemStack(tag.func_74775_l("remove-" + j)));
                s.setStackSize(tag.func_74763_f("remove-" + j + "-amount"));
                this.removeFromExport.add((IAEStack)s);
                continue;
            }
            s = AEUtils.createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("remove-" + j)));
            s.setStackSize(tag.func_74763_f("remove-" + j + "-amount"));
            this.removeFromExport.add((IAEStack)s);
        }
        i = tag.func_74762_e("add");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("add-" + j + "-isItem")) {
                s = AEUtils.createItemStack(new ItemStack(tag.func_74775_l("add-" + j)));
                s.setStackSize(tag.func_74763_f("add-" + j + "-amount"));
                this.addToExport.add((IAEStack)s);
                continue;
            }
            s = AEUtils.createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("add-" + j)));
            s.setStackSize(tag.func_74763_f("add-" + j + "-amount"));
            this.addToExport.add((IAEStack)s);
        }
        i = tag.func_74762_e("export");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("export-" + j + "-isItem")) {
                s = AEUtils.createItemStack(new ItemStack(tag.func_74775_l("export-" + j)));
                s.setStackSize(tag.func_74763_f("export-" + j + "-amount"));
                this.export.add((IAEStack)s);
                continue;
            }
            s = AEUtils.createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("export-" + j)));
            s.setStackSize(tag.func_74763_f("export-" + j + "-amount"));
            this.export.add((IAEStack)s);
        }
    }

    public void registerListener(IContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IContainerListener listener) {
        this.listeners.remove(listener);
    }

    public void securityBreak() {
    }

    @Override
    public void setFilter(AEPartLocation side, Fluid fluid) {
        if (side == null || side == AEPartLocation.INTERNAL) {
            return;
        }
        if (fluid == null) {
            this.fluidFilter[side.ordinal()] = "";
            this.doNextUpdate = true;
            return;
        }
        this.fluidFilter[side.ordinal()] = fluid.getName();
        this.doNextUpdate = true;
    }

    @Override
    public void setFluid(int index, Fluid fluid, EntityPlayer player) {
        this.setFilter(AEPartLocation.fromOrdinal((int)index), fluid);
    }

    @Override
    public void setFluidTank(AEPartLocation side, FluidStack fluid) {
        if (side == null || side == AEPartLocation.INTERNAL) {
            return;
        }
        this.tanks[side.ordinal()].setFluid(fluid);
        this.doNextUpdate = true;
    }

    private void tick() {
        if (this.tickCount < 40 && this.wasIdle) {
            ++this.tickCount;
            return;
        }
        this.tickCount = 0;
        this.wasIdle = true;
        if (this.node == null) {
            return;
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            return;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return;
        }
        IMEMonitor fluidInv = storage.getInventory((IStorageChannel)StorageChannels.FLUID);
        IMEMonitor itemInv = storage.getInventory((IStorageChannel)StorageChannels.ITEM);
        if (this.toExport != null) {
            itemInv.injectItems((IAEStack)this.toExport, Actionable.MODULATE, (IActionSource)new MachineSource(this));
            this.toExport = null;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            int accepted;
            IAEFluidStack extracted;
            FluidStack fluidStack;
            FluidTank tank2 = this.tanks[i];
            FluidStack containedFluid = tank2.getFluid();
            String fluidFilter = this.fluidFilter[i];
            if (containedFluid != null && FluidRegistry.getFluid((String)fluidFilter) != containedFluid.getFluid() && (fluidStack = tank2.drain(125, false)) != null) {
                IAEFluidStack notAdded = (IAEFluidStack)fluidInv.injectItems((IAEStack)AEUtils.createFluidStack(fluidStack.copy()), Actionable.SIMULATE, (IActionSource)new MachineSource(this));
                if (notAdded != null) {
                    int toAdd = (int)((long)fluidStack.amount - notAdded.getStackSize());
                    if (toAdd == 0) continue;
                    fluidInv.injectItems((IAEStack)AEUtils.createFluidStack(tank2.drain(toAdd, true)), Actionable.MODULATE, (IActionSource)new MachineSource(this));
                    this.doNextUpdate = true;
                    this.wasIdle = false;
                } else {
                    fluidInv.injectItems((IAEStack)AEUtils.createFluidStack(tank2.drain(fluidStack.amount, true)), Actionable.MODULATE, (IActionSource)new MachineSource(this));
                    this.doNextUpdate = true;
                    this.wasIdle = false;
                }
            }
            if (containedFluid != null && containedFluid.getFluid() != FluidRegistry.getFluid((String)fluidFilter) || FluidRegistry.getFluid((String)fluidFilter) == null || (extracted = (IAEFluidStack)fluidInv.extractItems((IAEStack)AEUtils.createFluidStack(new FluidStack(FluidRegistry.getFluid((String)fluidFilter), 125)), Actionable.SIMULATE, (IActionSource)new MachineSource(this))) == null || (accepted = tank2.fill(extracted.getFluidStack(), false)) == 0) continue;
            tank2.fill(((IAEFluidStack)fluidInv.extractItems((IAEStack)AEUtils.createFluidStack(new FluidStack(FluidRegistry.getFluid((String)fluidFilter), accepted)), Actionable.MODULATE, (IActionSource)new MachineSource(this))).getFluidStack(), true);
            this.doNextUpdate = true;
            this.wasIdle = false;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.update) {
            this.update = false;
            IGridNode gridNode = this.getGridNode(AEPartLocation.INTERNAL);
            if (gridNode != null && gridNode.getGrid() != null) {
                gridNode.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, gridNode));
            }
        }
        this.pushItems();
        if (this.doNextUpdate) {
            this.forceUpdate();
        }
        this.tick();
        if (this.markForSave) {
            this.markForSave = false;
            this.func_70296_d();
        }
    }

    public NBTTagCompound writeFilter(NBTTagCompound tag) {
        for (int i = 0; i < this.fluidFilter.length; ++i) {
            tag.func_74778_a("fluid#" + i, this.fluidFilter[i]);
        }
        return tag;
    }

    private NBTTagCompound writeOutputToNBT(NBTTagCompound tag) {
        NBTTagCompound data;
        int i = 0;
        for (IAEStack s : this.removeFromExport) {
            if (s != null) {
                tag.func_74757_a("remove-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).createItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("remove-" + i, (NBTBase)data);
                tag.func_74772_a("remove-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("remove", this.removeFromExport.size());
        i = 0;
        for (IAEStack s : this.addToExport) {
            if (s != null) {
                tag.func_74757_a("add-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).createItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("add-" + i, (NBTBase)data);
                tag.func_74772_a("add-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("add", this.addToExport.size());
        i = 0;
        for (IAEStack s : this.export) {
            if (s != null) {
                tag.func_74757_a("export-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).createItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("export-" + i, (NBTBase)data);
                tag.func_74772_a("export-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("export", this.export.size());
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        this.writeToNBTWithoutExport(data);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeOutputToNBT(tag);
        data.func_74782_a("export", (NBTBase)tag);
        return data;
    }

    public NBTTagCompound writeToNBTWithoutExport(NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < this.tanks.length; ++i) {
            tag.func_74782_a("tank#" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
            tag.func_74778_a("filter#" + i, this.fluidFilter[i]);
        }
        if (!this.func_145830_o()) {
            return tag;
        }
        IGridNode node = this.getGridNode(AEPartLocation.INTERNAL);
        if (node != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            node.saveToNBT("node0", nodeTag);
            tag.func_74782_a("nodes", (NBTBase)nodeTag);
        }
        NBTTagCompound inventory2 = new NBTTagCompound();
        this.inventory.writeToNBT(inventory2);
        tag.func_74782_a("inventory", (NBTBase)inventory2);
        return tag;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandlers[facing.ordinal()]);
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return (T)Capabilities.STORAGE_MONITORABLE_ACCESSOR.cast(m -> this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR || super.hasCapability(capability, facing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiFluidInterface(player, this);
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerFluidInterface(player, this);
    }

    private class FluidHandler
    implements IFluidHandler {
        FluidTank fluidTank;
        int filterIndex;

        public FluidHandler(FluidTank fluidTank, int filterIndex) {
            this.fluidTank = fluidTank;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack tankFluid = this.fluidTank.getFluid();
            if (resource == null || tankFluid == null || tankFluid.getFluid() != resource.getFluid()) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack drained = this.fluidTank.drain(maxDrain, doDrain);
            if (drained != null && TileEntityFluidInterface.this.field_145850_b != null) {
                TileEntityFluidInterface.this.updateBlock();
            }
            TileEntityFluidInterface.this.doNextUpdate = true;
            return drained;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.fluidTank.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            if ((this.fluidTank.getFluid() == null || this.fluidTank.getFluid().getFluid() == resource.getFluid()) && resource.getFluid() == FluidRegistry.getFluid((String)TileEntityFluidInterface.this.fluidFilter[this.filterIndex])) {
                int added = this.fluidTank.fill(resource.copy(), doFill);
                if (added == resource.amount) {
                    TileEntityFluidInterface.this.doNextUpdate = true;
                    return added;
                }
                added += this.fillToNetwork(new FluidStack(resource.getFluid(), resource.amount - added), doFill);
                TileEntityFluidInterface.this.doNextUpdate = true;
                return added;
            }
            int filled = 0;
            if ((filled += this.fillToNetwork(resource, doFill)) < resource.amount) {
                filled += this.fluidTank.fill(new FluidStack(resource.getFluid(), resource.amount - filled), doFill);
            }
            if (filled > 0 && TileEntityFluidInterface.this.field_145850_b != null) {
                TileEntityFluidInterface.this.updateBlock();
            }
            TileEntityFluidInterface.this.doNextUpdate = true;
            return filled;
        }

        public int fillToNetwork(FluidStack resource, boolean doFill) {
            IGridNode node = TileEntityFluidInterface.this.getGridNode(AEPartLocation.INTERNAL);
            if (node == null || resource == null) {
                return 0;
            }
            IGrid grid = node.getGrid();
            if (grid == null) {
                return 0;
            }
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            if (storage == null) {
                return 0;
            }
            IAEFluidStack notRemoved = doFill ? (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).injectItems(StorageChannels.FLUID.createStack((Object)resource), Actionable.MODULATE, (IActionSource)new MachineSource(TileEntityFluidInterface.this)) : (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).injectItems(StorageChannels.FLUID.createStack((Object)resource), Actionable.SIMULATE, (IActionSource)new MachineSource(TileEntityFluidInterface.this));
            if (notRemoved == null) {
                return resource.amount;
            }
            return (int)((long)resource.amount - notRemoved.getStackSize());
        }
    }

    public class FluidInterfaceInventory
    implements IInventory {
        private ItemStack[] inv = new ItemStack[9];

        private FluidInterfaceInventory() {
            for (int i = 0; i < this.inv.length; ++i) {
                this.inv[i] = ItemStack.field_190927_a;
            }
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public ItemStack func_70298_a(int slot, int amt) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null && !stack.func_190926_b()) {
                if (stack.func_190916_E() <= amt) {
                    this.func_70299_a(slot, ItemStack.field_190927_a);
                } else if ((stack = stack.func_77979_a(amt)).func_190916_E() == 0) {
                    this.func_70299_a(slot, ItemStack.field_190927_a);
                }
            }
            TileEntityFluidInterface.this.update = true;
            return stack;
        }

        public String func_70005_c_() {
            return "inventory.fluidInterface";
        }

        public int func_70297_j_() {
            return 1;
        }

        public int func_70302_i_() {
            return this.inv.length;
        }

        public ItemStack func_70301_a(int slot) {
            return this.inv[slot];
        }

        @Nullable
        public ItemStack func_70304_b(int index) {
            return ItemStack.field_190927_a;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            if (stack.func_77973_b() instanceof ICraftingPatternItem) {
                ICraftingPatternDetails details = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, TileEntityFluidInterface.this.func_145831_w());
                return details != null;
            }
            return false;
        }

        public boolean func_191420_l() {
            for (int i = 0; i < this.inv.length; ++i) {
                if (this.inv[i] == null || this.inv[i].func_190926_b()) continue;
                return true;
            }
            return false;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_70296_d() {
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = new ItemStack(tag);
            }
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.inv[slot] = stack;
            if (stack != null && !stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            TileEntityFluidInterface.this.update = true;
        }

        public void writeToNBT(NBTTagCompound tagCompound) {
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.inv.length; ++i) {
                ItemStack stack = this.inv[i];
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentString(this.func_70005_c_());
        }
    }
}

