/*
 * Decompiled with CFR 0.152.
 */
package dev.redstudio.alfheim.utils;

import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldChunkSlice {
    private static final int DIAMETER = 5;
    private static final int RADIUS = 2;
    private final int x;
    private final int z;
    private final Chunk[] chunks = new Chunk[25];

    public WorldChunkSlice(IChunkProvider chunkProvider, int x, int z) {
        for (int xDiff = -2; xDiff <= 2; ++xDiff) {
            for (int zDiff = -2; zDiff <= 2; ++zDiff) {
                this.chunks[(xDiff + 2) * 5 + (zDiff + 2)] = chunkProvider.func_186026_b(x + xDiff, z + zDiff);
            }
        }
        this.x = x - 2;
        this.z = z - 2;
    }

    public boolean isLoaded(int x, int z, int radius) {
        int xStart = (x - radius >> 4) - this.x;
        int zStart = (z - radius >> 4) - this.z;
        int xEnd = (x + radius >> 4) - this.x;
        int zEnd = (z + radius >> 4) - this.z;
        for (int currentX = xStart; currentX <= xEnd; ++currentX) {
            for (int currentZ = zStart; currentZ <= zEnd; ++currentZ) {
                if (this.getChunk(currentX, currentZ) != null) continue;
                return false;
            }
        }
        return true;
    }

    public Chunk getChunkFromWorldCoords(int x, int z) {
        return this.getChunk((x >> 4) - this.x, (z >> 4) - this.z);
    }

    private Chunk getChunk(int x, int z) {
        return this.chunks[x * 5 + z];
    }
}

