/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.props.BooleanProperty;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.PublicServerList;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.ServerCreatorBanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ModuleList {
    private List<IModule> modules = new ArrayList<IModule>();
    private Map<String, BooleanProperty> enableValues = new HashMap<String, BooleanProperty>();
    public final ServerCreatorBanner serverCreatorBanner = new ServerCreatorBanner();
    public final PublicServerList publicServerList = new PublicServerList();

    public List<IModule> getEnabled() {
        return this.modules.stream().filter(IModule::isEnabled).collect(Collectors.toList());
    }

    public BooleanProperty getEnabledValue(String moduleId) {
        return this.enableValues.get(moduleId);
    }

    public void initialize() {
        this.modules.add(this.serverCreatorBanner);
        this.modules.add(this.publicServerList);
    }

    public void configure(Configuration config) {
        for (IModule module : this.modules) {
            ConfigCategory category = config.getCategory(module.getId());
            category.setPropertyOrder(new ArrayList());
            Property enabled = (Property)category.getOrDefault((Object)"enabled", (Object)new Property("enabled", Boolean.toString(true), Property.Type.BOOLEAN));
            category.putIfAbsent((Object)"enabled", (Object)enabled);
            this.enableValues.put(module.getId(), new BooleanProperty(enabled));
            module.buildConfigs(category);
        }
        config.save();
    }

    public void reload() {
        ModRef.LOGGER.info("Reloading Configs");
        for (IModule module : this.modules) {
            boolean enabled = this.enableValues.get(module.getId()).getValue();
            if (module.isEnabled() == enabled) continue;
            module.setEnabled(enabled);
        }
    }

    public List<IModule> getAll() {
        return Collections.unmodifiableList(this.modules);
    }
}

