/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.PublicServerList;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.ServerListData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServersScreen;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PublicServerSelectionList
extends GuiListExtended {
    static final Logger LOGGER = LogManager.getLogger();
    static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    static final ResourceLocation ICON_OVERLAY_LOCATION = ModRef.res("textures/publicserverlist/gui/server_select_widgets.png");
    static final Supplier<String> LAST_PLAYED_LABEL = () -> I18n.func_135052_a((String)"modules.public_server_list.last_played_label", (Object[])new Object[0]);
    static final Supplier<String> PUBLIC_SERVERS_LABEL = () -> I18n.func_135052_a((String)"modules.public_server_list.public_servers_label", (Object[])new Object[0]);
    static final Supplier<String> CANT_RESOLVE_TEXT = () -> TextFormatting.DARK_RED + I18n.func_135052_a((String)"multiplayer.status.cannot_resolve", (Object[])new Object[0]);
    static final Supplier<String> CANT_CONNECT_TEXT = () -> TextFormatting.DARK_RED + I18n.func_135052_a((String)"multiplayer.status.cannot_connect", (Object[])new Object[0]);
    static final Supplier<String> INCOMPATIBLE_CLIENT_TOOLTIP = () -> I18n.func_135052_a((String)"multiplayer.status.client_out_of_date", (Object[])new Object[0]);
    static final Supplier<String> INCOMPATIBLE_SERVER_TOOLTIP = () -> I18n.func_135052_a((String)"multiplayer.status.server_out_of_date", (Object[])new Object[0]);
    static final Supplier<String> NO_CONNECTION_TOOLTIP = () -> I18n.func_135052_a((String)"multiplayer.status.no_connection", (Object[])new Object[0]);
    static final Supplier<String> PINGING_TOOLTIP = () -> I18n.func_135052_a((String)"multiplayer.status.pinging", (Object[])new Object[0]);
    static final Supplier<String> NO_SERVER = () -> I18n.func_135052_a((String)"modules.public_server_list.no_servers", (Object[])new Object[0]);
    static final Supplier<String> FIRST_TO_ADD_SERVER = () -> I18n.func_135052_a((String)"modules.public_server_list.first_server", (Object[])new Object[0]);
    private final ThreadPoolExecutor serverPingerThreadPool = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Public Server Pinger #%d").setDaemon(true).build());
    private long ticks = 15L;
    private final PublicServersScreen screen;
    protected final List<ServerData> servers = Lists.newArrayList();
    protected final List<ServerData> allServers = Lists.newArrayList();
    protected final List<ServerData> pingedServers = Lists.newArrayList();
    protected final List<ServerEntry> filteredEntries = Lists.newArrayList();
    private final Header lastPlayedHeader = new Header(LAST_PLAYED_LABEL.get());
    private final Header pingingHeader = new PingingHeader(PUBLIC_SERVERS_LABEL.get());
    private final Header noServersHeader = new Header(NO_SERVER.get(), FIRST_TO_ADD_SERVER.get());
    protected ServerEntry lastJoined;
    protected final Header lastJoinedHeader = new Header(LAST_PLAYED_LABEL.get());
    private boolean noServers;
    protected boolean filterPing;
    protected boolean filterPlayerCount;
    protected String filterName;

    public PublicServerSelectionList(PublicServersScreen parent, Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.screen = parent;
        this.noServersHeader.onClick(this.screen::openHowToPage);
        this.load();
    }

    protected void refreshEntries() {
        Entry lastEntry = this.getSelectedEntry();
        if (!this.noServers) {
            this.filterEntries();
            this.filteredEntries.forEach(entry -> {
                if (lastEntry instanceof ServerEntry && lastEntry != this.lastJoined) {
                    ServerEntry lastServerEntry = (ServerEntry)lastEntry;
                    if (((ServerEntry)lastServerEntry).serverData.field_78845_b.equals(((ServerEntry)entry).serverData.field_78845_b)) {
                        this.setSelected((ServerEntry)entry);
                    }
                }
            });
        }
        if (this.field_148169_q > (float)this.func_148135_f()) {
            this.field_148169_q = this.func_148135_f();
        }
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int i) {
        if (this.lastJoined != null) {
            if (i == 0) {
                return this.lastJoinedHeader;
            }
            if (i == 1) {
                return this.lastJoined;
            }
            if (i == 2) {
                return this.pingingHeader;
            }
            i -= 3;
        }
        if (this.noServers) {
            return this.noServersHeader;
        }
        return this.filteredEntries.get(i);
    }

    protected int func_148127_b() {
        int count = this.filteredEntries.size();
        if (this.lastJoined != null) {
            count += 3;
        }
        if (this.noServers) {
            ++count;
        }
        return count;
    }

    public void filterEntries() {
        this.filteredEntries.clear();
        Stream<ServerEntry> filtering = Lists.newArrayList(this.pingedServers).stream().filter(s -> s.field_78844_e > 0L).map(server -> new ServerEntry(this.screen, (ServerData)server));
        if (!StringUtils.func_151246_b((String)this.filterName)) {
            filtering = filtering.filter(entry -> ((ServerEntry)entry).serverData.field_78847_a.toLowerCase(Locale.ROOT).contains(this.filterName.toLowerCase(Locale.ROOT)));
        }
        Comparator<ServerEntry> sorting = (s1, s2) -> 0;
        if (this.filterPlayerCount) {
            sorting = sorting.thenComparing((s1, s2) -> {
                int p1 = ((ServerEntry)s1).serverData.field_147412_i == null ? 0 : ((ServerEntry)s1).serverData.field_147412_i.split("\n").length;
                int p2 = ((ServerEntry)s2).serverData.field_147412_i == null ? 0 : ((ServerEntry)s2).serverData.field_147412_i.split("\n").length;
                return p2 - p1;
            });
        }
        if (this.filterPing) {
            sorting = sorting.thenComparingLong(s -> ((ServerEntry)s).serverData.field_78844_e);
        }
        filtering = filtering.sorted(sorting);
        List filtered = filtering.collect(Collectors.toList());
        this.filteredEntries.addAll(filtered);
    }

    public void tick() {
        if (this.ticks++ % 20L == 0L) {
            int lastCount = this.allServers.size();
            this.allServers.removeIf(server -> {
                if (server.field_78843_d.equals(CANT_CONNECT_TEXT.get()) || server.field_78843_d.equals(CANT_RESOLVE_TEXT.get())) {
                    return true;
                }
                if (server.field_78844_e > 0L) {
                    this.pingedServers.add((ServerData)server);
                    return true;
                }
                return false;
            });
            if (lastCount != this.allServers.size()) {
                this.refreshEntries();
            }
        }
    }

    protected boolean func_148131_a(int entryId) {
        return this.field_148168_r == entryId;
    }

    public Entry getSelectedEntry() {
        int selected = this.field_148168_r;
        if (selected < 0) {
            return null;
        }
        if (this.lastJoined != null) {
            if (selected == 0) {
                return this.lastJoinedHeader;
            }
            if (selected == 1) {
                return this.lastJoined;
            }
            if (selected == 2) {
                return this.pingingHeader;
            }
            selected -= 3;
        }
        if (this.noServers) {
            if (selected == 0) {
                return this.noServersHeader;
            }
            return null;
        }
        if (selected > this.filteredEntries.size()) {
            return null;
        }
        return this.filteredEntries.get(selected);
    }

    public void setSelected(@Nullable ServerEntry entry) {
        if (this.lastJoined != null && this.lastJoined.equals(entry)) {
            this.field_148168_r = 1;
            this.screen.onSelectedChange();
            return;
        }
        int select = this.filteredEntries.indexOf(entry);
        if (select == -1) {
            select = 0;
        }
        if (this.lastJoined != null) {
            select += 3;
        }
        this.field_148168_r = select;
        this.screen.onSelectedChange();
    }

    public void setNameFilter(String filter) {
        this.filterName = filter;
        this.refreshEntries();
    }

    public void togglePingSort() {
        this.filterPing = !this.filterPing;
        this.refreshEntries();
    }

    public void togglePlayerCountSort() {
        this.filterPlayerCount = !this.filterPlayerCount;
        this.refreshEntries();
    }

    public void updateOnlineServers(ServerListData servers) {
        if (servers.size() == 0) {
            this.noServers = true;
            this.refreshEntries();
            return;
        }
        this.noServers = false;
        this.pingedServers.clear();
        for (int i = 0; i < servers.size(); ++i) {
            ServerData server = servers.get(i);
            this.pingServer(server);
            this.allServers.add(server);
        }
        this.refreshEntries();
    }

    private void pingServer(ServerData server) {
        if (!server.field_78841_f) {
            server.field_78841_f = true;
            server.field_78844_e = -2L;
            server.field_78843_d = "";
            server.field_78846_c = "";
            this.serverPingerThreadPool.submit(() -> {
                try {
                    this.screen.getPinger().func_147224_a(server);
                }
                catch (UnknownHostException unknownhostexception) {
                    server.field_78844_e = -1L;
                    server.field_78843_d = CANT_RESOLVE_TEXT.get();
                }
                catch (Exception exception) {
                    server.field_78844_e = -1L;
                    server.field_78843_d = CANT_CONNECT_TEXT.get();
                }
            });
        }
    }

    protected int func_148137_d() {
        return this.field_148151_d - 6;
    }

    public int func_148139_c() {
        return (int)((float)this.screen.field_146294_l * 0.6f) - 30;
    }

    public void setLastJoined(ServerEntry entry) {
        this.lastJoined = new ServerEntry(this.screen, entry.serverData);
        this.save();
        this.refreshEntries();
    }

    public void save() {
        try {
            File configFolder = GlobalConfigs.MOD_CONFIG_FOLDER;
            CompressedStreamTools.func_74793_a((NBTTagCompound)this.lastJoined.getServerData().func_78836_a(), (File)new File(configFolder, "last_joined.dat"));
        }
        catch (Exception exception) {
            PublicServerList.LOGGER.error("Couldn't save last joined server", (Throwable)exception);
        }
    }

    public void load() {
        try {
            File configFolder = GlobalConfigs.MOD_CONFIG_FOLDER;
            NBTTagCompound tag = CompressedStreamTools.func_74797_a((File)new File(configFolder, "last_joined.dat"));
            if (tag != null) {
                ServerData serverdata = ServerData.func_78837_a((NBTTagCompound)tag);
                this.pingServer(serverdata);
                this.lastJoined = new ServerEntry(this.screen, serverdata);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load last joined server", (Throwable)exception);
        }
    }

    public void stopPingingServer() {
        this.serverPingerThreadPool.shutdownNow();
    }

    public class ServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int ICON_TEX_WIDTH = 64;
        private static final int ICON_TEX_HEIGHT = 64;
        private static final int ICON_OVERLAY_X_PLAY = 0;
        private static final int ICON_OVERLAY_X_ADD = 32;
        private static final int ICON_OVERLAY_Y_UNSELECTED = 0;
        private static final int ICON_OVERLAY_Y_SELECTED = 32;
        private final PublicServersScreen screen;
        private final Minecraft minecraft;
        private final ServerData serverData;
        private final ResourceLocation iconLocation;
        @Nullable
        private String lastIconB64;
        @Nullable
        private DynamicTexture icon;
        protected long lastClickTime;

        protected ServerEntry(PublicServersScreen screen, ServerData data) {
            this.screen = screen;
            this.serverData = data;
            this.minecraft = Minecraft.func_71410_x();
            this.iconLocation = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)data.field_78845_b) + "/icon");
            ITextureObject abstracttexture = this.minecraft.func_110434_K().func_110581_b(this.iconLocation);
            if (abstracttexture instanceof DynamicTexture) {
                this.icon = (DynamicTexture)abstracttexture;
            }
        }

        public void func_192634_a(int slotIndex, int xPos, int yPos, int listWidth, int heightIn, int mouseXIn, int mouseYIn, boolean hovered, float partialTicks) {
            String pingTooltip;
            int signal;
            int mouseOverX = mouseXIn - xPos;
            int mouseOverY = mouseYIn - yPos;
            boolean lowerVersion = this.serverData.field_82821_f > 340;
            boolean higherVersion = this.serverData.field_82821_f < 340;
            boolean invalidVersion = lowerVersion || higherVersion;
            this.minecraft.field_71466_p.func_78276_b(this.serverData.field_78847_a, xPos + 32 + 3, yPos + 1, 0xFFFFFF);
            List list = this.minecraft.field_71466_p.func_78271_c(this.serverData.field_78843_d, listWidth - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                this.minecraft.field_71466_p.func_78276_b((String)list.get(i), xPos + 32 + 3, yPos + 12 + 9 * i, 0x808080);
            }
            String invalidVersionErrorText = invalidVersion ? TextFormatting.DARK_RED + this.serverData.field_82822_g : this.serverData.field_78846_c;
            int textWidth = this.minecraft.field_71466_p.func_78256_a(invalidVersionErrorText);
            this.minecraft.field_71466_p.func_78276_b(invalidVersionErrorText, xPos + listWidth - textWidth - 15 - 2, yPos + 1, 0x808080);
            int signalTexOffset = 0;
            String playerList = null;
            if (invalidVersion) {
                signal = 5;
                pingTooltip = lowerVersion ? INCOMPATIBLE_CLIENT_TOOLTIP.get() : INCOMPATIBLE_SERVER_TOOLTIP.get();
                playerList = this.serverData.field_147412_i;
            } else if (this.serverData.field_78841_f && this.serverData.field_78844_e != -2L) {
                signal = this.serverData.field_78844_e < 0L ? 5 : (this.serverData.field_78844_e < 150L ? 0 : (this.serverData.field_78844_e < 300L ? 1 : (this.serverData.field_78844_e < 600L ? 2 : (this.serverData.field_78844_e < 1000L ? 3 : 4))));
                if (this.serverData.field_78844_e < 0L) {
                    pingTooltip = NO_CONNECTION_TOOLTIP.get();
                } else {
                    pingTooltip = this.serverData.field_78844_e + "ms";
                    playerList = this.serverData.field_147412_i;
                }
            } else {
                signalTexOffset = 1;
                signal = (int)(Minecraft.func_71386_F() / 100L + (long)slotIndex * 2L & 7L);
                if (signal > 4) {
                    signal = 8 - signal;
                }
                pingTooltip = PINGING_TOOLTIP.get();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(Gui.field_110324_m);
            Gui.func_146110_a((int)(xPos + listWidth - 15), (int)yPos, (float)(signalTexOffset * 10), (float)(176 + signal * 8), (int)10, (int)8, (float)256.0f, (float)256.0f);
            String iconString = this.serverData.func_147409_e();
            if (iconString != null && !iconString.equals(this.lastIconB64)) {
                this.lastIconB64 = iconString;
                this.prepareServerIcon();
            }
            if (this.icon == null) {
                this.drawIcon(xPos, yPos, ICON_MISSING);
            } else {
                this.drawIcon(xPos, yPos, this.iconLocation);
            }
            if (mouseOverX >= listWidth - 15 && mouseOverX <= listWidth - 5 && mouseOverY >= 0 && mouseOverY <= 8) {
                this.screen.setTooltip(Collections.singletonList(pingTooltip));
            } else if (mouseOverX >= listWidth - textWidth - 15 - 2 && mouseOverX <= listWidth - 15 - 2 && mouseOverY >= 0 && mouseOverY <= 8 && playerList != null) {
                this.screen.setTooltip(Arrays.stream(playerList.split("\n")).collect(Collectors.toList()));
            }
            if (this.minecraft.field_71474_y.field_85185_A || hovered) {
                this.minecraft.func_110434_K().func_110577_a(ICON_OVERLAY_LOCATION);
                Gui.func_73734_a((int)xPos, (int)yPos, (int)(xPos + 32), (int)(yPos + 32), (int)-1601138544);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.canJoin()) {
                    if (mouseOverX > 16 && mouseOverX < 32) {
                        Gui.func_146110_a((int)xPos, (int)yPos, (float)0.0f, (float)32.0f, (int)32, (int)32, (float)64.0f, (float)64.0f);
                    } else {
                        Gui.func_146110_a((int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)64.0f, (float)64.0f);
                    }
                }
                if (mouseOverX < 16) {
                    Gui.func_146110_a((int)xPos, (int)yPos, (float)32.0f, (float)32.0f, (int)32, (int)32, (float)64.0f, (float)64.0f);
                } else {
                    Gui.func_146110_a((int)xPos, (int)yPos, (float)32.0f, (float)0.0f, (int)32, (int)32, (float)64.0f, (float)64.0f);
                }
            }
        }

        public void func_192633_a(int i, int i1, int i2, float v) {
        }

        public boolean func_148278_a(int index, int mouseX, int mouseY, int mouseEvent, int mouseOverX, int mouseOverY) {
            if ((double)mouseOverX <= 32.0) {
                if ((double)mouseOverX > 16.0 && this.canJoin()) {
                    this.screen.setSelected(this);
                    this.screen.joinSelectedServer();
                    return true;
                }
                if ((double)mouseOverX < 16.0) {
                    this.screen.setSelected(this);
                    this.screen.addSelectedServer();
                }
            }
            this.screen.setSelected(this);
            if (Minecraft.func_71386_F() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
                return true;
            }
            this.lastClickTime = Minecraft.func_71386_F();
            return false;
        }

        public void func_148277_b(int i, int i1, int i2, int i3, int i4, int i5) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepareServerIcon() {
            if (this.serverData.func_147409_e() == null) {
                this.minecraft.func_110434_K().func_147645_c(this.iconLocation);
                this.icon = null;
            } else {
                BufferedImage bufferedimage;
                block9: {
                    ByteBuf bytebuf = Unpooled.copiedBuffer((CharSequence)this.serverData.func_147409_e(), (Charset)StandardCharsets.UTF_8);
                    ByteBuf bytebuf1 = null;
                    try {
                        bytebuf1 = Base64.decode((ByteBuf)bytebuf);
                        bufferedimage = TextureUtil.func_177053_a((InputStream)new ByteBufInputStream(bytebuf1));
                        Validate.validState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                        Validate.validState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("Invalid icon for server {} ({})", (Object)this.serverData.field_78847_a, (Object)this.serverData.field_78845_b, (Object)throwable);
                        this.serverData.func_147407_a(null);
                    }
                    finally {
                        bytebuf.release();
                        if (bytebuf1 != null) {
                            bytebuf1.release();
                        }
                    }
                    return;
                }
                if (this.icon == null) {
                    this.icon = new DynamicTexture(bufferedimage.getWidth(), bufferedimage.getHeight());
                    this.minecraft.func_110434_K().func_110579_a(this.iconLocation, (ITextureObject)this.icon);
                }
                bufferedimage.getRGB(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight(), this.icon.func_110565_c(), 0, bufferedimage.getWidth());
                this.icon.func_110564_a();
            }
        }

        protected void drawIcon(int x, int y, ResourceLocation icon) {
            this.minecraft.func_110434_K().func_110577_a(icon);
            GlStateManager.func_179147_l();
            Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
            GlStateManager.func_179084_k();
        }

        protected boolean canJoin() {
            return true;
        }

        public ServerData getServerData() {
            return this.serverData;
        }
    }

    public class PingingHeader
    extends Header {
        public PingingHeader(String display) {
            super(display);
        }

        @Override
        public void func_192634_a(int slotIndex, int xPos, int yPos, int listWidth, int heightIn, int mouseXIn, int mouseYIn, boolean hovered, float partialTicks) {
            String s;
            super.func_192634_a(slotIndex, xPos, yPos, listWidth, heightIn, mouseXIn, mouseYIn, hovered, partialTicks);
            int drawY = yPos + heightIn / 2 - 4;
            if (PublicServerSelectionList.this.allServers.isEmpty()) {
                return;
            }
            switch ((int)(Minecraft.func_71386_F() / 300L % 4L)) {
                default: {
                    s = "O o o";
                    break;
                }
                case 1: 
                case 3: {
                    s = "o O o";
                    break;
                }
                case 2: {
                    s = "o o O";
                }
            }
            this.minecraft.field_71466_p.func_175065_a(s, (float)(PublicServerSelectionList.this.field_148152_e + PublicServerSelectionList.this.field_148155_a - this.minecraft.field_71466_p.func_78256_a(s) - 7), (float)drawY, 0xFFFFFF, true);
        }
    }

    public static class Header
    extends Entry {
        protected final Minecraft minecraft = Minecraft.func_71410_x();
        protected final String[] displays;
        private Runnable click;

        public Header(String ... displays) {
            this.displays = displays;
        }

        private Header onClick(Runnable onClick) {
            this.click = onClick;
            return this;
        }

        public void func_192634_a(int slotIndex, int xPos, int yPos, int listWidth, int heightIn, int mouseXIn, int mouseYIn, boolean hovered, float partialTicks) {
            int drawY = yPos + heightIn / 2 - this.displays.length * this.minecraft.field_71466_p.field_78288_b / 2;
            for (String display : this.displays) {
                this.minecraft.field_71466_p.func_78276_b(display, xPos + (listWidth - this.minecraft.field_71466_p.func_78256_a(display)) / 2, drawY, 0xFFFFFF);
                drawY += this.minecraft.field_71466_p.field_78288_b;
            }
        }

        public void func_192633_a(int entryID, int insideLeft, int yPos, float partialTicks) {
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            if (this.click != null && mouseEvent == 0) {
                this.click.run();
            }
            return false;
        }

        public void func_148277_b(int i, int i1, int i2, int i3, int i4, int i5) {
        }
    }

    public static abstract class Entry
    implements GuiListExtended.IGuiListEntry {
    }
}

