/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.config;

import com.brandon3055.brandonscore.client.gui.config.BCModConfigGui;
import com.brandon3055.brandonscore.registry.ModConfigParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.GuiSelectString;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class BCGuiConfigEntries
extends GuiConfigEntries {
    public BCGuiConfigEntries(GuiConfig parent, Minecraft mc) {
        super(parent, mc);
        this.func_193651_b(false);
        this.listEntries = new ArrayList();
        for (IConfigElement configElement : parent.configElements) {
            int length;
            if (configElement == null || !configElement.isProperty() || !configElement.showInGui() || (length = !I18n.func_135052_a((String)configElement.getLanguageKey(), (Object[])new Object[0]).equals(configElement.getLanguageKey()) ? mc.field_71466_p.func_78256_a(I18n.func_135052_a((String)configElement.getLanguageKey(), (Object[])new Object[0])) : mc.field_71466_p.func_78256_a(configElement.getName())) <= this.maxLabelTextWidth) continue;
            this.maxLabelTextWidth = length;
        }
        int viewWidth = this.maxLabelTextWidth + 8 + this.field_148155_a / 2;
        this.labelX = this.field_148155_a / 2 - viewWidth / 2;
        this.controlX = this.labelX + this.maxLabelTextWidth + 8;
        this.resetX = this.field_148155_a / 2 + viewWidth / 2 - 45;
        this.controlWidth = this.resetX - this.controlX - 5;
        this.scrollBarX = this.field_148155_a;
        for (IConfigElement configElement : parent.configElements) {
            Property prop;
            if (configElement == null || !configElement.showInGui()) continue;
            Property property = prop = configElement instanceof BCModConfigGui.BCConfigElement ? ((BCModConfigGui.BCConfigElement)configElement).getProp() : null;
            if (configElement.getConfigEntryClass() != null) {
                try {
                    this.listEntries.add(configElement.getConfigEntryClass().getConstructor(GuiConfig.class, BCGuiConfigEntries.class, IConfigElement.class).newInstance(new Object[]{this.owningScreen, this, configElement}));
                }
                catch (Throwable e) {
                    FMLLog.severe((String)"There was a critical error instantiating the custom IConfigEntry for config element %s.", (Object[])new Object[]{configElement.getName()});
                    e.printStackTrace();
                }
                continue;
            }
            if (configElement.isProperty()) {
                if (configElement.isList()) {
                    this.listEntries.add(new ArrayEntry(this.owningScreen, this, configElement, prop));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.BOOLEAN) {
                    this.listEntries.add(new BooleanEntry(this.owningScreen, this, configElement, prop));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.INTEGER) {
                    this.listEntries.add(new IntegerEntry(this.owningScreen, this, configElement, prop));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.DOUBLE) {
                    this.listEntries.add(new DoubleEntry(this.owningScreen, this, configElement, prop));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.COLOR) {
                    if (configElement.getValidValues() != null && configElement.getValidValues().length > 0) {
                        this.listEntries.add(new ChatColorEntry(this.owningScreen, this, configElement, prop));
                        continue;
                    }
                    this.listEntries.add(new StringEntry(this.owningScreen, this, configElement, prop));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.MOD_ID) {
                    TreeMap<Object, String> values = new TreeMap<Object, String>();
                    for (ModContainer mod : Loader.instance().getActiveModList()) {
                        values.put(mod.getModId(), mod.getName());
                    }
                    values.put("minecraft", "Minecraft");
                    this.listEntries.add(new SelectValueEntry(this.owningScreen, this, configElement, values, prop));
                    continue;
                }
                if (configElement.getType() != ConfigGuiType.STRING) continue;
                if (configElement.getValidValues() != null && configElement.getValidValues().length > 0) {
                    this.listEntries.add(new CycleValueEntry(this.owningScreen, this, configElement, prop));
                    continue;
                }
                this.listEntries.add(new StringEntry(this.owningScreen, this, configElement, prop));
                continue;
            }
            if (configElement.getType() != ConfigGuiType.CONFIG_CATEGORY) continue;
            this.listEntries.add(new CategoryEntry(this.owningScreen, this, configElement, prop));
        }
    }

    public void initOverride() {
        this.initGui();
    }

    protected void initGui() {
        this.field_148155_a = this.owningScreen.field_146294_l;
        this.field_148158_l = this.owningScreen.field_146295_m;
        this.maxLabelTextWidth = 0;
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            if (entry.getLabelWidth() <= this.maxLabelTextWidth) continue;
            this.maxLabelTextWidth = entry.getLabelWidth();
        }
        this.field_148153_b = this.owningScreen.titleLine2 != null ? 33 : 23;
        this.field_148154_c = this.owningScreen.field_146295_m - 32;
        this.field_148152_e = 0;
        this.field_148151_d = this.field_148155_a;
        int viewWidth = this.maxLabelTextWidth + 8 + this.field_148155_a / 2;
        this.labelX = this.field_148155_a / 2 - viewWidth / 2;
        this.controlX = this.labelX + this.maxLabelTextWidth + 8;
        this.resetX = this.field_148155_a / 2 + viewWidth / 2 - 45;
        this.maxEntryRightBound = 0;
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            if (entry.getEntryRightBound() <= this.maxEntryRightBound) continue;
            this.maxEntryRightBound = entry.getEntryRightBound();
        }
        this.scrollBarX = this.maxEntryRightBound + 5;
        this.controlWidth = this.maxEntryRightBound - this.controlX - 45;
    }

    public int func_148127_b() {
        return this.listEntries.size();
    }

    public GuiConfigEntries.IConfigEntry getListEntry(int index) {
        return (GuiConfigEntries.IConfigEntry)this.listEntries.get(index);
    }

    public int func_148137_d() {
        return this.scrollBarX;
    }

    public int func_148139_c() {
        return this.owningScreen.field_146294_l;
    }

    public void keyTyped(char eventChar, int eventKey) {
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            entry.keyTyped(eventChar, eventKey);
        }
    }

    public void updateScreen() {
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            entry.updateCursorCounter();
        }
    }

    public void mouseClickedPassThru(int mouseX, int mouseY, int mouseEvent) {
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            entry.mouseClicked(mouseX, mouseY, mouseEvent);
        }
    }

    public void onGuiClosed() {
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            entry.onGuiClosed();
        }
    }

    public boolean saveConfigElements() {
        boolean requiresRestart = false;
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            if (!entry.saveConfigElement()) continue;
            requiresRestart = true;
        }
        return requiresRestart;
    }

    public boolean areAllEntriesDefault(boolean includeChildren) {
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry || entry.isDefault()) continue;
            return false;
        }
        return true;
    }

    public void setAllToDefault(boolean includeChildren) {
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry) continue;
            entry.setToDefault();
        }
    }

    public boolean hasChangedEntry(boolean includeChildren) {
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry || !entry.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean areAnyEntriesEnabled(boolean includeChildren) {
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry || !entry.enabled()) continue;
            return true;
        }
        return false;
    }

    public void undoAllChanges(boolean includeChildren) {
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry) continue;
            entry.undoChanges();
        }
    }

    public void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
        for (GuiConfigEntries.IConfigEntry entry : this.listEntries) {
            entry.drawToolTip(mouseX, mouseY);
        }
    }

    public static abstract class ListEntryBase
    implements GuiConfigEntries.IConfigEntry {
        protected final GuiConfig owningScreen;
        protected final BCGuiConfigEntries owningEntryList;
        protected final IConfigElement configElement;
        protected final Minecraft mc;
        protected final String name;
        protected final GuiButtonExt btnUndoChanges;
        protected final GuiButtonExt btnDefault;
        protected List<String> toolTip;
        protected List<String> undoToolTip;
        protected List<String> defaultToolTip;
        protected boolean isValidValue = true;
        protected HoverChecker tooltipHoverChecker;
        protected HoverChecker undoHoverChecker;
        protected HoverChecker defaultHoverChecker;
        protected boolean drawLabel;
        protected boolean locked = false;
        protected boolean isHovering = false;

        public ListEntryBase(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            this.owningScreen = owningScreen;
            this.owningEntryList = owningEntryList;
            this.configElement = configElement;
            this.mc = Minecraft.func_71410_x();
            String trans = I18n.func_135052_a((String)configElement.getLanguageKey(), (Object[])new Object[0]);
            this.name = !trans.equals(configElement.getLanguageKey()) ? trans : configElement.getName();
            this.btnUndoChanges = new GuiButtonExt(0, 0, 0, 18, 18, "\u21b6");
            this.btnDefault = new GuiButtonExt(0, 0, 0, 18, 18, "\u2604");
            this.undoHoverChecker = new HoverChecker((GuiButton)this.btnUndoChanges, 800);
            this.defaultHoverChecker = new HoverChecker((GuiButton)this.btnDefault, 800);
            this.undoToolTip = Arrays.asList(I18n.func_135052_a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0]));
            this.defaultToolTip = Arrays.asList(I18n.func_135052_a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0]));
            this.toolTip = new ArrayList<String>();
            this.drawLabel = true;
            String comment = I18n.func_135052_a((String)(configElement.getLanguageKey() + ".tooltip"), (Object[])new Object[0]).replace("\\n", "\n");
            if (!comment.equals(configElement.getLanguageKey() + ".tooltip")) {
                Collections.addAll(this.toolTip, (TextFormatting.GREEN + this.name + "\n" + TextFormatting.YELLOW + this.removeTag(comment, "[default:", "]")).split("\n"));
            } else if (configElement.getComment() != null && !configElement.getComment().trim().isEmpty()) {
                Collections.addAll(this.toolTip, (TextFormatting.GREEN + this.name + "\n" + TextFormatting.YELLOW + this.removeTag(configElement.getComment(), "[default:", "]")).split("\n"));
            } else {
                Collections.addAll(this.toolTip, (TextFormatting.GREEN + this.name + "\n" + TextFormatting.RED + "No tooltip defined.").split("\n"));
            }
            if (configElement.getType() == ConfigGuiType.INTEGER && (Integer.valueOf(configElement.getMinValue().toString()) != Integer.MIN_VALUE || Integer.valueOf(configElement.getMaxValue().toString()) != Integer.MAX_VALUE) || configElement.getType() == ConfigGuiType.DOUBLE && (Double.valueOf(configElement.getMinValue().toString()) != -1.7976931348623157E308 || Double.valueOf(configElement.getMaxValue().toString()) != Double.MAX_VALUE)) {
                Collections.addAll(this.toolTip, (TextFormatting.AQUA + I18n.func_135052_a((String)"fml.configgui.tooltip.defaultNumeric", (Object[])new Object[]{configElement.getMinValue(), configElement.getMaxValue(), configElement.getDefault()})).split("\n"));
            } else if (configElement.getType() != ConfigGuiType.CONFIG_CATEGORY) {
                Collections.addAll(this.toolTip, (TextFormatting.AQUA + I18n.func_135052_a((String)"fml.configgui.tooltip.default", (Object[])new Object[]{configElement.getDefault()})).split("\n"));
            }
            if (configElement.requiresMcRestart() || owningScreen.allRequireMcRestart) {
                this.toolTip.add(TextFormatting.RED + "[" + I18n.func_135052_a((String)"fml.configgui.gameRestartTitle", (Object[])new Object[0]) + "]");
            }
            this.locked = property != null && ModConfigParser.isPropLocked(owningScreen.modID, property);
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            boolean isChanged = this.isChanged();
            if (this.drawLabel) {
                String label = (!this.isValidValue ? TextFormatting.RED.toString() : (isChanged ? TextFormatting.WHITE.toString() : TextFormatting.GRAY.toString())) + (isChanged ? TextFormatting.ITALIC.toString() : "") + this.name;
                this.mc.field_71466_p.func_78276_b(label, this.owningScreen.entryList.labelX, y + slotHeight / 2 - this.mc.field_71466_p.field_78288_b / 2, 0xFFFFFF);
            }
            this.btnUndoChanges.field_146128_h = this.owningEntryList.scrollBarX - 44;
            this.btnUndoChanges.field_146129_i = y;
            this.btnUndoChanges.field_146124_l = this.enabled() && isChanged;
            this.btnUndoChanges.func_191745_a(this.mc, mouseX, mouseY, partialTicks);
            this.btnDefault.field_146128_h = this.owningEntryList.scrollBarX - 22;
            this.btnDefault.field_146129_i = y;
            this.btnDefault.field_146124_l = this.enabled() && !this.isDefault();
            this.btnDefault.func_191745_a(this.mc, mouseX, mouseY, partialTicks);
            if (this.tooltipHoverChecker == null) {
                this.tooltipHoverChecker = new HoverChecker(y, y + slotHeight, x, this.owningScreen.entryList.controlX - 8, 800);
            } else {
                this.tooltipHoverChecker.updateBounds(y, y + slotHeight, x, this.owningScreen.entryList.controlX - 8);
            }
            this.isHovering = isSelected;
        }

        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < this.owningScreen.entryList.field_148154_c && mouseY > this.owningScreen.entryList.field_148153_b;
            if (this.toolTip != null && this.tooltipHoverChecker != null && this.tooltipHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.toolTip, mouseX, mouseY);
            }
            if (this.undoHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.undoToolTip, mouseX, mouseY);
            }
            if (this.defaultHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.defaultToolTip, mouseX, mouseY);
            }
            if (this.isHovering && this.locked) {
                this.owningScreen.drawToolTip(Collections.singletonList("This config property is currently controlled by the server you are connected to!"), mouseX, mouseY);
            }
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.locked) {
                return true;
            }
            if (this.btnDefault.func_146116_c(this.mc, x, y)) {
                this.btnDefault.func_146113_a(this.mc.func_147118_V());
                this.setToDefault();
                return true;
            }
            if (this.btnUndoChanges.func_146116_c(this.mc, x, y)) {
                this.btnUndoChanges.func_146113_a(this.mc.func_147118_V());
                this.undoChanges();
                return true;
            }
            return false;
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnDefault.func_146118_a(x, y);
        }

        public abstract boolean isDefault();

        public abstract void setToDefault();

        public abstract void keyTyped(char var1, int var2);

        public abstract void updateCursorCounter();

        public abstract void mouseClicked(int var1, int var2, int var3);

        public abstract boolean isChanged();

        public abstract void undoChanges();

        public abstract boolean saveConfigElement();

        public boolean enabled() {
            return this.owningScreen.isWorldRunning ? !this.owningScreen.allRequireWorldRestart && !this.configElement.requiresWorldRestart() : true;
        }

        public int getLabelWidth() {
            return this.mc.field_71466_p.func_78256_a(this.name);
        }

        public int getEntryRightBound() {
            return this.owningEntryList.resetX + 40;
        }

        public IConfigElement getConfigElement() {
            return this.configElement;
        }

        public String getName() {
            return this.configElement.getName();
        }

        public abstract Object getCurrentValue();

        public abstract Object[] getCurrentValues();

        public void onGuiClosed() {
        }

        private String removeTag(String target, String tagStart, String tagEnd) {
            int tagStartPosition = target.indexOf(tagStart);
            int tagEndPosition = target.indexOf(tagEnd, tagStartPosition + tagStart.length());
            if (-1 == tagStartPosition || -1 == tagEndPosition) {
                return target;
            }
            String taglessResult = target.substring(0, tagStartPosition);
            taglessResult = taglessResult + target.substring(tagEndPosition + 1, target.length());
            return taglessResult;
        }
    }

    public static class CategoryEntry
    extends ListEntryBase {
        protected GuiScreen childScreen = this.buildChildScreen();
        protected final GuiButtonExt btnSelectCategory = new GuiButtonExt(0, 0, 0, 300, 18, I18n.func_135052_a((String)this.name, (Object[])new Object[0]));

        public CategoryEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            super(owningScreen, owningEntryList, configElement, property);
            this.tooltipHoverChecker = new HoverChecker((GuiButton)this.btnSelectCategory, 800);
            this.drawLabel = false;
        }

        protected GuiScreen buildChildScreen() {
            return new BCModConfigGui((GuiScreen)this.owningScreen, this.configElement.getChildElements(), this.owningScreen.modID, this.owningScreen.allRequireWorldRestart || this.configElement.requiresWorldRestart(), this.owningScreen.allRequireMcRestart || this.configElement.requiresMcRestart(), this.owningScreen.title, (this.owningScreen.titleLine2 == null ? "" : this.owningScreen.titleLine2) + " > " + this.name);
        }

        public void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }

        @Override
        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float pt) {
            this.btnSelectCategory.field_146128_h = listWidth / 2 - 150;
            this.btnSelectCategory.field_146129_i = y;
            this.btnSelectCategory.field_146124_l = this.enabled();
            this.btnSelectCategory.func_191745_a(this.mc, mouseX, mouseY, pt);
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, pt);
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < this.owningScreen.entryList.field_148154_c && mouseY > this.owningScreen.entryList.field_148153_b;
            if (this.tooltipHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.toolTip, mouseX, mouseY);
            }
            super.drawToolTip(mouseX, mouseY);
        }

        @Override
        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnSelectCategory.func_146116_c(this.mc, x, y)) {
                this.btnSelectCategory.func_146113_a(this.mc.func_147118_V());
                Minecraft.func_71410_x().func_147108_a(this.childScreen);
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnSelectCategory.func_146118_a(x, y);
        }

        @Override
        public boolean isDefault() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                return ((GuiConfig)this.childScreen).entryList.areAllEntriesDefault(true);
            }
            return true;
        }

        @Override
        public void setToDefault() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                ((GuiConfig)this.childScreen).entryList.setAllToDefault(true);
            }
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }

        @Override
        public boolean saveConfigElement() {
            boolean requiresRestart = false;
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                boolean bl = requiresRestart = this.configElement.requiresMcRestart() && ((GuiConfig)this.childScreen).entryList.hasChangedEntry(true);
                if (((GuiConfig)this.childScreen).entryList.saveConfigElements()) {
                    requiresRestart = true;
                }
            }
            return requiresRestart;
        }

        @Override
        public boolean isChanged() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                return ((GuiConfig)this.childScreen).entryList.hasChangedEntry(true);
            }
            return false;
        }

        @Override
        public void undoChanges() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                ((GuiConfig)this.childScreen).entryList.undoAllChanges(true);
            }
        }

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public int getLabelWidth() {
            return 0;
        }

        @Override
        public int getEntryRightBound() {
            return this.owningEntryList.field_148155_a / 2 + 155 + 22 + 18;
        }

        @Override
        public String getCurrentValue() {
            return "";
        }

        public String[] getCurrentValues() {
            return new String[]{this.getCurrentValue()};
        }
    }

    public static class StringEntry
    extends ListEntryBase {
        protected final GuiTextField textFieldValue;
        protected final String beforeValue;

        public StringEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            super(owningScreen, owningEntryList, configElement, property);
            this.beforeValue = configElement.get().toString();
            this.textFieldValue = new GuiTextField(10, this.mc.field_71466_p, this.owningEntryList.controlX + 1, 0, this.owningEntryList.controlWidth - 3, 16);
            this.textFieldValue.func_146203_f(10000);
            this.textFieldValue.func_146180_a(configElement.get().toString());
        }

        public void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }

        @Override
        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float pt) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, pt);
            this.textFieldValue.field_146209_f = this.owningEntryList.controlX + 2;
            this.textFieldValue.field_146210_g = y + 1;
            this.textFieldValue.field_146218_h = this.owningEntryList.controlWidth - 4;
            this.textFieldValue.func_146184_c(this.enabled() && !this.locked);
            this.textFieldValue.func_146194_f();
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                this.textFieldValue.func_146201_a(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                if (this.configElement.getValidationPattern() != null) {
                    this.isValidValue = this.configElement.getValidationPattern().matcher(this.textFieldValue.func_146179_b().trim()).matches();
                }
            }
        }

        @Override
        public void updateCursorCounter() {
            this.textFieldValue.func_146178_a();
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textFieldValue.func_146192_a(x, y, mouseEvent);
        }

        @Override
        public boolean isDefault() {
            return this.configElement.getDefault() != null ? this.configElement.getDefault().toString().equals(this.textFieldValue.func_146179_b()) : this.textFieldValue.func_146179_b().trim().isEmpty();
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.textFieldValue.func_146180_a(this.configElement.getDefault().toString());
                this.keyTyped('\u0000', 199);
            }
        }

        @Override
        public boolean isChanged() {
            return this.beforeValue != null ? !this.beforeValue.equals(this.textFieldValue.func_146179_b()) : this.textFieldValue.func_146179_b().trim().isEmpty();
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.func_146180_a(this.beforeValue);
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    this.configElement.set((Object)this.textFieldValue.func_146179_b());
                    return this.configElement.requiresMcRestart();
                }
                if (this.isChanged() && !this.isValidValue) {
                    this.configElement.setToDefault();
                    return this.configElement.requiresMcRestart() && this.beforeValue != null ? this.beforeValue.equals(this.configElement.getDefault()) : this.configElement.getDefault() == null;
                }
            }
            return false;
        }

        @Override
        public Object getCurrentValue() {
            return this.textFieldValue.func_146179_b();
        }

        @Override
        public Object[] getCurrentValues() {
            return new Object[]{this.getCurrentValue()};
        }
    }

    public static class DoubleEntry
    extends StringEntry {
        protected final double beforeValue;

        public DoubleEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            super(owningScreen, owningEntryList, configElement, property);
            this.beforeValue = Double.valueOf(configElement.get().toString());
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.func_146179_b();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.func_146198_h() == 0 && eventChar == '-' || !before.contains(".") && eventChar == '.' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.func_146201_a(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.func_146179_b().trim().isEmpty() && !this.textFieldValue.func_146179_b().trim().equals("-")) {
                        try {
                            double value = Double.parseDouble(this.textFieldValue.func_146179_b().trim());
                            if (value < Double.valueOf(this.configElement.getMinValue().toString()) || value > Double.valueOf(this.configElement.getMaxValue().toString())) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public boolean isChanged() {
            try {
                return this.beforeValue != Double.parseDouble(this.textFieldValue.func_146179_b().trim());
            }
            catch (Throwable e) {
                return true;
            }
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.func_146180_a(String.valueOf(this.beforeValue));
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    try {
                        double value = Double.parseDouble(this.textFieldValue.func_146179_b().trim());
                        this.configElement.set((Object)value);
                        return this.configElement.requiresMcRestart();
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                } else if (this.isChanged() && !this.isValidValue) {
                    try {
                        double value = Double.parseDouble(this.textFieldValue.func_146179_b().trim());
                        if (value < Double.valueOf(this.configElement.getMinValue().toString())) {
                            this.configElement.set(this.configElement.getMinValue());
                        } else {
                            this.configElement.set(this.configElement.getMaxValue());
                        }
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                }
                return this.configElement.requiresMcRestart() && this.beforeValue != Double.parseDouble(this.configElement.get().toString());
            }
            return false;
        }
    }

    public static class IntegerEntry
    extends StringEntry {
        protected final int beforeValue;

        public IntegerEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            super(owningScreen, owningEntryList, configElement, property);
            this.beforeValue = Integer.valueOf(configElement.get().toString());
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.func_146179_b();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.func_146198_h() == 0 && eventChar == '-' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.func_146201_a(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.func_146179_b().trim().isEmpty() && !this.textFieldValue.func_146179_b().trim().equals("-")) {
                        try {
                            long value = Long.parseLong(this.textFieldValue.func_146179_b().trim());
                            if (value < (long)Integer.valueOf(this.configElement.getMinValue().toString()).intValue() || value > (long)Integer.valueOf(this.configElement.getMaxValue().toString()).intValue()) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public boolean isChanged() {
            try {
                return this.beforeValue != Integer.parseInt(this.textFieldValue.func_146179_b().trim());
            }
            catch (Throwable e) {
                return true;
            }
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.func_146180_a(String.valueOf(this.beforeValue));
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    try {
                        int value = Integer.parseInt(this.textFieldValue.func_146179_b().trim());
                        this.configElement.set((Object)value);
                        return this.configElement.requiresMcRestart();
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                } else if (this.isChanged() && !this.isValidValue) {
                    try {
                        int value = Integer.parseInt(this.textFieldValue.func_146179_b().trim());
                        if (value < Integer.valueOf(this.configElement.getMinValue().toString())) {
                            this.configElement.set(this.configElement.getMinValue());
                        } else {
                            this.configElement.set(this.configElement.getMaxValue());
                        }
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                }
                return this.configElement.requiresMcRestart() && this.beforeValue != Integer.parseInt(this.configElement.get().toString());
            }
            return false;
        }
    }

    public static abstract class ButtonEntry
    extends ListEntryBase {
        protected final GuiButtonExt btnValue;

        public ButtonEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            this(owningScreen, owningEntryList, configElement, new GuiButtonExt(0, owningEntryList.controlX, 0, owningEntryList.controlWidth, 18, configElement.get() != null ? I18n.func_135052_a((String)String.valueOf(configElement.get()), (Object[])new Object[0]) : ""), property);
        }

        public ButtonEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, GuiButtonExt button, Property property) {
            super(owningScreen, owningEntryList, configElement, property);
            this.btnValue = button;
        }

        public abstract void updateValueButtonText();

        public abstract void valueButtonPressed(int var1);

        @Override
        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float pt) {
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, pt);
            this.btnValue.field_146120_f = this.owningEntryList.controlWidth;
            this.btnValue.field_146128_h = this.owningScreen.entryList.controlX;
            this.btnValue.field_146129_i = y;
            this.btnValue.field_146124_l = this.enabled() && !this.locked;
            this.btnValue.func_191745_a(this.mc, mouseX, mouseY, pt);
        }

        @Override
        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.locked) {
                return true;
            }
            if (this.btnValue.func_146116_c(this.mc, x, y)) {
                this.btnValue.func_146113_a(this.mc.func_147118_V());
                this.valueButtonPressed(index);
                this.updateValueButtonText();
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            super.func_148277_b(index, x, y, mouseEvent, relativeX, relativeY);
            this.btnValue.func_146118_a(x, y);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }
    }

    public static class NumberSliderEntry
    extends ButtonEntry {
        protected final double beforeValue;

        public NumberSliderEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            super(owningScreen, owningEntryList, configElement, (GuiButtonExt)new GuiSlider(0, owningEntryList.controlX, 0, owningEntryList.controlWidth, 18, "", "", Double.valueOf(configElement.getMinValue().toString()).doubleValue(), Double.valueOf(configElement.getMaxValue().toString()).doubleValue(), Double.valueOf(configElement.get().toString()).doubleValue(), configElement.getType() == ConfigGuiType.DOUBLE, true), property);
            this.beforeValue = configElement.getType() == ConfigGuiType.INTEGER ? (double)Integer.valueOf(configElement.get().toString()).intValue() : Double.valueOf(configElement.get().toString());
        }

        @Override
        public void updateValueButtonText() {
            ((GuiSlider)this.btnValue).updateSlider();
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
        }

        @Override
        public boolean isDefault() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt() == Integer.valueOf(this.configElement.getDefault().toString()).intValue();
            }
            return ((GuiSlider)this.btnValue).getValue() == Double.valueOf(this.configElement.getDefault().toString()).doubleValue();
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                ((GuiSlider)this.btnValue).setValue(Double.valueOf(this.configElement.getDefault().toString()).doubleValue());
                ((GuiSlider)this.btnValue).updateSlider();
            }
        }

        @Override
        public boolean isChanged() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt() != (int)Math.round(this.beforeValue);
            }
            return ((GuiSlider)this.btnValue).getValue() != this.beforeValue;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                ((GuiSlider)this.btnValue).setValue(this.beforeValue);
                ((GuiSlider)this.btnValue).updateSlider();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                    this.configElement.set((Object)((GuiSlider)this.btnValue).getValueInt());
                } else {
                    this.configElement.set((Object)((GuiSlider)this.btnValue).getValue());
                }
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public Object getCurrentValue() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt();
            }
            return ((GuiSlider)this.btnValue).getValue();
        }

        @Override
        public Object[] getCurrentValues() {
            return new Object[]{this.getCurrentValue()};
        }

        public void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }
    }

    public static class ArrayEntry
    extends ButtonEntry {
        protected final Object[] beforeValues;
        protected Object[] currentValues;

        public ArrayEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            super(owningScreen, owningEntryList, configElement, property);
            this.beforeValues = configElement.getList();
            this.currentValues = configElement.getList();
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.field_146126_j = "";
            for (Object o : this.currentValues) {
                this.btnValue.field_146126_j = this.btnValue.field_146126_j + ", [" + o + "]";
            }
            this.btnValue.field_146126_j = this.btnValue.field_146126_j.replaceFirst(", ", "");
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            this.mc.func_147108_a((GuiScreen)new GuiEditArray((GuiScreen)this.owningScreen, this.configElement, slotIndex, this.currentValues, this.enabled()){

                public GuiScreen getParent() {
                    return this.parentScreen;
                }

                public int getSlotIndex() {
                    return this.slotIndex;
                }

                public void func_73866_w_() {
                    this.entryList = new GuiEditArrayEntries(this, this.field_146297_k, this.configElement, this.beforeValues, this.currentValues){

                        protected void saveListChanges() {
                            int listLength;
                            int n = listLength = this.configElement.isListLengthFixed() ? this.listEntries.size() : this.listEntries.size() - 1;
                            if (this.getSlotIndex() != -1 && this.getParent() != null && this.getParent() instanceof GuiConfig && ((GuiConfig)this.getParent()).entryList.getListEntry(this.getSlotIndex()) instanceof ArrayEntry) {
                                ArrayEntry entry = (ArrayEntry)((GuiConfig)this.getParent()).entryList.getListEntry(this.getSlotIndex());
                                Object[] ao = new Object[listLength];
                                for (int i = 0; i < listLength; ++i) {
                                    ao[i] = ((GuiEditArrayEntries.IArrayEntry)this.listEntries.get(i)).getValue();
                                }
                                entry.setListFromChildScreen(ao);
                            } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.BOOLEAN) {
                                Object[] abol = new Boolean[listLength];
                                for (int i = 0; i < listLength; ++i) {
                                    abol[i] = Boolean.valueOf(((GuiEditArrayEntries.IArrayEntry)this.listEntries.get(i)).getValue().toString());
                                }
                                this.configElement.set(abol);
                            } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.INTEGER) {
                                Object[] ai = new Integer[listLength];
                                for (int i = 0; i < listLength; ++i) {
                                    ai[i] = Integer.valueOf(((GuiEditArrayEntries.IArrayEntry)this.listEntries.get(i)).getValue().toString());
                                }
                                this.configElement.set(ai);
                            } else if (this.configElement.isList() && this.configElement.getType() == ConfigGuiType.DOUBLE) {
                                Object[] ad = new Double[listLength];
                                for (int i = 0; i < listLength; ++i) {
                                    ad[i] = Double.valueOf(((GuiEditArrayEntries.IArrayEntry)this.listEntries.get(i)).getValue().toString());
                                }
                                this.configElement.set(ad);
                            } else if (this.configElement.isList()) {
                                Object[] as = new String[listLength];
                                for (int i = 0; i < listLength; ++i) {
                                    as[i] = ((GuiEditArrayEntries.IArrayEntry)this.listEntries.get(i)).getValue().toString();
                                }
                                this.configElement.set(as);
                            }
                        }
                    };
                    int undoGlyphWidth = this.field_146297_k.field_71466_p.func_78256_a("\u21b6") * 2;
                    int resetGlyphWidth = this.field_146297_k.field_71466_p.func_78256_a("\u2604") * 2;
                    int doneWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])) + 20, 100);
                    int undoWidth = this.field_146297_k.field_71466_p.func_78256_a(" " + I18n.func_135052_a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0])) + undoGlyphWidth + 20;
                    int resetWidth = this.field_146297_k.field_71466_p.func_78256_a(" " + I18n.func_135052_a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0])) + resetGlyphWidth + 20;
                    int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth) / 2;
                    this.btnDone = new GuiButtonExt(2000, this.field_146294_l / 2 - buttonWidthHalf, this.field_146295_m - 29, doneWidth, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
                    this.field_146292_n.add(this.btnDone);
                    this.btnDefault = new GuiUnicodeGlyphButton(2001, this.field_146294_l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.field_146295_m - 29, resetWidth, 20, " " + I18n.func_135052_a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0]), "\u2604", 2.0f);
                    this.field_146292_n.add(this.btnDefault);
                    this.btnUndoChanges = new GuiUnicodeGlyphButton(2002, this.field_146294_l / 2 - buttonWidthHalf + doneWidth + 5, this.field_146295_m - 29, undoWidth, 20, " " + I18n.func_135052_a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0]), "\u21b6", 2.0f);
                    this.field_146292_n.add(this.btnUndoChanges);
                }
            });
        }

        public void setListFromChildScreen(Object[] newList) {
            if (this.enabled() && !Arrays.deepEquals(this.currentValues, newList)) {
                this.currentValues = newList;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            return Arrays.deepEquals(this.configElement.getDefaults(), this.currentValues);
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValues = this.configElement.getDefaults();
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return !Arrays.deepEquals(this.beforeValues, this.currentValues);
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValues = this.beforeValues;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set(this.currentValues);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public Object getCurrentValue() {
            return this.btnValue.field_146126_j;
        }

        @Override
        public Object[] getCurrentValues() {
            return this.currentValues;
        }

        public void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }
    }

    public static class SelectValueEntry
    extends ButtonEntry {
        protected final String beforeValue;
        protected Object currentValue;
        protected Map<Object, String> selectableValues;

        public SelectValueEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Map<Object, String> selectableValues, Property property) {
            super(owningScreen, owningEntryList, configElement, property);
            this.beforeValue = configElement.get().toString();
            this.currentValue = configElement.get().toString();
            this.selectableValues = selectableValues;
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.field_146126_j = this.currentValue.toString();
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            this.mc.func_147108_a((GuiScreen)new GuiSelectString((GuiScreen)this.owningScreen, this.configElement, slotIndex, this.selectableValues, this.currentValue, this.enabled()));
        }

        public void setValueFromChildScreen(Object newValue) {
            if (this.enabled() && this.currentValue != null ? !this.currentValue.equals(newValue) : newValue != null) {
                this.currentValue = newValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            if (this.configElement.getDefault() != null) {
                return this.configElement.getDefault().equals(this.currentValue);
            }
            return this.currentValue == null;
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = this.configElement.getDefault().toString();
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            if (this.beforeValue != null) {
                return !this.beforeValue.equals(this.currentValue);
            }
            return this.currentValue == null;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set(this.currentValue);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public String getCurrentValue() {
            return this.currentValue.toString();
        }

        public String[] getCurrentValues() {
            return new String[]{this.getCurrentValue()};
        }

        public void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }
    }

    public static class ChatColorEntry
    extends CycleValueEntry {
        ChatColorEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            super(owningScreen, owningEntryList, configElement, property);
            this.btnValue.field_146124_l = this.enabled();
            this.updateValueButtonText();
        }

        @Override
        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float pt) {
            this.btnValue.packedFGColour = GuiUtils.getColorCode((char)this.configElement.getValidValues()[this.currentIndex].charAt(0), (boolean)true);
            super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, pt);
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.field_146126_j = I18n.func_135052_a((String)this.configElement.getValidValues()[this.currentIndex], (Object[])new Object[0]) + " - " + I18n.func_135052_a((String)"fml.configgui.sampletext", (Object[])new Object[0]);
        }
    }

    public static class CycleValueEntry
    extends ButtonEntry {
        protected final int beforeIndex;
        protected final int defaultIndex;
        protected int currentIndex;

        private CycleValueEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            super(owningScreen, owningEntryList, configElement, property);
            this.beforeIndex = this.getIndex(configElement.get().toString());
            this.defaultIndex = this.getIndex(configElement.getDefault().toString());
            this.currentIndex = this.beforeIndex;
            this.btnValue.field_146124_l = this.enabled();
            this.updateValueButtonText();
        }

        private int getIndex(String s) {
            for (int i = 0; i < this.configElement.getValidValues().length; ++i) {
                if (!this.configElement.getValidValues()[i].equalsIgnoreCase(s)) continue;
                return i;
            }
            return 0;
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.field_146126_j = I18n.func_135052_a((String)this.configElement.getValidValues()[this.currentIndex], (Object[])new Object[0]);
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                if (++this.currentIndex >= this.configElement.getValidValues().length) {
                    this.currentIndex = 0;
                }
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            return this.currentIndex == this.defaultIndex;
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentIndex = this.defaultIndex;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return this.currentIndex != this.beforeIndex;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentIndex = this.beforeIndex;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set((Object)this.configElement.getValidValues()[this.currentIndex]);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public String getCurrentValue() {
            return this.configElement.getValidValues()[this.currentIndex];
        }

        public String[] getCurrentValues() {
            return new String[]{this.getCurrentValue()};
        }

        public void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }
    }

    public static class BooleanEntry
    extends ButtonEntry {
        protected final boolean beforeValue;
        protected boolean currentValue;

        private BooleanEntry(GuiConfig owningScreen, BCGuiConfigEntries owningEntryList, IConfigElement configElement, Property property) {
            super(owningScreen, owningEntryList, configElement, property);
            this.currentValue = this.beforeValue = Boolean.valueOf(configElement.get().toString()).booleanValue();
            this.btnValue.field_146124_l = this.enabled();
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.field_146126_j = I18n.func_135052_a((String)String.valueOf(this.currentValue), (Object[])new Object[0]);
            this.btnValue.packedFGColour = this.currentValue ? GuiUtils.getColorCode((char)'2', (boolean)true) : GuiUtils.getColorCode((char)'4', (boolean)true);
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                this.currentValue = !this.currentValue;
            }
        }

        @Override
        public boolean isDefault() {
            return this.currentValue == Boolean.valueOf(this.configElement.getDefault().toString());
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = Boolean.valueOf(this.configElement.getDefault().toString());
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return this.currentValue != this.beforeValue;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set((Object)this.currentValue);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public Boolean getCurrentValue() {
            return this.currentValue;
        }

        public Boolean[] getCurrentValues() {
            return new Boolean[]{this.getCurrentValue()};
        }

        public void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }
    }
}

