/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.config;

import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.MultilinePolicy;
import carbonconfiglib.utils.SyncType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectLinkedOpenHashMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;

public class Config {
    private String name;
    private Object2ObjectMap<String, ConfigSection> sections = new Object2ObjectLinkedOpenHashMap<String, ConfigSection>();

    public Config(String name) {
        if (Helpers.validateString(name)) {
            throw new IllegalArgumentException("Config name must not be null, empty or start/end with white spaces");
        }
        this.name = name;
    }

    public ConfigSection add(ConfigSection section) {
        if (section.getParent() != null) {
            throw new IllegalStateException("ConfigSection must not be added to multiple sections. Section: " + section.getName());
        }
        this.sections.putIfAbsent(section.getName(), section);
        return section;
    }

    public ConfigSection add(String name) {
        return this.sections.computeIfAbsent(name, ConfigSection::new).setUsed();
    }

    public ConfigSection getSection(String name) {
        return (ConfigSection)this.sections.get(name);
    }

    ConfigSection getSectionRecursive(String[] names) {
        if (names.length == 0) {
            return null;
        }
        ConfigSection section = this.sections.computeIfAbsent(names[0], ConfigSection::new);
        for (int i = 1; i < names.length && section != null; section = section.parseSubSection(names[i]), ++i) {
        }
        return section;
    }

    public List<ConfigSection> getChildren() {
        return new ObjectArrayList<ConfigSection>((ObjectCollection<ConfigSection>)this.sections.values());
    }

    public Map<String, ConfigEntry<?>> getSyncedEntries(SyncType type) {
        if (type == SyncType.NONE) {
            return Collections.emptyMap();
        }
        Object2ObjectLinkedOpenHashMap result = new Object2ObjectLinkedOpenHashMap();
        for (ConfigSection section : this.sections.values()) {
            section.getSyncedEntries(result, type);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Config copy() {
        Config config = new Config(this.name);
        for (ConfigSection sub : this.sections.values()) {
            config.add(sub.copy());
        }
        return config;
    }

    public void resetDefault() {
        this.sections.values().forEach(ConfigSection::resetDefault);
    }

    public boolean hasChanged() {
        for (ConfigSection section : this.sections.values()) {
            if (!section.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean isDefault() {
        for (ConfigSection section : this.sections.values()) {
            if (section.isDefault()) continue;
            return false;
        }
        return true;
    }

    public String serialize(MultilinePolicy policy) {
        if (this.sections.size() == 0) {
            return "";
        }
        StringJoiner joiner = new StringJoiner("\n\n");
        for (ConfigSection section : this.sections.values()) {
            String val = section.serialize(policy);
            if (val == null) continue;
            joiner.add(val);
        }
        return joiner.toString();
    }
}

