/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.carbon;

import carbonconfiglib.api.IReloadMode;
import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.impl.carbon.IValueActions;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.text.ITextComponent;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.utils.Stack;

public class CarbonValue
implements IValueNode,
IValueActions {
    IReloadMode mode;
    ITextComponent name;
    ITextComponent tooltip;
    DataType type;
    boolean forced;
    Supplier<List<ISuggestionProvider.Suggestion>> suggestions;
    Function<String, ParseResult<Boolean>> isValid;
    BiConsumer<String, IValueActions> saveAction;
    Stack<String> previous = new ObjectArrayList<String>();
    String current;
    String defaultValue;

    public CarbonValue(IReloadMode mode, ITextComponent name, ITextComponent tooltip, DataType type, boolean forced, Supplier<List<ISuggestionProvider.Suggestion>> suggestions, String current, String defaultValue, Function<String, ParseResult<Boolean>> isValid, BiConsumer<String, IValueActions> saveAction) {
        this.mode = mode;
        this.name = name;
        this.tooltip = tooltip;
        this.type = type;
        this.forced = forced;
        this.suggestions = suggestions;
        this.isValid = isValid;
        this.saveAction = saveAction;
        this.current = current;
        this.defaultValue = defaultValue;
        this.previous.push(current);
    }

    @Override
    public void save() {
        this.saveAction.accept(this.current, this);
    }

    @Override
    public boolean isDefault() {
        return Objects.equals(this.defaultValue, this.current);
    }

    @Override
    public boolean isChanged() {
        return !Objects.equals(this.previous.top(), this.current);
    }

    @Override
    public void setDefault() {
        this.current = this.defaultValue;
    }

    @Override
    public void setPrevious() {
        this.current = this.previous.top();
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
    }

    @Override
    public void createTemp() {
        this.previous.push(this.current);
    }

    @Override
    public void apply() {
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
    }

    @Override
    public IStructuredData.StructureType getNodeType() {
        return IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public boolean requiresRestart() {
        return this.mode == ReloadMode.GAME;
    }

    @Override
    public boolean requiresReload() {
        return this.mode == ReloadMode.WORLD;
    }

    @Override
    public ITextComponent getName() {
        return this.name;
    }

    @Override
    public ITextComponent getTooltip() {
        return this.tooltip;
    }

    @Override
    public String get() {
        return this.current;
    }

    @Override
    public void set(String value) {
        this.current = value;
    }

    @Override
    public ParseResult<Boolean> isValid(String value) {
        return this.isValid.apply(value);
    }

    @Override
    public DataType getDataType() {
        return this.type;
    }

    @Override
    public boolean isForcingSuggestions() {
        return this.forced;
    }

    @Override
    public List<ISuggestionProvider.Suggestion> getSuggestions() {
        return this.suggestions.get();
    }
}

