/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.carbon;

import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.gui.api.IConfigFolderNode;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.impl.carbon.ConfigLeaf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ConfigNode
implements IConfigFolderNode {
    ConfigSection section;
    List<IConfigNode> children;

    public ConfigNode(ConfigSection section) {
        this.section = section;
    }

    @Override
    public List<IConfigNode> getChildren() {
        if (this.children == null) {
            this.children = new ObjectArrayList();
            for (ConfigSection configSection : this.section.getChildren()) {
                this.children.add(new ConfigNode(configSection));
            }
            for (ConfigEntry configEntry : this.section.getEntries()) {
                this.children.add(new ConfigLeaf(configEntry));
            }
        }
        return this.children;
    }

    @Override
    public String getNodeName() {
        return this.section.getName().toLowerCase(Locale.ROOT);
    }

    @Override
    public ITextComponent getName() {
        return IConfigNode.createLabel(this.section.getName());
    }

    @Override
    public ITextComponent getTooltip() {
        TextComponentString comp = new TextComponentString("");
        comp.func_150257_a(new TextComponentString(this.section.getName()).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        String[] array = this.section.getComment();
        if (array != null && array.length > 0) {
            int i = 0;
            while (i < array.length) {
                comp.func_150258_a("\n").func_150258_a(array[i++]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            }
        }
        return comp;
    }
}

