/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.gui.api.IConfigFolderNode;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.impl.minecraft.IGameRuleValue;
import carbonconfiglib.gui.impl.minecraft.MinecraftConfig;
import carbonconfiglib.gui.impl.minecraft.MinecraftLeaf;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import speiger.src.collections.objects.lists.ObjectArrayList;

public class MinecraftFolder
implements IConfigFolderNode {
    MinecraftConfig.Category cat;
    List<IGameRuleValue> values;
    List<IConfigNode> children;

    public MinecraftFolder(Map.Entry<MinecraftConfig.Category, List<IGameRuleValue>> entry) {
        this.cat = entry.getKey();
        this.values = entry.getValue();
    }

    @Override
    public List<IConfigNode> getChildren() {
        if (this.children == null) {
            this.children = new ObjectArrayList<IConfigNode>();
            for (IGameRuleValue value : this.values) {
                this.children.add(new MinecraftLeaf(value));
            }
        }
        return this.children;
    }

    @Override
    public String getNodeName() {
        return this.cat.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public ITextComponent getName() {
        return new TextComponentTranslation(this.cat.getDescriptionId(), new Object[0]);
    }
}

