/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.impl.minecraft.IGameRuleValue;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import speiger.src.collections.objects.utils.ObjectLists;

public class MinecraftValue
implements IValueNode {
    ObjectArrayList<String> previous = new ObjectArrayList();
    IGameRuleValue entry;
    String defaultValue;
    String current;

    public MinecraftValue(IGameRuleValue entry) {
        this.entry = entry;
        this.defaultValue = entry.getDefault();
        this.current = entry.get();
        this.previous.push((Object)this.current);
    }

    public void save() {
        this.entry.set(this.current);
    }

    @Override
    public boolean isDefault() {
        return Objects.equals(this.current, this.defaultValue);
    }

    @Override
    public boolean isChanged() {
        return !Objects.equals(this.previous.top(), this.current);
    }

    @Override
    public void setDefault() {
        this.current = this.defaultValue;
    }

    @Override
    public void setPrevious() {
        this.current = (String)this.previous.top();
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
    }

    @Override
    public void createTemp() {
        this.previous.push((Object)this.current);
    }

    @Override
    public void apply() {
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
    }

    @Override
    public String get() {
        return this.current;
    }

    @Override
    public void set(String value) {
        this.current = value;
    }

    @Override
    public ParseResult<Boolean> isValid(String value) {
        return this.entry.isValid(value);
    }

    @Override
    public IStructuredData.StructureType getNodeType() {
        return IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public boolean requiresReload() {
        return false;
    }

    @Override
    public ITextComponent getName() {
        return IConfigNode.createLabel(I18n.func_135052_a((String)this.entry.getDescriptionId(), (Object[])new Object[0]));
    }

    @Override
    public ITextComponent getTooltip() {
        String id = this.entry.getDescriptionId();
        TextComponentString result = new TextComponentString("");
        result.func_150257_a(new TextComponentTranslation(id, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        id = id + ".description";
        if (I18n.func_188566_a((String)id)) {
            result.func_150258_a("\n").func_150257_a(new TextComponentTranslation(id, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
        return result;
    }

    @Override
    public DataType getDataType() {
        return this.entry.getType();
    }

    @Override
    public boolean isForcingSuggestions() {
        return false;
    }

    @Override
    public List<ISuggestionProvider.Suggestion> getSuggestions() {
        return ObjectLists.empty();
    }
}

