/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ArrayElement;
import carbonconfiglib.gui.config.CompoundElement;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.config.SelectionElement;
import carbonconfiglib.gui.widgets.CarbonButton;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class CompoundScreen
extends ListScreen {
    GuiScreen prev;
    ICompoundNode compound;
    GuiButton applyValue;
    Runnable closeListener = null;

    public CompoundScreen(ICompoundNode node, GuiScreen prev, BackgroundTexture.BackgroundHolder customTexture) {
        super(node.getName(), customTexture);
        this.prev = prev;
        this.compound = node;
        this.compound.createTemp();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m;
        this.applyValue = this.addWidget(new CarbonButton(x - 82, y - 27, 80, 20, I18n.func_135052_a((String)"gui.carbonconfig.apply", (Object[])new Object[0]), this::apply));
        this.addWidget(new CarbonButton(x + 2, y - 27, 80, 20, I18n.func_135052_a((String)"gui.carbonconfig.back", (Object[])new Object[0]), this::goBack));
    }

    @Override
    protected int getScrollPadding() {
        return 184;
    }

    @Override
    protected int getListWidth() {
        return 360;
    }

    @Override
    protected boolean shouldHaveTooltips() {
        return true;
    }

    public void setAbortListener(Runnable run) {
        this.closeListener = run;
    }

    @Override
    public void tick() {
        super.tick();
        this.applyValue.field_146124_l = this.compound.isValid();
    }

    @Override
    public void onClose() {
        this.notifyClose();
        this.field_146297_k.func_147108_a(this.prev);
    }

    private void apply(GuiButton button) {
        this.compound.apply();
        this.field_146297_k.func_147108_a(this.prev);
    }

    private void notifyClose() {
        this.compound.setPrevious();
        if (this.closeListener == null) {
            return;
        }
        this.closeListener.run();
    }

    private void goBack(GuiButton button) {
        if (this.compound.isChanged()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((T, K) -> {
                if (T) {
                    this.notifyClose();
                }
                this.field_146297_k.func_147108_a((GuiScreen)(T ? this.prev : this));
            }, new TextComponentTranslation("gui.carbonconfig.warn.changed", new Object[0]).func_150254_d(), new TextComponentTranslation("gui.carbonconfig.warn.changed.desc", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d(), 0));
            return;
        }
        this.notifyClose();
        this.field_146297_k.func_147108_a(this.prev);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        List<? extends INode> values = this.compound.getValues();
        int m = values.size();
        block5: for (int i = 0; i < m; ++i) {
            INode node = values.get(i);
            switch (node.getNodeType()) {
                case COMPOUND: {
                    elements.accept(new CompoundElement(this.compound, node.asCompound()));
                    continue block5;
                }
                case LIST: {
                    elements.accept(new ArrayElement(this.compound, node.asArray()));
                    continue block5;
                }
                case SIMPLE: {
                    IValueNode value = node.asValue();
                    if (value.isForcingSuggestions()) {
                        elements.accept(new SelectionElement(this.compound, value));
                        continue block5;
                    }
                    ConfigElement element = value.getDataType().create(this.compound, value);
                    if (element == null) continue block5;
                    elements.accept(element);
                }
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String title = this.title.func_150254_d();
        this.field_146289_q.func_78276_b(title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(title) / 2, 8, -1);
    }
}

