/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.screen.ConfigScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.screen.IInteractable;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.WorldSummary;

public class SelectFileScreen
extends ListScreen {
    private static final ITextComponent TEXT = new TextComponentTranslation("gui.carbonconfig.select_world", new Object[0]);
    IModConfig config;
    GuiScreen parent;

    public SelectFileScreen(ITextComponent name, BackgroundTexture.BackgroundHolder customTexture, GuiScreen parent, IModConfig config) {
        super(name, customTexture);
        this.config = config;
        this.parent = parent;
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        for (IModConfig.IConfigTarget target : this.config.getPotentialFiles()) {
            if (Files.notExists(target.getConfigFile(), new LinkOption[0]) && !this.config.canCreateConfigs()) continue;
            elements.accept(new WorldElement(target, this.config, this.parent, this.title));
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m;
        this.addWidget(new CarbonButton(x - 80, y - 27, 160, 20, I18n.func_135052_a((String)"gui.carbonconfig.back", (Object[])new Object[0]), T -> this.onClose()));
    }

    @Override
    protected int getElementHeight() {
        return 28;
    }

    @Override
    public void onClose() {
        this.field_146297_k.func_147108_a(this.parent);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String text = TEXT.func_150254_d();
        this.field_146289_q.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, 8, -1);
    }

    @Override
    public void func_146281_b() {
        this.allEntries.forEach(this::cleanup);
        super.func_146281_b();
    }

    private void cleanup(Element element) {
        if (element instanceof WorldElement) {
            ((WorldElement)element).cleanup();
        }
    }

    private static class WorldElement
    extends Element {
        IModConfig config;
        IModConfig.IConfigTarget target;
        GuiScreen parent;
        CarbonButton button;
        ITextComponent title;
        ITextComponent path;
        DynamicTexture texture;
        ConfigScreen.Navigator nav;

        public WorldElement(IModConfig.IConfigTarget target, IModConfig config, GuiScreen parent, ITextComponent prevName) {
            super((ITextComponent)new TextComponentString(target.getName()));
            this.nav = new ConfigScreen.Navigator(prevName);
            this.nav.setScreenForLayer(parent);
            this.target = target;
            this.config = config;
            this.parent = parent;
        }

        @Override
        public void init() {
            this.button = new CarbonButton(0, 0, 62, 20, I18n.func_135052_a((String)"gui.carbonconfig.pick", (Object[])new Object[0]), this::onPick);
            if (this.target instanceof IModConfig.WorldConfigTarget) {
                IModConfig.WorldConfigTarget world = (IModConfig.WorldConfigTarget)this.target;
                WorldSummary sum = world.getSummary();
                this.loadIcon(Minecraft.func_71410_x().func_71359_d().func_186352_b(sum.func_75786_a(), "icon.png").toPath());
                this.title = new TextComponentString(sum.func_75788_b());
                this.path = new TextComponentString(sum.func_75786_a()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            } else {
                this.title = new TextComponentString(this.target.getName());
                Path folder = this.target.getFolder();
                int index = folder.getNameCount();
                this.path = new TextComponentString(folder.subpath(index - 3, index).toString()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            }
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.field_146128_h = left + width - 62;
            this.button.field_146129_i = top + 2;
            this.button.render(this.mc, mouseX, mouseY, partialTicks);
            GuiUtils.drawScrollingString(this.font, this.title.func_150254_d(), left + 5, top + 2, 150.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            GuiUtils.drawScrollingString(this.font, this.path.func_150254_d(), left + 5, top + 12, 150.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            if (this.texture != null) {
                GlStateManager.func_179144_i((int)this.texture.func_110552_b());
                GuiUtils.drawTextureRegion(left - 24, top, 0.0f, 0.0f, 24.0f, 24.0f, 64.0f, 64.0f, 64.0f, 64.0f);
            }
        }

        private void loadIcon(Path iconFile) {
            try (InputStream stream = Files.newInputStream(iconFile, new OpenOption[0]);){
                BufferedImage image = ImageIO.read(stream);
                if (image == null || image.getWidth() != 64 || image.getHeight() != 64) {
                    return;
                }
                this.texture = new DynamicTexture(image);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public List<? extends IInteractable> children() {
            return ObjectLists.singleton((Object)this.button);
        }

        private void onPick(GuiButton button) {
            Path file = this.target.getConfigFile();
            if (Files.notExists(file, new LinkOption[0]) && !this.config.createConfig(file)) {
                return;
            }
            IModConfig config = this.config.loadFromFile(file);
            if (config == null) {
                this.mc.func_147108_a(this.parent);
                return;
            }
            this.mc.func_147108_a((GuiScreen)new ConfigScreen(this.nav.add(this.path.func_150259_f().func_150255_a(new Style().func_150238_a(TextFormatting.WHITE))), config, this.parent, this.owner.getCustomTexture()));
        }

        private void cleanup() {
            if (this.texture == null) {
                return;
            }
            this.texture.func_147631_c();
            this.texture = null;
        }
    }
}

