/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.widgets;

import carbonconfiglib.gui.api.ISuggestionRenderer;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SuggestionRenderers {
    private static final Gui GUI = new Gui();

    public static class ColorEntry
    implements ISuggestionRenderer {
        @Override
        public ITextComponent renderSuggestion(String value, int x, int y) {
            try {
                Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 18), (int)(y + 19), (int)-6250336);
                Gui.func_73734_a((int)(x + 2), (int)(y + 2), (int)(x + 17), (int)(y + 18), (int)(Long.decode(value).intValue() | 0xFF000000));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static class PotionEntry
    implements ISuggestionRenderer {
        @Override
        public ITextComponent renderSuggestion(String value, int x, int y) {
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(value));
            if (potion == null) {
                return null;
            }
            ItemStack item = new ItemStack((Item)Items.field_151068_bn);
            PotionUtils.func_185184_a((ItemStack)item, (Collection)ObjectLists.singleton((Object)new PotionEffect(potion)));
            NBTTagCompound nbt = item.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                item.func_77982_d(nbt);
            }
            nbt.func_74768_a("CustomPotionColor", potion.func_76401_j());
            Minecraft.func_71410_x().func_175599_af().func_180450_b(item, x, y);
            return new TextComponentString(potion.func_76393_a()).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)).func_150258_a("\n").func_150257_a(new TextComponentString(value).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
    }

    public static class EnchantmentEntry
    implements ISuggestionRenderer {
        @Override
        public ITextComponent renderSuggestion(String value, int x, int y) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(value));
            if (ench == null) {
                return null;
            }
            Minecraft.func_71410_x().func_175599_af().func_180450_b(ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(ench, ench.func_77319_d())), x, y);
            return new TextComponentString(ench.func_77316_c(ench.func_77319_d())).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)).func_150258_a("\n").func_150257_a(new TextComponentString(value).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
    }

    public static class FluidEntry
    implements ISuggestionRenderer {
        @Override
        public ITextComponent renderSuggestion(String value, int x, int y) {
            Fluid fluid = FluidRegistry.getFluid((String)value);
            if (fluid == null) {
                return null;
            }
            TextureAtlasSprite sprite = this.getSprite(fluid);
            if (sprite == null) {
                return null;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            int color = fluid.getColor();
            GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            GUI.func_175175_a(0, 0, sprite, 18, 18);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return new TextComponentString(fluid.getLocalizedName(new FluidStack(fluid, 1))).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)).func_150258_a("\n").func_150257_a(new TextComponentString(value).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }

        private TextureAtlasSprite getSprite(Fluid fluid) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
        }
    }

    public static class ItemEntry
    implements ISuggestionRenderer {
        @Override
        public ITextComponent renderSuggestion(String value, int x, int y) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(value));
            if (item == Items.field_190931_a || item == null) {
                return null;
            }
            ItemStack itemStack = new ItemStack(item);
            Minecraft.func_71410_x().func_175599_af().func_180450_b(itemStack, x, y);
            return new TextComponentString(itemStack.func_82833_r()).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)).func_150258_a("\n").func_150257_a(new TextComponentString(value).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
    }
}

