/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import carbonconfiglib.utils.MultilinePolicy;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ConfigRequestPacket
implements ICarbonPacket {
    UUID id;
    String identifier;

    public ConfigRequestPacket() {
    }

    public ConfigRequestPacket(UUID id, String identifier) {
        this.id = id;
        this.identifier = identifier;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179252_a(this.id);
        buffer.func_180714_a(this.identifier);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.id = buffer.func_179253_g();
        this.identifier = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void process(EntityPlayer player) {
        if (!this.canIgnorePermissionCheck() && !this.hasPermissions(player, 4)) {
            return;
        }
        ConfigHandler handler = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_180714_a(handler.getConfig().serialize(MultilinePolicy.DISABLED));
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.id, data), player);
    }

    private boolean hasPermissions(EntityPlayer player, int value) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server.func_184103_al().func_152603_m().func_187452_a(player.func_146103_bH()) >= value;
    }

    private boolean canIgnorePermissionCheck() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return !server.func_71262_S() && server instanceof IntegratedServer && ((IntegratedServer)server).func_71344_c();
    }
}

