/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.utils.structure;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.ParsedCollections;
import carbonconfiglib.utils.structure.IStructuredData;
import carbonconfiglib.utils.structure.StructureList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.lists.ObjectList;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectLinkedOpenHashMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;
import speiger.src.collections.objects.utils.ObjectLists;

public class StructureCompound {

    static class CompoundEntry<T>
    implements IWritableCompoundEntry {
        ObjectList<ISuggestionProvider> providers = new ObjectArrayList<ISuggestionProvider>();
        final Function<String, ParseResult<T>> parse;
        final Function<T, String> serialize;
        final IStructuredData type;
        final String name;
        String[] comments;
        boolean forcedSuggestions;

        public CompoundEntry(String name, IStructuredData type, Function<String, ParseResult<T>> parse, Function<T, String> serialize) {
            this.name = name;
            this.type = type;
            this.parse = parse;
            this.serialize = serialize;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IStructuredData getType() {
            return this.type;
        }

        @Override
        public boolean isForced() {
            return this.forcedSuggestions;
        }

        @Override
        public String[] getComment() {
            return this.comments;
        }

        @Override
        public ObjectList<ISuggestionProvider> getSuggestions() {
            return this.providers.unmodifiable();
        }

        @Override
        public void parse(Map<String, String> data, ParsedCollections.ParsedMap output) {
            output.put(this.name, this.parse.apply(data.getOrDefault(this.name, "")));
        }

        @Override
        public void serialize(ParsedCollections.ParsedMap input, Map<String, String> output, boolean allowMultiline, int indent) {
            output.put(this.name, this.serialize.apply(input.getUnsafe(this.name)));
        }

        @Override
        public void setForced(boolean value) {
            this.forcedSuggestions = value;
        }

        @Override
        public void addSuggestions(ISuggestionProvider ... providers) {
            this.providers.addAll((ISuggestionProvider[])providers);
        }

        @Override
        public void setComments(String ... comments) {
            this.comments = comments;
        }

        private static CompoundEntry<?> create(String name, IStructuredData.EntryDataType type) {
            switch (type) {
                case BOOLEAN: {
                    return new CompoundEntry<Boolean>(name, type.toSimpleType(), Helpers::parseBoolean, String::valueOf);
                }
                case INTEGER: {
                    return new CompoundEntry<Integer>(name, type.toSimpleType(), Helpers::parseInt, String::valueOf);
                }
                case DOUBLE: {
                    return new CompoundEntry<Double>(name, type.toSimpleType(), Helpers::parseDouble, String::valueOf);
                }
                case STRING: {
                    return new CompoundEntry(name, type.toSimpleType(), Helpers::parseString, Function.identity());
                }
            }
            throw new IllegalStateException("Unsupported Type");
        }
    }

    static class WrappedCompoundEntry<T>
    implements IWritableCompoundEntry {
        String name;
        String[] comments;
        CompoundData data;
        Function<ParsedCollections.ParsedMap, ParseResult<T>> parse;
        Function<T, ParsedCollections.ParsedMap> serialize;

        public WrappedCompoundEntry(String name, CompoundData data, Function<ParsedCollections.ParsedMap, ParseResult<T>> parse, Function<T, ParsedCollections.ParsedMap> serialize) {
            this.name = name;
            this.data = data;
            this.parse = parse;
            this.serialize = serialize;
        }

        @Override
        public IStructuredData getType() {
            return this.data;
        }

        @Override
        public boolean isForced() {
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getComment() {
            return this.comments;
        }

        @Override
        public void parse(Map<String, String> input, ParsedCollections.ParsedMap output) {
            output.put(this.name, this.parse.apply(this.data.parse(input.getOrDefault(this.name, ""))));
        }

        @Override
        public void serialize(ParsedCollections.ParsedMap input, Map<String, String> output, boolean allowMultiline, int indent) {
            output.put(this.name, this.data.serialize(this.serialize.apply(input.getUnsafe(this.name)), allowMultiline, indent));
        }

        @Override
        public ObjectList<ISuggestionProvider> getSuggestions() {
            return ObjectLists.empty();
        }

        @Override
        public void setForced(boolean value) {
            throw new UnsupportedOperationException("Not supported for nested wrappers");
        }

        @Override
        public void addSuggestions(ISuggestionProvider ... providers) {
            throw new UnsupportedOperationException("Not supported for nested wrappers");
        }

        @Override
        public void setComments(String ... comments) {
            this.comments = comments;
        }
    }

    static class WrappedListEntry
    implements IWritableCompoundEntry {
        String name;
        String[] comments;
        StructureList.ListData data;

        public WrappedListEntry(String name, StructureList.ListData data) {
            this.name = name;
            this.data = data;
        }

        @Override
        public IStructuredData getType() {
            return this.data;
        }

        @Override
        public boolean isForced() {
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getComment() {
            return this.comments;
        }

        @Override
        public void parse(Map<String, String> input, ParsedCollections.ParsedMap output) {
            output.put(this.name, ParsedCollections.ParsedList.unwrap(this.data.parse(input.getOrDefault(this.name, ""))));
        }

        @Override
        public void serialize(ParsedCollections.ParsedMap input, Map<String, String> output, boolean allowMultiline, int indent) {
            output.put(this.name, this.data.serialize(input.get(this.name, ParsedCollections.ParsedList.class), allowMultiline, indent));
        }

        @Override
        public ObjectList<ISuggestionProvider> getSuggestions() {
            return ObjectLists.empty();
        }

        @Override
        public void setForced(boolean value) {
            throw new UnsupportedOperationException("Not supported for nested wrappers");
        }

        @Override
        public void addSuggestions(ISuggestionProvider ... providers) {
            throw new UnsupportedOperationException("Not supported for nested wrappers");
        }

        @Override
        public void setComments(String ... comments) {
            this.comments = comments;
        }
    }

    static interface IWritableCompoundEntry
    extends ICompoundEntry {
        public void setForced(boolean var1);

        public void addSuggestions(ISuggestionProvider ... var1);

        public void setComments(String ... var1);
    }

    public static interface ICompoundEntry {
        public IStructuredData getType();

        public boolean isForced();

        public String[] getComment();

        public String getName();

        public void parse(Map<String, String> var1, ParsedCollections.ParsedMap var2);

        public void serialize(ParsedCollections.ParsedMap var1, Map<String, String> var2, boolean var3, int var4);

        public ObjectList<ISuggestionProvider> getSuggestions();
    }

    public static class CompoundBuilder {
        CompoundData result = new CompoundData();
        IWritableCompoundEntry current;

        public CompoundBuilder simple(String name, IStructuredData.EntryDataType type) {
            if (type == IStructuredData.EntryDataType.ENUM) {
                throw new IllegalStateException("Use enums instead");
            }
            if (type == IStructuredData.EntryDataType.CUSTOM) {
                throw new IllegalStateException("Use variants instead");
            }
            return this.start(CompoundEntry.create(name, type));
        }

        public <T extends Enum<T>> CompoundBuilder enums(String name, Class<T> clz) {
            this.start(new CompoundEntry<Enum>(name, IStructuredData.EntryDataType.ENUM.toSimpleType(), E -> Helpers.parseEnum(clz, E), Enum::name));
            this.addSuggestions(ISuggestionProvider.enums(clz));
            return this;
        }

        public <T> CompoundBuilder variants(String name, IStructuredData.EntryDataType displayType, Class<T> type, Function<String, ParseResult<T>> parse, Function<T, String> serialize) {
            return this.start(new CompoundEntry<T>(name, IStructuredData.SimpleData.variant(displayType, type), parse, serialize));
        }

        public CompoundBuilder list(String name, StructureList.ListData entry) {
            return this.start(new WrappedListEntry(name, entry));
        }

        public <T> CompoundBuilder object(String name, CompoundData data, Function<ParsedCollections.ParsedMap, ParseResult<T>> parse, Function<T, ParsedCollections.ParsedMap> serialize) {
            return this.start(new WrappedCompoundEntry<T>(name, data, parse, serialize));
        }

        public CompoundBuilder addSuggestions(ISuggestionProvider ... providers) {
            Objects.requireNonNull(this.current, "No Entry to configure").addSuggestions(providers);
            return this;
        }

        public CompoundBuilder setComments(String ... comments) {
            Objects.requireNonNull(this.current, "No Entry to configure").setComments(comments);
            return this;
        }

        public CompoundBuilder forceSuggestions(boolean value) {
            Objects.requireNonNull(this.current, "No Entry to configure").setForced(value);
            return this;
        }

        private CompoundBuilder start(IWritableCompoundEntry entry) {
            if (this.current != null) {
                throw new IllegalStateException("Can't start another entry without finishing the previous one");
            }
            this.current = entry;
            return this;
        }

        public CompoundBuilder setNewLined(boolean value) {
            this.result.isNewLined = value;
            return this;
        }

        public CompoundBuilder finish() {
            Objects.requireNonNull(this.current, "Can't finish a non existend entry");
            this.result.entries.put(this.current.getName(), this.current);
            this.current = null;
            return this;
        }

        public CompoundData build() {
            if (this.current != null) {
                throw new IllegalStateException("Can't build a ComponentStructure when a element is still being built");
            }
            CompoundData out = this.result;
            this.result = null;
            return out;
        }
    }

    public static class CompoundData
    implements IStructuredData {
        Map<String, ICompoundEntry> entries = new Object2ObjectLinkedOpenHashMap<String, ICompoundEntry>();
        boolean isNewLined = true;

        @Override
        public IStructuredData.StructureType getDataType() {
            return IStructuredData.StructureType.COMPOUND;
        }

        @Override
        public CompoundData asCompound() {
            return this;
        }

        public boolean isNewLined() {
            return this.isNewLined;
        }

        @Override
        public String generateDefaultValue(Function<IStructuredData.SimpleData, String> defaultFactory) {
            Object2ObjectLinkedOpenHashMap<String, String> result = Object2ObjectMap.builder().linkedMap();
            for (Map.Entry<String, ICompoundEntry> entry : this.entries.entrySet()) {
                result.put(entry.getKey(), entry.getValue().getType().generateDefaultValue(defaultFactory));
            }
            return Helpers.mergeCompound(result, false, 0);
        }

        public List<String> getKeys() {
            return new ObjectArrayList<String>((Collection<String>)this.entries.keySet());
        }

        public ParsedCollections.ParsedMap parse(String input) {
            return this.parseMap(Helpers.splitArguments(Helpers.splitCompound(input.trim()), this.getKeys(), false));
        }

        public String serialize(ParsedCollections.ParsedMap map, boolean allowMultiline) {
            return this.serialize(map, allowMultiline, 0);
        }

        public String serialize(ParsedCollections.ParsedMap map, boolean allowMultiline, int indent) {
            return Helpers.mergeCompound(this.serializeMap(map, allowMultiline, indent), this.isNewLined && allowMultiline, indent);
        }

        public ParsedCollections.ParsedMap parseMap(Map<String, String> info) {
            ParsedCollections.ParsedMap output = new ParsedCollections.ParsedMap();
            for (ICompoundEntry entry : this.entries.values()) {
                entry.parse(info, output);
            }
            return output;
        }

        public Map<String, String> serializeMap(ParsedCollections.ParsedMap map, boolean allowMultine, int indent) {
            Object2ObjectLinkedOpenHashMap<String, String> parsed = Object2ObjectMap.builder().linkedMap();
            for (ICompoundEntry entry : this.entries.values()) {
                entry.serialize(map, parsed, allowMultine, indent + 1);
            }
            return parsed;
        }

        public Map<String, IStructuredData> getFormat() {
            Object2ObjectLinkedOpenHashMap<String, IStructuredData> data = new Object2ObjectLinkedOpenHashMap<String, IStructuredData>();
            this.entries.forEach((K, V) -> data.put(K, V.getType()));
            return data;
        }

        public boolean isForcedSuggestion(String name) {
            ICompoundEntry entry = this.entries.get(name);
            return entry != null && entry.isForced();
        }

        public String[] getComments(String name) {
            ICompoundEntry entry = this.entries.get(name);
            return entry == null ? null : entry.getComment();
        }

        public List<ISuggestionProvider.Suggestion> getSuggestions(String name, BiPredicate<String, String> filter) {
            ICompoundEntry entry = this.entries.get(name);
            if (entry == null) {
                return ObjectLists.empty();
            }
            ObjectList<ISuggestionProvider> providers = entry.getSuggestions();
            ObjectArrayList<ISuggestionProvider.Suggestion> output = new ObjectArrayList<ISuggestionProvider.Suggestion>();
            for (ISuggestionProvider provider : providers) {
                provider.provideSuggestions(output::add, T -> filter.test(name, T.getValue()));
            }
            return output;
        }

        @Override
        public void appendFormat(StringBuilder builder, boolean start) {
            if (!start) {
                builder.append("Compound[");
            }
            for (ICompoundEntry entry : this.entries.values()) {
                builder.append(entry.getName()).append(": (");
                entry.getType().appendFormat(builder, false);
                builder.append("); ");
            }
            if (builder.charAt(builder.length() - 1) == ' ') {
                builder.deleteCharAt(builder.length() - 1);
            }
            if (!start) {
                builder.append("]");
            }
        }
    }
}

