/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.collections;

import java.util.Objects;
import java.util.function.Consumer;
import speiger.src.collections.chars.collections.CharCollection;
import speiger.src.collections.chars.collections.CharIterator;
import speiger.src.collections.chars.collections.CharSplititerator;
import speiger.src.collections.chars.functions.CharComparator;
import speiger.src.collections.chars.functions.CharConsumer;
import speiger.src.collections.chars.functions.function.CharCharUnaryOperator;
import speiger.src.collections.chars.functions.function.CharFunction;
import speiger.src.collections.chars.functions.function.CharPredicate;
import speiger.src.collections.chars.utils.CharArrays;
import speiger.src.collections.chars.utils.CharIterables;
import speiger.src.collections.chars.utils.CharIterators;
import speiger.src.collections.chars.utils.CharSplititerators;
import speiger.src.collections.ints.functions.consumer.IntCharConsumer;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.functions.consumer.ObjectCharConsumer;
import speiger.src.collections.utils.ISizeProvider;

public interface CharIterable
extends Iterable<Character> {
    public CharIterator iterator();

    default public void forEach(CharConsumer action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(action);
    }

    @Override
    @Deprecated
    default public void forEach(Consumer<? super Character> action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(action);
    }

    default public void forEachIndexed(IntCharConsumer action) {
        Objects.requireNonNull(action);
        int index = 0;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            action.accept(index++, iter.nextChar());
        }
    }

    default public <E> void forEach(E input, ObjectCharConsumer<E> action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(input, action);
    }

    default public CharSplititerator spliterator() {
        return CharSplititerators.createUnknownSplititerator(this.iterator(), 0);
    }

    default public <E> ObjectIterable<E> map(CharFunction<E> mapper) {
        return CharIterables.map(this, mapper);
    }

    default public <E, V extends Iterable<E>> ObjectIterable<E> flatMap(CharFunction<V> mapper) {
        return CharIterables.flatMap(this, mapper);
    }

    default public <E> ObjectIterable<E> arrayflatMap(CharFunction<E[]> mapper) {
        return CharIterables.arrayFlatMap(this, mapper);
    }

    default public CharIterable filter(CharPredicate filter) {
        return CharIterables.filter(this, filter);
    }

    default public CharIterable distinct() {
        return CharIterables.distinct(this);
    }

    default public CharIterable repeat(int repeats) {
        return CharIterables.repeat(this, repeats);
    }

    default public CharIterable limit(long limit) {
        return CharIterables.limit(this, limit);
    }

    default public CharIterable sorted(CharComparator sorter) {
        return CharIterables.sorted(this, sorter);
    }

    default public CharIterable peek(CharConsumer action) {
        return CharIterables.peek(this, action);
    }

    default public <E extends CharCollection> E pour(E collection) {
        CharIterators.pour(this.iterator(), collection);
        return collection;
    }

    default public char[] toCharArray() {
        int size;
        ISizeProvider prov = ISizeProvider.of(this);
        if (prov != null && (size = prov.size()) >= 0) {
            char[] array = new char[size];
            CharIterators.unwrap(array, this.iterator());
            return array;
        }
        return CharArrays.pour(this.iterator());
    }

    default public boolean matchesAny(CharPredicate filter) {
        Objects.requireNonNull(filter);
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.nextChar())) continue;
            return true;
        }
        return false;
    }

    default public boolean matchesNone(CharPredicate filter) {
        Objects.requireNonNull(filter);
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.nextChar())) continue;
            return false;
        }
        return true;
    }

    default public boolean matchesAll(CharPredicate filter) {
        Objects.requireNonNull(filter);
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (filter.test(iter.nextChar())) continue;
            return false;
        }
        return true;
    }

    default public char findFirst(CharPredicate filter) {
        Objects.requireNonNull(filter);
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            char entry = iter.nextChar();
            if (!filter.test(entry)) continue;
            return entry;
        }
        return '\u0000';
    }

    default public char reduce(char identity, CharCharUnaryOperator operator) {
        Objects.requireNonNull(operator);
        char state = identity;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            state = operator.applyAsChar(state, iter.nextChar());
        }
        return state;
    }

    default public char reduce(CharCharUnaryOperator operator) {
        Objects.requireNonNull(operator);
        char state = '\u0000';
        boolean empty = true;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (empty) {
                empty = false;
                state = iter.nextChar();
                continue;
            }
            state = operator.applyAsChar(state, iter.nextChar());
        }
        return state;
    }

    default public int count(CharPredicate filter) {
        Objects.requireNonNull(filter);
        int result = 0;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.nextChar())) continue;
            ++result;
        }
        return result;
    }
}

