/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.maps.interfaces;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import speiger.src.collections.chars.functions.consumer.CharObjectConsumer;
import speiger.src.collections.chars.functions.function.CharFunction;
import speiger.src.collections.chars.functions.function.CharObjectUnaryOperator;
import speiger.src.collections.chars.maps.impl.hash.Char2ObjectOpenHashMap;
import speiger.src.collections.chars.sets.CharSet;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.sets.ObjectSet;

public interface Char2ObjectMap<V>
extends Map<Character, V>,
CharFunction<V> {
    public static MapBuilder builder() {
        return MapBuilder.INSTANCE;
    }

    public V getDefaultReturnValue();

    public Char2ObjectMap<V> setDefaultReturnValue(V var1);

    public Char2ObjectMap<V> copy();

    @Override
    public V put(char var1, V var2);

    default public V put(Entry<V> entry) {
        return this.put(entry.getCharKey(), (V)entry.getValue());
    }

    default public V put(Map.Entry<Character, V> entry) {
        return this.put(entry.getKey(), entry.getValue());
    }

    default public void putAll(char[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalStateException("Array sizes do not match");
        }
        this.putAll(keys, values, 0, keys.length);
    }

    public void putAll(char[] var1, V[] var2, int var3, int var4);

    default public void putAll(Character[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalStateException("Array sizes do not match");
        }
        this.putAll(keys, values, 0, keys.length);
    }

    public void putAll(Character[] var1, V[] var2, int var3, int var4);

    @Override
    public V putIfAbsent(char var1, V var2);

    public void putAllIfAbsent(Char2ObjectMap<V> var1);

    public void putAll(Char2ObjectMap<V> var1);

    public boolean containsKey(char var1);

    @Override
    default public boolean containsKey(Object key) {
        return key instanceof Character && this.containsKey(((Character)key).charValue());
    }

    public V remove(char var1);

    @Override
    default public V remove(Object key) {
        return key instanceof Character ? this.remove(((Character)key).charValue()) : this.getDefaultReturnValue();
    }

    public boolean remove(char var1, V var2);

    @Override
    default public boolean remove(Object key, Object value) {
        return key instanceof Character && this.remove(((Character)key).charValue(), value);
    }

    public V removeOrDefault(char var1, V var2);

    @Override
    public boolean replace(char var1, V var2, V var3);

    @Override
    public V replace(char var1, V var2);

    public void replaceObjects(Char2ObjectMap<V> var1);

    public void replaceObjects(CharObjectUnaryOperator<V> var1);

    public V compute(char var1, CharObjectUnaryOperator<V> var2);

    public V computeIfAbsent(char var1, CharFunction<V> var2);

    public V supplyIfAbsent(char var1, ObjectSupplier<V> var2);

    public V computeIfPresent(char var1, CharObjectUnaryOperator<V> var2);

    public V merge(char var1, V var2, ObjectObjectUnaryOperator<V, V> var3);

    public void mergeAll(Char2ObjectMap<V> var1, ObjectObjectUnaryOperator<V, V> var2);

    @Override
    @Deprecated
    default public boolean replace(Character key, V oldValue, V newValue) {
        return this.replace(key.charValue(), oldValue, newValue);
    }

    @Override
    @Deprecated
    default public V replace(Character key, V value) {
        return this.replace(key.charValue(), value);
    }

    @Override
    default public V apply(char key) {
        return this.get(key);
    }

    public V get(char var1);

    public V getOrDefault(char var1, V var2);

    @Override
    @Deprecated
    default public V get(Object key) {
        return key instanceof Character ? this.get(((Character)key).charValue()) : this.getDefaultReturnValue();
    }

    @Override
    @Deprecated
    default public V getOrDefault(Object key, V defaultValue) {
        V value = key instanceof Character ? this.get(((Character)key).charValue()) : this.getDefaultReturnValue();
        return !Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key) ? value : defaultValue;
    }

    @Override
    @Deprecated
    default public void replaceAll(BiFunction<? super Character, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        this.replaceObjects(mappingFunction instanceof CharObjectUnaryOperator ? (CharObjectUnaryOperator<Object>)mappingFunction : (K, V) -> mappingFunction.apply(Character.valueOf(K), (Object)V));
    }

    @Override
    @Deprecated
    default public V compute(Character key, BiFunction<? super Character, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return (V)this.compute(key.charValue(), mappingFunction instanceof CharObjectUnaryOperator ? (CharObjectUnaryOperator<Object>)mappingFunction : (K, V) -> mappingFunction.apply(Character.valueOf(K), (Object)V));
    }

    @Override
    @Deprecated
    default public V computeIfAbsent(Character key, Function<? super Character, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return (V)this.computeIfAbsent(key.charValue(), mappingFunction instanceof CharFunction ? (CharFunction<Object>)((Object)mappingFunction) : K -> mappingFunction.apply(Character.valueOf(K)));
    }

    @Override
    @Deprecated
    default public V computeIfPresent(Character key, BiFunction<? super Character, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return (V)this.computeIfPresent(key.charValue(), mappingFunction instanceof CharObjectUnaryOperator ? (CharObjectUnaryOperator<Object>)mappingFunction : (K, V) -> mappingFunction.apply(Character.valueOf(K), (Object)V));
    }

    @Override
    @Deprecated
    default public V merge(Character key, V value, BiFunction<? super V, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Objects.requireNonNull(value);
        return this.merge(key.charValue(), value, mappingFunction instanceof ObjectObjectUnaryOperator ? (ObjectObjectUnaryOperator)mappingFunction : (K, V) -> mappingFunction.apply((Object)K, (Object)V));
    }

    public void forEach(CharObjectConsumer<V> var1);

    @Override
    @Deprecated
    default public void forEach(BiConsumer<? super Character, ? super V> action) {
        Objects.requireNonNull(action);
        this.forEach(action instanceof CharObjectConsumer ? (CharObjectConsumer<Object>)action : (K, V) -> action.accept(Character.valueOf(K), (Object)V));
    }

    public CharSet keySet();

    @Override
    public ObjectCollection<V> values();

    @Override
    @Deprecated
    public ObjectSet<Map.Entry<Character, V>> entrySet();

    public ObjectSet<Entry<V>> char2ObjectEntrySet();

    @Override
    @Deprecated
    default public V put(Character key, V value) {
        return this.put(key.charValue(), value);
    }

    @Override
    @Deprecated
    default public V putIfAbsent(Character key, V value) {
        return this.put(key.charValue(), value);
    }

    public static class BuilderCache<V> {
        char[] keys;
        V[] values;
        int size;

        public BuilderCache() {
            this(16);
        }

        public BuilderCache(int initialSize) {
            if (initialSize < 0) {
                throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
            }
            this.keys = new char[initialSize];
            this.values = new Object[initialSize];
        }

        private void ensureSize(int newSize) {
            if (this.keys.length >= newSize) {
                return;
            }
            newSize = (int)Math.max(Math.min((long)this.keys.length + (long)(this.keys.length >> 1), 0x7FFFFFF7L), (long)newSize);
            this.keys = Arrays.copyOf(this.keys, newSize);
            this.values = Arrays.copyOf(this.values, newSize);
        }

        public BuilderCache<V> put(char key, V value) {
            this.ensureSize(this.size + 1);
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
            return this;
        }

        public BuilderCache<V> put(Character key, V value) {
            return this.put(key.charValue(), value);
        }

        public BuilderCache<V> put(Entry<V> entry) {
            return this.put(entry.getCharKey(), (V)entry.getValue());
        }

        public BuilderCache<V> putAll(Char2ObjectMap<V> map) {
            return this.putAll(map.char2ObjectEntrySet());
        }

        public BuilderCache<V> putAll(Map<? extends Character, ? extends V> map) {
            for (Map.Entry<Character, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public BuilderCache<V> putAll(ObjectIterable<Entry<V>> c) {
            if (c instanceof Collection) {
                this.ensureSize(this.size + ((Collection)((Object)c)).size());
            }
            for (Entry entry : c) {
                this.put(entry);
            }
            return this;
        }

        private <E extends Char2ObjectMap<V>> E putElements(E e) {
            e.putAll(this.keys, this.values, 0, this.size);
            return e;
        }

        public Char2ObjectOpenHashMap<V> map() {
            return this.putElements(new Char2ObjectOpenHashMap(this.size));
        }
    }

    public static final class MapBuilder {
        static final MapBuilder INSTANCE = new MapBuilder();

        public <V> BuilderCache<V> start() {
            return new BuilderCache();
        }

        public <V> BuilderCache<V> start(int size) {
            return new BuilderCache(size);
        }

        public <V> BuilderCache<V> put(char key, V value) {
            return new BuilderCache<V>().put(key, value);
        }

        public <V> BuilderCache<V> put(Character key, V value) {
            return new BuilderCache<V>().put(key, value);
        }

        public <V> Char2ObjectOpenHashMap<V> map() {
            return new Char2ObjectOpenHashMap();
        }

        public <V> Char2ObjectOpenHashMap<V> map(int size) {
            return new Char2ObjectOpenHashMap(size);
        }

        public <V> Char2ObjectOpenHashMap<V> map(char[] keys, V[] values) {
            return new Char2ObjectOpenHashMap<V>(keys, values);
        }

        public <V> Char2ObjectOpenHashMap<V> map(Character[] keys, V[] values) {
            return new Char2ObjectOpenHashMap<V>(keys, values);
        }

        public <V> Char2ObjectOpenHashMap<V> map(Char2ObjectMap<V> map) {
            return new Char2ObjectOpenHashMap<V>(map);
        }

        public <V> Char2ObjectOpenHashMap<V> map(Map<? extends Character, ? extends V> map) {
            return new Char2ObjectOpenHashMap<V>(map);
        }
    }

    public static interface Entry<V>
    extends Map.Entry<Character, V> {
        public char getCharKey();

        @Override
        default public Character getKey() {
            return Character.valueOf(this.getCharKey());
        }
    }

    public static interface FastEntrySet<V>
    extends ObjectSet<Entry<V>> {
        public ObjectIterator<Entry<V>> fastIterator();

        default public void fastForEach(Consumer<? super Entry<V>> action) {
            this.forEach(action);
        }
    }
}

