/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.utils;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.RecursiveAction;
import speiger.src.collections.chars.collections.CharIterator;
import speiger.src.collections.chars.functions.CharComparator;
import speiger.src.collections.chars.utils.CharCollections;
import speiger.src.collections.chars.utils.CharIterators;
import speiger.src.collections.utils.SanityChecks;

public class CharArrays {
    public static final int BASE_THRESHOLD = 16;
    public static final int PARALLEL_THRESHOLD = 8192;
    public static final char[] EMPTY_ARRAY = new char[0];

    public static Character[] wrap(char[] a) {
        return CharArrays.wrap(a, 0, a.length);
    }

    public static Character[] wrap(char[] a, int length) {
        return CharArrays.wrap(a, 0, length);
    }

    public static Character[] wrap(char[] a, int offset, int length) {
        SanityChecks.checkArrayCapacity(a.length, offset, length);
        Character[] result = new Character[length];
        for (int i = offset; i < length; ++i) {
            result[i] = Character.valueOf(a[i]);
        }
        return result;
    }

    public static char[] unwrap(Character[] a) {
        return CharArrays.unwrap(a, 0, a.length);
    }

    public static char[] unwrap(Character[] a, int length) {
        return CharArrays.unwrap(a, 0, length);
    }

    public static char[] unwrap(Character[] a, int offset, int length) {
        SanityChecks.checkArrayCapacity(a.length, offset, length);
        char[] result = new char[length];
        for (int i = offset; i < length; ++i) {
            result[i] = a[i].charValue();
        }
        return result;
    }

    public static char[] pour(CharIterator iter) {
        return CharArrays.pour(iter, Integer.MAX_VALUE);
    }

    public static char[] pour(CharIterator iter, int max) {
        CharCollections.CollectionWrapper list = CharCollections.wrapper();
        CharIterators.pour(iter, list, max);
        return list.toCharArray(new char[list.size()]);
    }

    public static int shiftDown(char[] data, int size, int index, CharComparator comp) {
        int half = size >>> 1;
        char value = data[index];
        if (comp != null) {
            while (index < half) {
                int child = (index << 1) + 1;
                char childValue = data[child];
                int right = child + 1;
                if (right < size && comp.compare(data[right], childValue) < 0) {
                    child = right;
                    childValue = data[child];
                }
                if (comp.compare(value, childValue) > 0) {
                    data[index] = childValue;
                    index = child;
                    continue;
                }
                break;
            }
        } else {
            while (index < half) {
                int child = (index << 1) + 1;
                char childValue = data[child];
                int right = child + 1;
                if (right < size && Character.compare(data[right], childValue) < 0) {
                    child = right;
                    childValue = data[child];
                }
                if (Character.compare(value, childValue) > 0) {
                    data[index] = childValue;
                    index = child;
                    continue;
                }
                break;
            }
        }
        data[index] = value;
        return index;
    }

    public static int shiftUp(char[] data, int index, CharComparator comp) {
        char value = data[index];
        if (comp != null) {
            int parent;
            char parentValue;
            while (index > 0 && comp.compare(value, parentValue = data[parent = index - 1 >>> 1]) < 0) {
                data[index] = parentValue;
                index = parent;
            }
        } else {
            int parent;
            char parentValue;
            while (index > 0 && Character.compare(value, parentValue = data[parent = index - 1 >>> 1]) < 0) {
                data[index] = parentValue;
                index = parent;
            }
        }
        data[index] = value;
        return index;
    }

    public static char[] heapify(char[] data, int size, CharComparator comp) {
        int i = (size >>> 1) - 1;
        while (i >= 0) {
            CharArrays.shiftDown(data, size, i--, comp);
        }
        return data;
    }

    public static char[] shuffle(char[] array) {
        return CharArrays.shuffle(array, SanityChecks.getRandom());
    }

    public static char[] shuffle(char[] array, int length) {
        return CharArrays.shuffle(array, 0, length, SanityChecks.getRandom());
    }

    public static char[] shuffle(char[] array, int offset, int length) {
        return CharArrays.shuffle(array, offset, length, SanityChecks.getRandom());
    }

    public static char[] shuffle(char[] array, Random random) {
        for (int i = array.length - 1; i >= 0; --i) {
            int p = random.nextInt(i + 1);
            char t = array[i];
            array[i] = array[p];
            array[p] = t;
        }
        return array;
    }

    public static char[] shuffle(char[] array, int length, Random random) {
        return CharArrays.shuffle(array, 0, length, random);
    }

    public static char[] shuffle(char[] array, int offset, int length, Random random) {
        for (int i = length - 1; i >= 0; --i) {
            int p = offset + random.nextInt(i + 1);
            char t = array[offset + i];
            array[offset + i] = array[p];
            array[p] = t;
        }
        return array;
    }

    public static char[] reverse(char[] array) {
        return CharArrays.reverse(array, 0, array.length);
    }

    public static char[] reverse(char[] array, int length) {
        return CharArrays.reverse(array, 0, length);
    }

    public static char[] reverse(char[] array, int offset, int length) {
        int i = offset;
        int mid = offset + length >> 1;
        int j = offset + length - 1;
        while (i < mid) {
            char temp = array[i];
            array[i] = array[j];
            array[j] = temp;
            ++i;
            --j;
        }
        return array;
    }

    public static char[] stableSort(char[] array, CharComparator comp) {
        CharArrays.stableSort(array, 0, array.length, comp);
        return array;
    }

    public static void stableSort(char[] array, int length, CharComparator comp) {
        CharArrays.stableSort(array, 0, length, comp);
    }

    public static void stableSort(char[] array, int from, int to, CharComparator comp) {
        CharArrays.mergeSort(array, null, from, to, comp);
    }

    public static char[] stableSort(char[] array) {
        CharArrays.stableSort(array, 0, array.length);
        return array;
    }

    public static void stableSort(char[] array, int length) {
        CharArrays.stableSort(array, 0, length);
    }

    public static void stableSort(char[] array, int from, int to) {
        CharArrays.mergeSort(array, null, from, to);
    }

    public static char[] unstableSort(char[] array, CharComparator comp) {
        CharArrays.unstableSort(array, 0, array.length, comp);
        return array;
    }

    public static void unstableSort(char[] array, int length, CharComparator comp) {
        CharArrays.unstableSort(array, 0, length, comp);
    }

    public static void unstableSort(char[] array, int from, int to, CharComparator comp) {
        CharArrays.quickSort(array, from, to, comp);
    }

    public static char[] unstableSort(char[] array) {
        CharArrays.unstableSort(array, 0, array.length);
        return array;
    }

    public static void unstableSort(char[] array, int length) {
        CharArrays.unstableSort(array, 0, length);
    }

    public static void unstableSort(char[] array, int from, int to) {
        CharArrays.quickSort(array, from, to);
    }

    public static char[] insertionSort(char[] array, CharComparator comp) {
        CharArrays.insertionSort(array, 0, array.length, comp);
        return array;
    }

    public static void insertionSort(char[] array, int length, CharComparator comp) {
        CharArrays.insertionSort(array, 0, length, comp);
    }

    public static void insertionSort(char[] array, int from, int to, CharComparator comp) {
        for (int i = from + 1; i < to; ++i) {
            char current = array[i];
            int j = i - 1;
            while (j >= from && comp.compare(current, array[j]) < 0) {
                array[j + 1] = array[j--];
            }
            array[j + 1] = current;
        }
    }

    public static char[] insertionSort(char[] array) {
        CharArrays.insertionSort(array, 0, array.length);
        return array;
    }

    public static void insertionSort(char[] array, int length) {
        CharArrays.insertionSort(array, 0, length);
    }

    public static void insertionSort(char[] array, int from, int to) {
        for (int i = from + 1; i < to; ++i) {
            char current = array[i];
            int j = i - 1;
            while (j >= from && Character.compare(current, array[j]) < 0) {
                array[j + 1] = array[j--];
            }
            array[j + 1] = current;
        }
    }

    public static char[] selectionSort(char[] array, CharComparator comp) {
        CharArrays.selectionSort(array, 0, array.length, comp);
        return array;
    }

    public static void selectionSort(char[] array, int length, CharComparator comp) {
        CharArrays.selectionSort(array, 0, length, comp);
    }

    public static void selectionSort(char[] array, int from, int to, CharComparator comp) {
        for (int i = from; i < to; ++i) {
            char min = array[i];
            int minId = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(array[j], min) >= 0) continue;
                min = array[j];
                minId = j;
            }
            char temp = array[i];
            array[i] = min;
            array[minId] = temp;
        }
    }

    public static char[] selectionSort(char[] array) {
        CharArrays.selectionSort(array, 0, array.length);
        return array;
    }

    public static void selectionSort(char[] array, int length) {
        CharArrays.selectionSort(array, 0, length);
    }

    public static void selectionSort(char[] array, int from, int to) {
        int m = to - 1;
        for (int i = from; i < m; ++i) {
            char min = array[i];
            int minId = i;
            for (int j = i + 1; j < to; ++j) {
                if (Character.compare(array[j], min) >= 0) continue;
                min = array[j];
                minId = j;
            }
            char temp = array[i];
            array[i] = min;
            array[minId] = temp;
        }
    }

    public static char[] mergeSort(char[] array, CharComparator comp) {
        CharArrays.mergeSort(array, null, 0, array.length, comp);
        return array;
    }

    public static void mergeSort(char[] array, int length, CharComparator comp) {
        CharArrays.mergeSort(array, null, 0, length, comp);
    }

    public static void mergeSort(char[] array, char[] supp, int from, int to, CharComparator comp) {
        if (to - from < 16) {
            CharArrays.insertionSort(array, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = Arrays.copyOf(array, to);
        }
        int mid = from + to >>> 1;
        CharArrays.mergeSort(supp, array, from, mid, comp);
        CharArrays.mergeSort(supp, array, mid, to, comp);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, array, from, to - from);
            return;
        }
        int p = from;
        int q = mid;
        while (from < to) {
            array[from] = q >= to || p < mid && comp.compare(supp[p], supp[q]) < 0 ? supp[p++] : supp[q++];
            ++from;
        }
    }

    public static char[] mergeSort(char[] array) {
        CharArrays.mergeSort(array, null, 0, array.length);
        return array;
    }

    public static void mergeSort(char[] array, int length) {
        CharArrays.mergeSort(array, null, 0, length);
    }

    public static void mergeSort(char[] array, char[] supp, int from, int to) {
        if (to - from < 16) {
            CharArrays.insertionSort(array, from, to);
            return;
        }
        if (supp == null) {
            supp = Arrays.copyOf(array, to);
        }
        int mid = from + to >>> 1;
        CharArrays.mergeSort(supp, array, from, mid);
        CharArrays.mergeSort(supp, array, mid, to);
        if (Character.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, array, from, to - from);
            return;
        }
        int p = from;
        int q = mid;
        while (from < to) {
            array[from] = q >= to || p < mid && Character.compare(supp[p], supp[q]) < 0 ? supp[p++] : supp[q++];
            ++from;
        }
    }

    public static void parallelMergeSort(char[] array, CharComparator comp) {
        CharArrays.parallelMergeSort(array, null, 0, array.length, comp);
    }

    public static void parallelMergeSort(char[] array, int length, CharComparator comp) {
        CharArrays.parallelMergeSort(array, null, 0, length, comp);
    }

    public static void parallelMergeSort(char[] array, char[] supp, int from, int to, CharComparator comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MergeSortActionComp(array, supp, from, to, comp));
            return;
        }
        CharArrays.mergeSort(array, supp, from, to, comp);
    }

    public static void parallelMergeSort(char[] array) {
        CharArrays.parallelMergeSort(array, null, 0, array.length);
    }

    public static void parallelMergeSort(char[] array, int length) {
        CharArrays.parallelMergeSort(array, null, 0, length);
    }

    public static void parallelMergeSort(char[] array, char[] supp, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MergeSortAction(array, supp, from, to));
            return;
        }
        CharArrays.mergeSort(array, supp, from, to);
    }

    public static void memFreeMergeSort(char[] array, CharComparator comp) {
        CharArrays.memFreeMergeSort(array, 0, array.length, comp);
    }

    public static void memFreeMergeSort(char[] array, int length, CharComparator comp) {
        CharArrays.memFreeMergeSort(array, 0, length, comp);
    }

    public static void memFreeMergeSort(char[] array, int from, int to, CharComparator comp) {
        if (to - from < 16) {
            CharArrays.insertionSort(array, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        CharArrays.memFreeMergeSort(array, from, mid, comp);
        CharArrays.memFreeMergeSort(array, mid, to, comp);
        if (comp.compare(array[mid - 1], array[mid]) <= 0) {
            return;
        }
        int i = from;
        int j = mid;
        while (i < j && j < to) {
            int k;
            int compare = comp.compare(array[i], array[j]);
            if (compare < 0) {
                ++i;
                continue;
            }
            if (compare == 0) {
                CharArrays.swap(array, ++i, j);
                continue;
            }
            for (k = j; k < to - 1 && comp.compare(array[i], array[k + 1]) > 0; ++k) {
            }
            if (j == k) {
                CharArrays.swap(array, i++, j);
                continue;
            }
            if (j + 1 == k) {
                char value = array[j];
                System.arraycopy(array, i, array, i + 1, j - i);
                array[i] = value;
                ++i;
                ++j;
                continue;
            }
            char[] data = new char[k - j];
            System.arraycopy(array, j, data, 0, data.length);
            System.arraycopy(array, i, array, i + data.length, j - i);
            System.arraycopy(data, 0, array, i, data.length);
            i += data.length;
            j += data.length;
        }
    }

    public static char[] memFreeMergeSort(char[] array) {
        CharArrays.memFreeMergeSort(array, 0, array.length);
        return array;
    }

    public static void memFreeMergeSort(char[] array, int length) {
        CharArrays.memFreeMergeSort(array, 0, length);
    }

    public static void memFreeMergeSort(char[] array, int from, int to) {
        if (to - from < 16) {
            CharArrays.insertionSort(array, from, to);
            return;
        }
        int mid = from + to >>> 1;
        CharArrays.memFreeMergeSort(array, from, mid);
        CharArrays.memFreeMergeSort(array, mid, to);
        if (Character.compare(array[mid - 1], array[mid]) <= 0) {
            return;
        }
        int i = from;
        int j = mid;
        while (i < j && j < to) {
            int k;
            int comp = Character.compare(array[i], array[j]);
            if (comp < 0) {
                ++i;
                continue;
            }
            if (comp == 0) {
                CharArrays.swap(array, ++i, j);
                continue;
            }
            for (k = j; k < to - 1 && Character.compare(array[i], array[k + 1]) > 0; ++k) {
            }
            if (j == k) {
                CharArrays.swap(array, i++, j);
                continue;
            }
            if (j + 1 == k) {
                char value = array[j];
                System.arraycopy(array, i, array, i + 1, j - i);
                array[i] = value;
                ++i;
                ++j;
                continue;
            }
            char[] data = new char[k - j];
            System.arraycopy(array, j, data, 0, data.length);
            System.arraycopy(array, i, array, i + data.length, j - i);
            System.arraycopy(data, 0, array, i, data.length);
            i += data.length;
            j += data.length;
        }
    }

    public static void parallelMemFreeMergeSort(char[] array, CharComparator comp) {
        CharArrays.parallelMemFreeMergeSort(array, 0, array.length, comp);
    }

    public static void parallelMemFreeMergeSort(char[] array, int length, CharComparator comp) {
        CharArrays.parallelMemFreeMergeSort(array, 0, length, comp);
    }

    public static void parallelMemFreeMergeSort(char[] array, int from, int to, CharComparator comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MemFreeMergeSortActionComp(array, from, to, comp));
            return;
        }
        CharArrays.memFreeMergeSort(array, from, to, comp);
    }

    public static void parallelMemFreeMergeSort(char[] array) {
        CharArrays.parallelMemFreeMergeSort(array, 0, array.length);
    }

    public static void parallelMemFreeMergeSort(char[] array, int length) {
        CharArrays.parallelMemFreeMergeSort(array, 0, length);
    }

    public static void parallelMemFreeMergeSort(char[] array, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new MemFreeMergeSortAction(array, from, to));
            return;
        }
        CharArrays.memFreeMergeSort(array, from, to);
    }

    public static char[] quickSort(char[] array, CharComparator comp) {
        CharArrays.quickSort(array, 0, array.length, comp);
        return array;
    }

    public static void quickSort(char[] array, int length, CharComparator comp) {
        CharArrays.quickSort(array, 0, length, comp);
    }

    public static void quickSort(char[] array, int from, int to, CharComparator comp) {
        int c;
        int a;
        int length = to - from;
        if (length <= 0) {
            return;
        }
        if (length < 16) {
            CharArrays.selectionSort(array, from, to, comp);
            return;
        }
        char pivot = array[length > 128 ? CharArrays.subMedium(array, from, from + length / 2, to - 1, length / 8, comp) : CharArrays.medium(array, from, from + length / 2, to - 1, comp)];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int compare;
            if (b <= c && (compare = comp.compare(array[b], pivot)) <= 0) {
                if (compare == 0) {
                    CharArrays.swap(array, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (compare = comp.compare(array[c], pivot)) >= 0) {
                if (compare == 0) {
                    CharArrays.swap(array, c, d--);
                }
                --c;
            }
            if (b > c) break;
            CharArrays.swap(array, b++, c--);
        }
        CharArrays.swap(array, from, b, Math.min(a - from, b - a));
        CharArrays.swap(array, b, to, Math.min(d - c, to - d - 1));
        length = b - a;
        if (length > 1) {
            CharArrays.quickSort(array, from, from + length, comp);
        }
        if ((length = d - c) > 1) {
            CharArrays.quickSort(array, to - length, to, comp);
        }
    }

    public static char[] quickSort(char[] array) {
        CharArrays.quickSort(array, 0, array.length);
        return array;
    }

    public static void quickSort(char[] array, int length) {
        CharArrays.quickSort(array, 0, length);
    }

    public static void quickSort(char[] array, int from, int to) {
        int c;
        int a;
        int length = to - from;
        if (length <= 0) {
            return;
        }
        if (length < 16) {
            CharArrays.selectionSort(array, from, to);
            return;
        }
        char pivot = array[length > 128 ? CharArrays.subMedium(array, from, from + length / 2, to - 1, length / 8) : CharArrays.medium(array, from, from + length / 2, to - 1)];
        int b = a = from;
        int d = c = to - 1;
        int comp = 0;
        while (true) {
            if (b <= c && (comp = Character.compare(array[b], pivot)) <= 0) {
                if (comp == 0) {
                    CharArrays.swap(array, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Character.compare(array[c], pivot)) >= 0) {
                if (comp == 0) {
                    CharArrays.swap(array, c, d--);
                }
                --c;
            }
            if (b > c) break;
            CharArrays.swap(array, b++, c--);
        }
        CharArrays.swap(array, from, b, Math.min(a - from, b - a));
        CharArrays.swap(array, b, to, Math.min(d - c, to - d - 1));
        length = b - a;
        if (length > 1) {
            CharArrays.quickSort(array, from, from + length);
        }
        if ((length = d - c) > 1) {
            CharArrays.quickSort(array, to - length, to);
        }
    }

    public static void parallelQuickSort(char[] array, CharComparator comp) {
        CharArrays.parallelQuickSort(array, 0, array.length, comp);
    }

    public static void parallelQuickSort(char[] array, int length, CharComparator comp) {
        CharArrays.parallelQuickSort(array, 0, length, comp);
    }

    public static void parallelQuickSort(char[] array, int from, int to, CharComparator comp) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new QuickSortActionComp(array, from, to, comp));
            return;
        }
        CharArrays.quickSort(array, from, to, comp);
    }

    public static void parallelQuickSort(char[] array) {
        CharArrays.parallelQuickSort(array, 0, array.length);
    }

    public static void parallelQuickSort(char[] array, int length) {
        CharArrays.parallelQuickSort(array, 0, length);
    }

    public static void parallelQuickSort(char[] array, int from, int to) {
        if (SanityChecks.canParallelTask() && to - from >= 8192) {
            SanityChecks.invokeTask(new QuickSortAction(array, from, to));
            return;
        }
        CharArrays.quickSort(array, from, to);
    }

    static void swap(char[] a, int from, int to) {
        char t = a[from];
        a[from] = a[to];
        a[to] = t;
    }

    static void swap(char[] a, int from, int to, int length) {
        to -= length;
        for (int i = 0; i < length; ++i) {
            CharArrays.swap(a, from++, to++);
        }
    }

    static int subMedium(char[] data, int a, int b, int c, int length, CharComparator comp) {
        return CharArrays.medium(data, CharArrays.medium(data, a, a + length, a + length * 2, comp), CharArrays.medium(data, b - length, b, b + length, comp), CharArrays.medium(data, c - length * 2, c - length, c, comp), comp);
    }

    static int medium(char[] data, int a, int b, int c, CharComparator comp) {
        return comp.compare(data[a], data[b]) < 0 ? (comp.compare(data[b], data[c]) < 0 ? b : (comp.compare(data[a], data[c]) < 0 ? c : a)) : (comp.compare(data[b], data[c]) > 0 ? b : (comp.compare(data[a], data[c]) > 0 ? c : a));
    }

    static int subMedium(char[] data, int a, int b, int c, int length) {
        return CharArrays.medium(data, CharArrays.medium(data, a, a + length, a + length * 2), CharArrays.medium(data, b - length, b, b + length), CharArrays.medium(data, c - length * 2, c - length, c));
    }

    static int medium(char[] data, int a, int b, int c) {
        return Character.compare(data[a], data[b]) < 0 ? (Character.compare(data[b], data[c]) < 0 ? b : (Character.compare(data[a], data[c]) < 0 ? c : a)) : (Character.compare(data[b], data[c]) > 0 ? b : (Character.compare(data[a], data[c]) > 0 ? c : a));
    }

    static class MemFreeMergeSortActionComp
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        char[] array;
        int from;
        int to;
        CharComparator comp;

        MemFreeMergeSortActionComp(char[] array, int from, int to, CharComparator comp) {
            this.array = array;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                CharArrays.insertionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            int mid = this.from + this.to >>> 1;
            MemFreeMergeSortActionComp.invokeAll(new MemFreeMergeSortActionComp(this.array, this.from, mid, this.comp), new MemFreeMergeSortActionComp(this.array, mid, this.to, this.comp));
            if (this.comp.compare(this.array[mid - 1], this.array[mid]) <= 0) {
                return;
            }
            int i = this.from;
            int j = mid;
            while (i < j && j < this.to) {
                int k;
                int compare = this.comp.compare(this.array[i], this.array[j]);
                if (compare < 0) {
                    ++i;
                    continue;
                }
                if (compare == 0) {
                    CharArrays.swap(this.array, ++i, j);
                    continue;
                }
                for (k = j; k < this.to - 1 && this.comp.compare(this.array[i], this.array[k + 1]) > 0; ++k) {
                }
                if (j == k) {
                    CharArrays.swap(this.array, i++, j);
                    continue;
                }
                if (j + 1 == k) {
                    char value = this.array[j];
                    System.arraycopy(this.array, i, this.array, i + 1, j - i);
                    this.array[i] = value;
                    ++i;
                    ++j;
                    continue;
                }
                char[] data = new char[k - j];
                System.arraycopy(this.array, j, data, 0, data.length);
                System.arraycopy(this.array, i, this.array, i + data.length, j - i);
                System.arraycopy(data, 0, this.array, i, data.length);
                i += data.length;
                j += data.length;
            }
        }
    }

    static class MemFreeMergeSortAction
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        char[] array;
        int from;
        int to;

        MemFreeMergeSortAction(char[] array, int from, int to) {
            this.array = array;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                CharArrays.insertionSort(this.array, this.from, this.to);
                return;
            }
            int mid = this.from + this.to >>> 1;
            MemFreeMergeSortAction.invokeAll(new MemFreeMergeSortAction(this.array, this.from, mid), new MemFreeMergeSortAction(this.array, mid, this.to));
            if (Character.compare(this.array[mid - 1], this.array[mid]) <= 0) {
                return;
            }
            int i = this.from;
            int j = mid;
            while (i < j && j < this.to) {
                int k;
                int comp = Character.compare(this.array[i], this.array[j]);
                if (comp < 0) {
                    ++i;
                    continue;
                }
                if (comp == 0) {
                    CharArrays.swap(this.array, ++i, j);
                    continue;
                }
                for (k = j; k < this.to - 1 && Character.compare(this.array[i], this.array[k + 1]) > 0; ++k) {
                }
                if (j == k) {
                    CharArrays.swap(this.array, i++, j);
                    continue;
                }
                if (j + 1 == k) {
                    char value = this.array[j];
                    System.arraycopy(this.array, i, this.array, i + 1, j - i);
                    this.array[i] = value;
                    ++i;
                    ++j;
                    continue;
                }
                char[] data = new char[k - j];
                System.arraycopy(this.array, j, data, 0, data.length);
                System.arraycopy(this.array, i, this.array, i + data.length, j - i);
                System.arraycopy(data, 0, this.array, i, data.length);
                i += data.length;
                j += data.length;
            }
        }
    }

    static class MergeSortActionComp
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        char[] array;
        char[] supp;
        int from;
        int to;
        CharComparator comp;

        MergeSortActionComp(char[] array, char[] supp, int from, int to, CharComparator comp) {
            this.array = array;
            this.supp = supp;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                CharArrays.insertionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            if (this.supp == null) {
                this.supp = Arrays.copyOf(this.array, this.to);
            }
            int mid = this.from + this.to >>> 1;
            MergeSortActionComp.invokeAll(new MergeSortActionComp(this.supp, this.array, this.from, mid, this.comp), new MergeSortActionComp(this.supp, this.array, mid, this.to, this.comp));
            if (this.comp.compare(this.supp[mid - 1], this.supp[mid]) <= 0) {
                System.arraycopy(this.supp, this.from, this.array, this.from, this.to - this.from);
                return;
            }
            int p = this.from;
            int q = mid;
            while (this.from < this.to) {
                this.array[this.from] = q >= this.to || p < mid && this.comp.compare(this.supp[p], this.supp[q]) < 0 ? this.supp[p++] : this.supp[q++];
                ++this.from;
            }
        }
    }

    static class MergeSortAction
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        char[] array;
        char[] supp;
        int from;
        int to;

        MergeSortAction(char[] array, char[] supp, int from, int to) {
            this.array = array;
            this.supp = supp;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            if (this.to - this.from < 16) {
                CharArrays.insertionSort(this.array, this.from, this.to);
                return;
            }
            if (this.supp == null) {
                this.supp = Arrays.copyOf(this.array, this.to);
            }
            int mid = this.from + this.to >>> 1;
            MergeSortAction.invokeAll(new MergeSortAction(this.supp, this.array, this.from, mid), new MergeSortAction(this.supp, this.array, mid, this.to));
            if (Character.compare(this.supp[mid - 1], this.supp[mid]) <= 0) {
                System.arraycopy(this.supp, this.from, this.array, this.from, this.to - this.from);
                return;
            }
            int p = this.from;
            int q = mid;
            while (this.from < this.to) {
                this.array[this.from] = q >= this.to || p < mid && Character.compare(this.supp[p], this.supp[q]) < 0 ? this.supp[p++] : this.supp[q++];
                ++this.from;
            }
        }
    }

    static class QuickSortActionComp
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        char[] array;
        int from;
        int to;
        CharComparator comp;

        QuickSortActionComp(char[] array, int from, int to, CharComparator comp) {
            this.array = array;
            this.from = from;
            this.to = to;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            int length = this.to - this.from;
            if (length <= 0) {
                return;
            }
            if (length < 16) {
                CharArrays.selectionSort(this.array, this.from, this.to, this.comp);
                return;
            }
            char pivot = this.array[length > 128 ? CharArrays.subMedium(this.array, this.from, this.from + length / 2, this.to - 1, length / 8, this.comp) : CharArrays.medium(this.array, this.from, this.from + length / 2, this.to - 1, this.comp)];
            int b = a = this.from;
            int d = c = this.to - 1;
            while (true) {
                int compare;
                if (b <= c && (compare = this.comp.compare(this.array[b], pivot)) <= 0) {
                    if (compare == 0) {
                        CharArrays.swap(this.array, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (compare = this.comp.compare(this.array[c], pivot)) >= 0) {
                    if (compare == 0) {
                        CharArrays.swap(this.array, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                CharArrays.swap(this.array, b++, c--);
            }
            CharArrays.swap(this.array, this.from, b, Math.min(a - this.from, b - a));
            CharArrays.swap(this.array, b, this.to, Math.min(d - c, this.to - d - 1));
            if (b - a > 1 && d - c > 1) {
                QuickSortActionComp.invokeAll(new QuickSortActionComp(this.array, this.from, this.from + (b - a), this.comp), new QuickSortActionComp(this.array, this.to - (d - c), this.to, this.comp));
            } else if (b - a > 1) {
                new QuickSortActionComp(this.array, this.from, this.from + (b - a), this.comp).invoke();
            } else if (d - c > 1) {
                new QuickSortActionComp(this.array, this.to - (d - c), this.to, this.comp).invoke();
            }
        }
    }

    static class QuickSortAction
    extends RecursiveAction {
        private static final long serialVersionUID = 0L;
        char[] array;
        int from;
        int to;

        QuickSortAction(char[] array, int from, int to) {
            this.array = array;
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            int c;
            int a;
            int length = this.to - this.from;
            if (length <= 0) {
                return;
            }
            if (length < 16) {
                CharArrays.selectionSort(this.array, this.from, this.to);
                return;
            }
            char pivot = this.array[length > 128 ? CharArrays.subMedium(this.array, this.from, this.from + length / 2, this.to - 1, length / 8) : CharArrays.medium(this.array, this.from, this.from + length / 2, this.to - 1)];
            int b = a = this.from;
            int d = c = this.to - 1;
            int comp = 0;
            while (true) {
                if (b <= c && (comp = Character.compare(this.array[b], pivot)) <= 0) {
                    if (comp == 0) {
                        CharArrays.swap(this.array, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comp = Character.compare(this.array[c], pivot)) >= 0) {
                    if (comp == 0) {
                        CharArrays.swap(this.array, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                CharArrays.swap(this.array, b++, c--);
            }
            CharArrays.swap(this.array, this.from, b, Math.min(a - this.from, b - a));
            CharArrays.swap(this.array, b, this.to, Math.min(d - c, this.to - d - 1));
            if (b - a > 1 && d - c > 1) {
                QuickSortAction.invokeAll(new QuickSortAction(this.array, this.from, this.from + (b - a)), new QuickSortAction(this.array, this.to - (d - c), this.to));
            } else if (b - a > 1) {
                new QuickSortAction(this.array, this.from, this.from + (b - a)).invoke();
            } else if (d - c > 1) {
                new QuickSortAction(this.array, this.to - (d - c), this.to).invoke();
            }
        }
    }
}

