/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.floats.functions;

import java.util.Comparator;
import java.util.Objects;

public interface FloatComparator
extends Comparator<Float> {
    @Override
    public int compare(float var1, float var2);

    @Override
    @Deprecated
    default public int compare(Float o1, Float o2) {
        return this.compare(o1.floatValue(), o2.floatValue());
    }

    public static FloatComparator of(Comparator<Float> c) {
        Objects.requireNonNull(c);
        return (K, V) -> c.compare(Float.valueOf(K), Float.valueOf(V));
    }

    default public FloatComparator reversed() {
        return new Reversed(this);
    }

    public static class Reversed
    implements FloatComparator {
        FloatComparator original;

        public Reversed(FloatComparator original) {
            this.original = original;
        }

        @Override
        public int compare(float o1, float o2) {
            return this.original.compare(o2, o1);
        }

        @Override
        public FloatComparator reversed() {
            return this.original;
        }
    }
}

