/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.collections.ObjectSplititerator;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.functions.function.UnaryOperator;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.lists.ObjectList;
import speiger.src.collections.objects.sets.ObjectLinkedOpenHashSet;
import speiger.src.collections.objects.sets.ObjectSet;
import speiger.src.collections.objects.utils.ObjectArrays;
import speiger.src.collections.objects.utils.ObjectIterables;
import speiger.src.collections.objects.utils.ObjectIterators;
import speiger.src.collections.objects.utils.ObjectSplititerators;
import speiger.src.collections.utils.ISizeProvider;

public interface ObjectIterable<T>
extends Iterable<T> {
    @Override
    public ObjectIterator<T> iterator();

    default public void forEachIndexed(IntObjectConsumer<T> action) {
        Objects.requireNonNull(action);
        int index = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            action.accept(index++, (T)iter.next());
        }
    }

    default public <E> void forEach(E input, ObjectObjectConsumer<E, T> action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(input, action);
    }

    @Override
    default public ObjectSplititerator<T> spliterator() {
        return ObjectSplititerators.createUnknownSplititerator(this.iterator(), 0);
    }

    default public <E> ObjectIterable<E> map(UnaryOperator<T, E> mapper) {
        return ObjectIterables.map(this, mapper);
    }

    default public <E, V extends Iterable<E>> ObjectIterable<E> flatMap(UnaryOperator<T, V> mapper) {
        return ObjectIterables.flatMap(this, mapper);
    }

    default public <E> ObjectIterable<E> arrayflatMap(UnaryOperator<T, E[]> mapper) {
        return ObjectIterables.arrayFlatMap(this, mapper);
    }

    default public ObjectIterable<T> filter(Predicate<T> filter) {
        return ObjectIterables.filter(this, filter);
    }

    default public ObjectIterable<T> distinct() {
        return ObjectIterables.distinct(this);
    }

    default public ObjectIterable<T> repeat(int repeats) {
        return ObjectIterables.repeat(this, repeats);
    }

    default public ObjectIterable<T> limit(long limit) {
        return ObjectIterables.limit(this, limit);
    }

    default public ObjectIterable<T> sorted(Comparator<T> sorter) {
        return ObjectIterables.sorted(this, sorter);
    }

    default public ObjectIterable<T> peek(Consumer<T> action) {
        return ObjectIterables.peek(this, action);
    }

    default public <E extends ObjectCollection<T>> E pour(E collection) {
        ObjectIterators.pour(this.iterator(), collection);
        return collection;
    }

    default public ObjectList<T> pourAsList() {
        return this.pour(new ObjectArrayList());
    }

    default public ObjectSet<T> pourAsSet() {
        return this.pour(new ObjectLinkedOpenHashSet());
    }

    default public <E> E[] toArray(IntFunction<E[]> action) {
        int size;
        ISizeProvider prov = ISizeProvider.of(this);
        if (prov != null && (size = prov.size()) >= 0) {
            E[] array = action.apply(size);
            ObjectIterators.unwrap(array, this.iterator());
            return array;
        }
        return ObjectArrays.pour(this.iterator(), action);
    }

    default public boolean matchesAny(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.next())) continue;
            return true;
        }
        return false;
    }

    default public boolean matchesNone(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.next())) continue;
            return false;
        }
        return true;
    }

    default public boolean matchesAll(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (filter.test(iter.next())) continue;
            return false;
        }
        return true;
    }

    default public T findFirst(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        for (Object entry : this) {
            if (!filter.test(entry)) continue;
            return (T)entry;
        }
        return null;
    }

    default public <E> E reduce(E identity, BiFunction<E, T, E> operator) {
        Objects.requireNonNull(operator);
        E state = identity;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            state = operator.apply(state, iter.next());
        }
        return state;
    }

    default public T reduce(ObjectObjectUnaryOperator<T, T> operator) {
        Objects.requireNonNull(operator);
        Object state = null;
        boolean empty = true;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (empty) {
                empty = false;
                state = iter.next();
                continue;
            }
            state = operator.apply(state, iter.next());
        }
        return state;
    }

    default public int count(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        int result = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.next())) continue;
            ++result;
        }
        return result;
    }
}

