/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.maps.impl.hash;

import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.objects.collections.AbstractObjectCollection;
import speiger.src.collections.objects.collections.ObjectBidirectionalIterator;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.lists.ObjectListIterator;
import speiger.src.collections.objects.maps.abstracts.AbstractObject2ObjectMap;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectOpenHashMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectMap;
import speiger.src.collections.objects.maps.interfaces.Object2ObjectOrderedMap;
import speiger.src.collections.objects.sets.AbstractObjectSet;
import speiger.src.collections.objects.sets.ObjectOrderedSet;
import speiger.src.collections.utils.HashUtil;

public class Object2ObjectLinkedOpenHashMap<T, V>
extends Object2ObjectOpenHashMap<T, V>
implements Object2ObjectOrderedMap<T, V> {
    protected transient long[] links = new long[this.nullIndex + 1];
    protected int firstIndex = -1;
    protected int lastIndex = -1;

    public Object2ObjectLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Object2ObjectLinkedOpenHashMap(int minCapacity) {
        this(minCapacity, 0.75f);
    }

    public Object2ObjectLinkedOpenHashMap(int minCapacity, float loadFactor) {
        super(minCapacity, loadFactor);
    }

    public Object2ObjectLinkedOpenHashMap(T[] keys, V[] values) {
        this(keys, values, 0.75f);
    }

    public Object2ObjectLinkedOpenHashMap(T[] keys, V[] values, float loadFactor) {
        this(keys.length, loadFactor);
        if (keys.length != values.length) {
            throw new IllegalStateException("Input Arrays are not equal size");
        }
        int m = keys.length;
        for (int i = 0; i < m; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    public Object2ObjectLinkedOpenHashMap(Map<? extends T, ? extends V> map) {
        this(map, 0.75f);
    }

    public Object2ObjectLinkedOpenHashMap(Map<? extends T, ? extends V> map, float loadFactor) {
        this(map.size(), loadFactor);
        this.putAll(map);
    }

    public Object2ObjectLinkedOpenHashMap(Object2ObjectMap<T, V> map) {
        this(map, 0.75f);
    }

    public Object2ObjectLinkedOpenHashMap(Object2ObjectMap<T, V> map, float loadFactor) {
        this(map.size(), loadFactor);
        this.putAll(map);
    }

    @Override
    public V putAndMoveToFirst(T key, V value) {
        if (key == null) {
            if (this.containsNull) {
                Object lastValue = this.values[this.nullIndex];
                this.values[this.nullIndex] = value;
                this.moveToFirstIndex(this.nullIndex);
                return (V)lastValue;
            }
            this.values[this.nullIndex] = value;
            this.containsNull = true;
            this.onNodeAdded(this.nullIndex);
            this.moveToFirstIndex(this.nullIndex);
        } else {
            int pos = HashUtil.mix(Objects.hashCode(key)) & this.mask;
            while (this.keys[pos] != null) {
                if (Objects.equals(this.keys[pos], key)) {
                    Object lastValue = this.values[pos];
                    this.values[pos] = value;
                    this.moveToFirstIndex(pos);
                    return (V)lastValue;
                }
                ++pos;
                pos &= this.mask;
            }
            this.keys[pos] = key;
            this.values[pos] = value;
            this.onNodeAdded(pos);
            this.moveToFirstIndex(pos);
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashUtil.arraySize(this.size + 1, this.loadFactor));
        }
        return this.getDefaultReturnValue();
    }

    @Override
    public V putAndMoveToLast(T key, V value) {
        if (key == null) {
            if (this.containsNull) {
                Object lastValue = this.values[this.nullIndex];
                this.values[this.nullIndex] = value;
                this.moveToLastIndex(this.nullIndex);
                return (V)lastValue;
            }
            this.values[this.nullIndex] = value;
            this.containsNull = true;
            this.onNodeAdded(this.nullIndex);
            this.moveToLastIndex(this.nullIndex);
        } else {
            int pos = HashUtil.mix(Objects.hashCode(key)) & this.mask;
            while (this.keys[pos] != null) {
                if (Objects.equals(this.keys[pos], key)) {
                    Object lastValue = this.values[pos];
                    this.values[pos] = value;
                    this.moveToLastIndex(pos);
                    return (V)lastValue;
                }
                ++pos;
                pos &= this.mask;
            }
            this.keys[pos] = key;
            this.values[pos] = value;
            this.onNodeAdded(pos);
            this.moveToLastIndex(pos);
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashUtil.arraySize(this.size + 1, this.loadFactor));
        }
        return this.getDefaultReturnValue();
    }

    @Override
    public boolean moveToFirst(T key) {
        if (this.isEmpty() || Objects.equals(this.firstKey(), key)) {
            return false;
        }
        if (key == null) {
            if (this.containsNull) {
                this.moveToFirstIndex(this.nullIndex);
                return true;
            }
        } else {
            int pos = HashUtil.mix(Objects.hashCode(key)) & this.mask;
            while (this.keys[pos] != null) {
                if (Objects.equals(this.keys[pos], key)) {
                    this.moveToFirstIndex(pos);
                    return true;
                }
                ++pos;
                pos &= this.mask;
            }
        }
        return false;
    }

    @Override
    public boolean moveToLast(T key) {
        if (this.isEmpty() || Objects.equals(this.lastKey(), key)) {
            return false;
        }
        if (key == null) {
            if (this.containsNull) {
                this.moveToLastIndex(this.nullIndex);
                return true;
            }
        } else {
            int pos = HashUtil.mix(Objects.hashCode(key)) & this.mask;
            while (this.keys[pos] != null) {
                if (Objects.equals(this.keys[pos], key)) {
                    this.moveToLastIndex(pos);
                    return true;
                }
                ++pos;
                pos &= this.mask;
            }
        }
        return false;
    }

    @Override
    public V getAndMoveToFirst(T key) {
        int index = this.findIndex(key);
        if (index < 0) {
            return this.getDefaultReturnValue();
        }
        this.moveToFirstIndex(index);
        return (V)this.values[index];
    }

    @Override
    public V getAndMoveToLast(T key) {
        int index = this.findIndex(key);
        if (index < 0) {
            return this.getDefaultReturnValue();
        }
        this.moveToLastIndex(index);
        return (V)this.values[index];
    }

    @Override
    public boolean containsValue(Object value) {
        int index = this.firstIndex;
        while (index != -1) {
            if (Objects.equals(this.values[index], value)) {
                return true;
            }
            index = (int)this.links[index];
        }
        return false;
    }

    @Override
    public Object2ObjectLinkedOpenHashMap<T, V> copy() {
        Object2ObjectLinkedOpenHashMap<T, V> map = new Object2ObjectLinkedOpenHashMap<T, V>(0, this.loadFactor);
        map.minCapacity = this.minCapacity;
        map.mask = this.mask;
        map.maxFill = this.maxFill;
        map.nullIndex = this.nullIndex;
        map.containsNull = this.containsNull;
        map.size = this.size;
        map.keys = Arrays.copyOf(this.keys, this.keys.length);
        map.values = Arrays.copyOf(this.values, this.values.length);
        map.links = Arrays.copyOf(this.links, this.links.length);
        map.firstIndex = this.firstIndex;
        map.lastIndex = this.lastIndex;
        return map;
    }

    @Override
    public T firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (T)this.keys[this.firstIndex];
    }

    @Override
    public T pollFirstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int pos = this.firstIndex;
        this.onNodeRemoved(pos);
        Object result = this.keys[pos];
        --this.size;
        if (result == null) {
            this.containsNull = false;
            this.keys[this.nullIndex] = null;
            this.values[this.nullIndex] = null;
        } else {
            this.shiftKeys(pos);
        }
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return (T)result;
    }

    @Override
    public T lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (T)this.keys[this.lastIndex];
    }

    @Override
    public T pollLastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int pos = this.lastIndex;
        this.onNodeRemoved(pos);
        Object result = this.keys[pos];
        --this.size;
        if (result == null) {
            this.containsNull = false;
            this.keys[this.nullIndex] = null;
            this.values[this.nullIndex] = null;
        } else {
            this.shiftKeys(pos);
        }
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return (T)result;
    }

    @Override
    public V firstValue() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (V)this.values[this.firstIndex];
    }

    @Override
    public V lastValue() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (V)this.values[this.lastIndex];
    }

    @Override
    public ObjectOrderedSet<Object2ObjectMap.Entry<T, V>> object2ObjectEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new MapEntrySet();
        }
        return (ObjectOrderedSet)((Object)this.entrySet);
    }

    @Override
    public ObjectOrderedSet<T> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return (ObjectOrderedSet)this.keySet;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.valuesC == null) {
            this.valuesC = new Values();
        }
        return this.valuesC;
    }

    @Override
    public void forEach(ObjectObjectConsumer<T, V> action) {
        int index = this.firstIndex;
        while (index != -1) {
            action.accept(this.keys[index], this.values[index]);
            index = (int)this.links[index];
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.lastIndex = -1;
        this.firstIndex = -1;
    }

    @Override
    public void clearAndTrim(int size) {
        int request = Math.max(this.minCapacity, HashUtil.nextPowerOfTwo((int)Math.ceil((float)size / this.loadFactor)));
        if (request >= this.nullIndex) {
            this.clear();
            return;
        }
        this.nullIndex = request;
        this.mask = request - 1;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = new Object[request + 1];
        this.values = new Object[request + 1];
        this.links = new long[request + 1];
        this.lastIndex = -1;
        this.firstIndex = -1;
        this.size = 0;
        this.containsNull = false;
    }

    protected void moveToFirstIndex(int startPos) {
        if (this.size == 1 || this.firstIndex == startPos) {
            return;
        }
        if (this.lastIndex == startPos) {
            int n = this.lastIndex = (int)(this.links[startPos] >>> 32);
            this.links[n] = this.links[n] | 0xFFFFFFFFL;
        } else {
            long link = this.links[startPos];
            int prev = (int)(link >>> 32);
            int next = (int)link;
            int n = prev;
            this.links[n] = this.links[n] ^ (this.links[prev] ^ link & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.links[n2] = this.links[n2] ^ (this.links[next] ^ link & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.firstIndex;
        this.links[n] = this.links[n] ^ (this.links[this.firstIndex] ^ ((long)startPos & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.links[startPos] = 0xFFFFFFFF00000000L | (long)this.firstIndex & 0xFFFFFFFFL;
        this.firstIndex = startPos;
    }

    protected void moveToLastIndex(int startPos) {
        if (this.size == 1 || this.lastIndex == startPos) {
            return;
        }
        if (this.firstIndex == startPos) {
            this.firstIndex = (int)this.links[startPos];
            int n = this.lastIndex;
            this.links[n] = this.links[n] | 0xFFFFFFFF00000000L;
        } else {
            long link = this.links[startPos];
            int prev = (int)(link >>> 32);
            int next = (int)link;
            int n = prev;
            this.links[n] = this.links[n] ^ (this.links[prev] ^ link & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.links[n2] = this.links[n2] ^ (this.links[next] ^ link & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.lastIndex;
        this.links[n] = this.links[n] ^ (this.links[this.lastIndex] ^ (long)startPos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.links[startPos] = ((long)this.lastIndex & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.lastIndex = startPos;
    }

    @Override
    protected void onNodeAdded(int pos) {
        if (this.size == 0) {
            this.firstIndex = this.lastIndex = pos;
            this.links[pos] = -1L;
        } else {
            int n = this.lastIndex;
            this.links[n] = this.links[n] ^ (this.links[this.lastIndex] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.links[pos] = ((long)this.lastIndex & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.lastIndex = pos;
        }
    }

    @Override
    protected void onNodeRemoved(int pos) {
        if (this.size == 0) {
            this.lastIndex = -1;
            this.firstIndex = -1;
        } else if (this.firstIndex == pos) {
            this.firstIndex = (int)this.links[pos];
            if (0 <= this.firstIndex) {
                int n = this.firstIndex;
                this.links[n] = this.links[n] | 0xFFFFFFFF00000000L;
            }
        } else if (this.lastIndex == pos) {
            this.lastIndex = (int)(this.links[pos] >>> 32);
            if (0 <= this.lastIndex) {
                int n = this.lastIndex;
                this.links[n] = this.links[n] | 0xFFFFFFFFL;
            }
        } else {
            long link = this.links[pos];
            int prev = (int)(link >>> 32);
            int next = (int)link;
            int n = prev;
            this.links[n] = this.links[n] ^ (this.links[prev] ^ link & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.links[n2] = this.links[n2] ^ (this.links[next] ^ link & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
    }

    @Override
    protected void onNodeMoved(int from, int to) {
        if (this.size == 1) {
            this.firstIndex = this.lastIndex = to;
            this.links[to] = -1L;
        } else if (this.firstIndex == from) {
            this.firstIndex = to;
            int n = (int)this.links[from];
            this.links[n] = this.links[n] ^ (this.links[(int)this.links[from]] ^ ((long)to & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.links[to] = this.links[from];
        } else if (this.lastIndex == from) {
            this.lastIndex = to;
            int n = (int)(this.links[from] >>> 32);
            this.links[n] = this.links[n] ^ (this.links[(int)(this.links[from] >>> 32)] ^ (long)to & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.links[to] = this.links[from];
        } else {
            long link = this.links[from];
            int prev = (int)(link >>> 32);
            int next = (int)link;
            int n = prev;
            this.links[n] = this.links[n] ^ (this.links[prev] ^ (long)to & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.links[n2] = this.links[n2] ^ (this.links[next] ^ ((long)to & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.links[to] = link;
        }
    }

    @Override
    protected void rehash(int newSize) {
        int newMask = newSize - 1;
        Object[] newKeys = new Object[newSize + 1];
        Object[] newValues = new Object[newSize + 1];
        long[] newLinks = new long[newSize + 1];
        int i = this.firstIndex;
        int prev = -1;
        int newPrev = -1;
        this.firstIndex = -1;
        int j = this.size;
        while (j-- != 0) {
            int pos;
            if (this.keys[i] == null) {
                pos = newSize;
            } else {
                pos = HashUtil.mix(Objects.hashCode(this.keys[i])) & newMask;
                while (newKeys[pos] != null) {
                    ++pos;
                    pos &= newMask;
                }
            }
            newKeys[pos] = this.keys[i];
            newValues[pos] = this.values[i];
            if (prev != -1) {
                int n = newPrev;
                newLinks[n] = newLinks[n] ^ (newLinks[newPrev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                newLinks[n2] = newLinks[n2] ^ (newLinks[pos] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos;
            } else {
                newPrev = this.firstIndex = pos;
                newLinks[pos] = -1L;
            }
            prev = i;
            i = (int)this.links[prev];
        }
        this.links = newLinks;
        this.lastIndex = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLinks[n] = newLinks[n] | 0xFFFFFFFFL;
        }
        this.nullIndex = newSize;
        this.mask = newMask;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = newKeys;
        this.values = newValues;
    }

    private class MapIterator {
        int previous = -1;
        int next = -1;
        int current = -1;
        int index = 0;

        MapIterator() {
            this.next = Object2ObjectLinkedOpenHashMap.this.firstIndex;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        MapIterator(T from) {
            if (from == null) {
                if (!Object2ObjectLinkedOpenHashMap.this.containsNull) throw new NoSuchElementException("The null element is not in the set");
                this.next = (int)Object2ObjectLinkedOpenHashMap.this.links[Object2ObjectLinkedOpenHashMap.this.nullIndex];
                this.previous = Object2ObjectLinkedOpenHashMap.this.nullIndex;
                return;
            } else if (Object2ObjectLinkedOpenHashMap.this.keys[Object2ObjectLinkedOpenHashMap.this.lastIndex] == from) {
                this.previous = Object2ObjectLinkedOpenHashMap.this.lastIndex;
                this.index = Object2ObjectLinkedOpenHashMap.this.size;
                return;
            } else {
                int pos = HashUtil.mix(Objects.hashCode(from)) & Object2ObjectLinkedOpenHashMap.this.mask;
                while (Object2ObjectLinkedOpenHashMap.this.keys[pos] != null) {
                    if (Objects.equals(Object2ObjectLinkedOpenHashMap.this.keys[pos], from)) {
                        this.next = (int)Object2ObjectLinkedOpenHashMap.this.links[pos];
                        this.previous = pos;
                        break;
                    }
                    ++pos;
                    pos &= Object2ObjectLinkedOpenHashMap.this.mask;
                }
                if (this.previous != -1 || this.next != -1) return;
                throw new NoSuchElementException("The element was not found");
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.previous != -1;
        }

        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        public void remove() {
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            this.ensureIndexKnown();
            if (this.current == this.previous) {
                --this.index;
                this.previous = (int)(Object2ObjectLinkedOpenHashMap.this.links[this.current] >>> 32);
            } else {
                this.next = (int)Object2ObjectLinkedOpenHashMap.this.links[this.current];
            }
            --Object2ObjectLinkedOpenHashMap.this.size;
            if (this.previous == -1) {
                Object2ObjectLinkedOpenHashMap.this.firstIndex = this.next;
            } else {
                int n = this.previous;
                Object2ObjectLinkedOpenHashMap.this.links[n] = Object2ObjectLinkedOpenHashMap.this.links[n] ^ (Object2ObjectLinkedOpenHashMap.this.links[this.previous] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                Object2ObjectLinkedOpenHashMap.this.lastIndex = this.previous;
            } else {
                int n = this.next;
                Object2ObjectLinkedOpenHashMap.this.links[n] = Object2ObjectLinkedOpenHashMap.this.links[n] ^ (Object2ObjectLinkedOpenHashMap.this.links[this.next] ^ ((long)this.previous & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            if (this.current != Object2ObjectLinkedOpenHashMap.this.nullIndex) {
                int startPos = this.current;
                this.current = -1;
                while (true) {
                    Object current;
                    int last = startPos;
                    startPos = last + 1 & Object2ObjectLinkedOpenHashMap.this.mask;
                    while (true) {
                        if ((current = Object2ObjectLinkedOpenHashMap.this.keys[startPos]) == null) {
                            Object2ObjectLinkedOpenHashMap.this.keys[last] = null;
                            Object2ObjectLinkedOpenHashMap.this.values[last] = null;
                            return;
                        }
                        int slot = HashUtil.mix(Objects.hashCode(current)) & Object2ObjectLinkedOpenHashMap.this.mask;
                        if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                        ++startPos;
                        startPos &= Object2ObjectLinkedOpenHashMap.this.mask;
                    }
                    Object2ObjectLinkedOpenHashMap.this.keys[last] = current;
                    Object2ObjectLinkedOpenHashMap.this.values[last] = Object2ObjectLinkedOpenHashMap.this.values[startPos];
                    if (this.next == startPos) {
                        this.next = last;
                    }
                    if (this.previous == startPos) {
                        this.previous = last;
                    }
                    Object2ObjectLinkedOpenHashMap.this.onNodeMoved(startPos, last);
                }
            }
            this.current = -1;
            Object2ObjectLinkedOpenHashMap.this.containsNull = false;
            Object2ObjectLinkedOpenHashMap.this.keys[Object2ObjectLinkedOpenHashMap.this.nullIndex] = null;
            Object2ObjectLinkedOpenHashMap.this.values[Object2ObjectLinkedOpenHashMap.this.nullIndex] = null;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.current = this.previous;
            this.previous = (int)(Object2ObjectLinkedOpenHashMap.this.links[this.current] >> 32);
            this.next = this.current;
            if (this.index >= 0) {
                --this.index;
            }
            return this.current;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = (int)Object2ObjectLinkedOpenHashMap.this.links[this.current];
            this.previous = this.current;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.current;
        }

        private void ensureIndexKnown() {
            if (this.index == -1) {
                if (this.previous == -1) {
                    this.index = 0;
                } else if (this.next == -1) {
                    this.index = Object2ObjectLinkedOpenHashMap.this.size;
                } else {
                    this.index = 1;
                    int pos = Object2ObjectLinkedOpenHashMap.this.firstIndex;
                    while (pos != this.previous) {
                        pos = (int)Object2ObjectLinkedOpenHashMap.this.links[pos];
                        ++this.index;
                    }
                }
            }
        }
    }

    private class ValueIterator
    extends MapIterator
    implements ObjectListIterator<V> {
        @Override
        public V previous() {
            return Object2ObjectLinkedOpenHashMap.this.values[this.previousEntry()];
        }

        @Override
        public V next() {
            return Object2ObjectLinkedOpenHashMap.this.values[this.nextEntry()];
        }

        @Override
        public void set(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(V e) {
            throw new UnsupportedOperationException();
        }
    }

    private class KeyIterator
    extends MapIterator
    implements ObjectListIterator<T> {
        public KeyIterator() {
        }

        public KeyIterator(T from) {
            super(from);
        }

        @Override
        public T previous() {
            return Object2ObjectLinkedOpenHashMap.this.keys[this.previousEntry()];
        }

        @Override
        public T next() {
            return Object2ObjectLinkedOpenHashMap.this.keys[this.nextEntry()];
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2ObjectMap.Entry<T, V>> {
        Object2ObjectOpenHashMap.MapEntry entry;

        public EntryIterator() {
        }

        public EntryIterator(T from) {
            super(from);
        }

        @Override
        public Object2ObjectMap.Entry<T, V> next() {
            this.entry = new Object2ObjectOpenHashMap.ValueMapEntry(Object2ObjectLinkedOpenHashMap.this, this.nextEntry());
            return this.entry;
        }

        @Override
        public Object2ObjectMap.Entry<T, V> previous() {
            this.entry = new Object2ObjectOpenHashMap.ValueMapEntry(Object2ObjectLinkedOpenHashMap.this, this.previousEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }

        @Override
        public void set(Object2ObjectMap.Entry<T, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2ObjectMap.Entry<T, V> entry) {
            throw new UnsupportedOperationException();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Object2ObjectMap.Entry<T, V>> {
        Object2ObjectOpenHashMap.MapEntry entry;

        public FastEntryIterator() {
            this.entry = new Object2ObjectOpenHashMap.MapEntry(Object2ObjectLinkedOpenHashMap.this);
        }

        public FastEntryIterator(T from) {
            super(from);
            this.entry = new Object2ObjectOpenHashMap.MapEntry(Object2ObjectLinkedOpenHashMap.this);
        }

        @Override
        public Object2ObjectMap.Entry<T, V> next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }

        @Override
        public Object2ObjectMap.Entry<T, V> previous() {
            this.entry.index = this.previousEntry();
            return this.entry;
        }

        @Override
        public void set(Object2ObjectMap.Entry<T, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object2ObjectMap.Entry<T, V> entry) {
            throw new UnsupportedOperationException();
        }
    }

    private class Values
    extends AbstractObjectCollection<V> {
        private Values() {
        }

        @Override
        @Deprecated
        public boolean contains(Object e) {
            return Object2ObjectLinkedOpenHashMap.this.containsValue(e);
        }

        @Override
        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectIterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return Object2ObjectLinkedOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2ObjectLinkedOpenHashMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            Objects.requireNonNull(action);
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(Object2ObjectLinkedOpenHashMap.this.values[index]);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<V> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int count = 0;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(count++, Object2ObjectLinkedOpenHashMap.this.values[index]);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, V> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(input, Object2ObjectLinkedOpenHashMap.this.values[index]);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
        }

        @Override
        public boolean matchesAny(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(Object2ObjectLinkedOpenHashMap.this.values[index])) {
                    return true;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(Object2ObjectLinkedOpenHashMap.this.values[index])) {
                    return false;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (!filter.test(Object2ObjectLinkedOpenHashMap.this.values[index])) {
                    return false;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, V, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                state = operator.apply(state, Object2ObjectLinkedOpenHashMap.this.values[index]);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public V reduce(ObjectObjectUnaryOperator<V, V> operator) {
            Objects.requireNonNull(operator);
            Object state = null;
            boolean empty = true;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (empty) {
                    empty = false;
                    state = Object2ObjectLinkedOpenHashMap.this.values[index];
                    index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
                    continue;
                }
                state = operator.apply(state, Object2ObjectLinkedOpenHashMap.this.values[index]);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public V findFirst(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(Object2ObjectLinkedOpenHashMap.this.values[index])) {
                    return Object2ObjectLinkedOpenHashMap.this.values[index];
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return null;
        }

        @Override
        public int count(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            int result = 0;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(Object2ObjectLinkedOpenHashMap.this.values[index])) {
                    ++result;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return result;
        }
    }

    private final class KeySet
    extends AbstractObjectSet<T>
    implements ObjectOrderedSet<T> {
        private KeySet() {
        }

        @Override
        @Deprecated
        public boolean contains(Object e) {
            return Object2ObjectLinkedOpenHashMap.this.containsKey(e);
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = Object2ObjectLinkedOpenHashMap.this.size;
            Object2ObjectLinkedOpenHashMap.this.remove(o);
            return Object2ObjectLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToFirst(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToLast(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToFirst(T o) {
            return Object2ObjectLinkedOpenHashMap.this.moveToFirst(o);
        }

        @Override
        public boolean moveToLast(T o) {
            return Object2ObjectLinkedOpenHashMap.this.moveToLast(o);
        }

        @Override
        public ObjectListIterator<T> iterator() {
            return new KeyIterator();
        }

        @Override
        public ObjectBidirectionalIterator<T> iterator(T fromElement) {
            return new KeyIterator(fromElement);
        }

        @Override
        public KeySet copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return Object2ObjectLinkedOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2ObjectLinkedOpenHashMap.this.clear();
        }

        @Override
        public T first() {
            return Object2ObjectLinkedOpenHashMap.this.firstKey();
        }

        @Override
        public T pollFirst() {
            return Object2ObjectLinkedOpenHashMap.this.pollFirstKey();
        }

        @Override
        public T last() {
            return Object2ObjectLinkedOpenHashMap.this.lastKey();
        }

        @Override
        public T pollLast() {
            return Object2ObjectLinkedOpenHashMap.this.pollLastKey();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(Object2ObjectLinkedOpenHashMap.this.keys[index]);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<T> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int count = 0;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(count++, (Object)Object2ObjectLinkedOpenHashMap.this.keys[index]);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, T> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(input, (E)Object2ObjectLinkedOpenHashMap.this.keys[index]);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
        }

        @Override
        public boolean matchesAny(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(Object2ObjectLinkedOpenHashMap.this.keys[index])) {
                    return true;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(Object2ObjectLinkedOpenHashMap.this.keys[index])) {
                    return false;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (!filter.test(Object2ObjectLinkedOpenHashMap.this.keys[index])) {
                    return false;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, T, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                state = operator.apply(state, Object2ObjectLinkedOpenHashMap.this.keys[index]);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public T reduce(ObjectObjectUnaryOperator<T, T> operator) {
            Objects.requireNonNull(operator);
            Object state = null;
            boolean empty = true;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (empty) {
                    empty = false;
                    state = Object2ObjectLinkedOpenHashMap.this.keys[index];
                    index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
                    continue;
                }
                state = operator.apply(state, Object2ObjectLinkedOpenHashMap.this.keys[index]);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public T findFirst(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(Object2ObjectLinkedOpenHashMap.this.keys[index])) {
                    return Object2ObjectLinkedOpenHashMap.this.keys[index];
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return null;
        }

        @Override
        public int count(Predicate<T> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            int result = 0;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (filter.test(Object2ObjectLinkedOpenHashMap.this.keys[index])) {
                    ++result;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return result;
        }
    }

    private class MapEntrySet
    extends AbstractObjectSet<Object2ObjectMap.Entry<T, V>>
    implements Object2ObjectOrderedMap.FastOrderedSet<T, V> {
        private MapEntrySet() {
        }

        @Override
        public boolean addAndMoveToFirst(Object2ObjectMap.Entry<T, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToLast(Object2ObjectMap.Entry<T, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToFirst(Object2ObjectMap.Entry<T, V> o) {
            return Object2ObjectLinkedOpenHashMap.this.moveToFirst(o.getKey());
        }

        @Override
        public boolean moveToLast(Object2ObjectMap.Entry<T, V> o) {
            return Object2ObjectLinkedOpenHashMap.this.moveToLast(o.getKey());
        }

        @Override
        public Object2ObjectMap.Entry<T, V> first() {
            return new AbstractObject2ObjectMap.BasicEntry(Object2ObjectLinkedOpenHashMap.this.firstKey(), Object2ObjectLinkedOpenHashMap.this.firstValue());
        }

        @Override
        public Object2ObjectMap.Entry<T, V> last() {
            return new AbstractObject2ObjectMap.BasicEntry(Object2ObjectLinkedOpenHashMap.this.lastKey(), Object2ObjectLinkedOpenHashMap.this.lastValue());
        }

        @Override
        public Object2ObjectMap.Entry<T, V> pollFirst() {
            AbstractObject2ObjectMap.BasicEntry entry = new AbstractObject2ObjectMap.BasicEntry(Object2ObjectLinkedOpenHashMap.this.firstKey(), Object2ObjectLinkedOpenHashMap.this.firstValue());
            Object2ObjectLinkedOpenHashMap.this.pollFirstKey();
            return entry;
        }

        @Override
        public Object2ObjectMap.Entry<T, V> pollLast() {
            AbstractObject2ObjectMap.BasicEntry entry = new AbstractObject2ObjectMap.BasicEntry(Object2ObjectLinkedOpenHashMap.this.lastKey(), Object2ObjectLinkedOpenHashMap.this.lastValue());
            Object2ObjectLinkedOpenHashMap.this.pollLastKey();
            return entry;
        }

        @Override
        public ObjectBidirectionalIterator<Object2ObjectMap.Entry<T, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Object2ObjectMap.Entry<T, V>> iterator(Object2ObjectMap.Entry<T, V> fromElement) {
            return new EntryIterator(fromElement.getKey());
        }

        @Override
        public ObjectBidirectionalIterator<Object2ObjectMap.Entry<T, V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Object2ObjectMap.Entry<T, V>> fastIterator(T fromElement) {
            return new FastEntryIterator(fromElement);
        }

        @Override
        public MapEntrySet copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super Object2ObjectMap.Entry<T, V>> action) {
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(new Object2ObjectOpenHashMap.ValueMapEntry(Object2ObjectLinkedOpenHashMap.this, index));
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
        }

        @Override
        public void fastForEach(Consumer<? super Object2ObjectMap.Entry<T, V>> action) {
            Object2ObjectOpenHashMap.MapEntry entry = new Object2ObjectOpenHashMap.MapEntry(Object2ObjectLinkedOpenHashMap.this);
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(index);
                action.accept(entry);
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<Object2ObjectMap.Entry<T, V>> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int count = 0;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(count++, (Object2ObjectMap.Entry)new Object2ObjectOpenHashMap.ValueMapEntry(Object2ObjectLinkedOpenHashMap.this, index));
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, Object2ObjectMap.Entry<T, V>> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                action.accept(input, new Object2ObjectOpenHashMap.ValueMapEntry(Object2ObjectLinkedOpenHashMap.this, index));
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
        }

        @Override
        public boolean matchesAny(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            Object2ObjectOpenHashMap.MapEntry entry = new Object2ObjectOpenHashMap.MapEntry(Object2ObjectLinkedOpenHashMap.this);
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(index);
                if (filter.test(entry)) {
                    return true;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            Object2ObjectOpenHashMap.MapEntry entry = new Object2ObjectOpenHashMap.MapEntry(Object2ObjectLinkedOpenHashMap.this);
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(index);
                if (filter.test(entry)) {
                    return false;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            Object2ObjectOpenHashMap.MapEntry entry = new Object2ObjectOpenHashMap.MapEntry(Object2ObjectLinkedOpenHashMap.this);
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(index);
                if (!filter.test(entry)) {
                    return false;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, Object2ObjectMap.Entry<T, V>, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                state = operator.apply(state, new Object2ObjectOpenHashMap.ValueMapEntry(Object2ObjectLinkedOpenHashMap.this, index));
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public Object2ObjectMap.Entry<T, V> reduce(ObjectObjectUnaryOperator<Object2ObjectMap.Entry<T, V>, Object2ObjectMap.Entry<T, V>> operator) {
            Objects.requireNonNull(operator);
            Object2ObjectMap.Entry state = null;
            boolean empty = true;
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                if (empty) {
                    empty = false;
                    state = new Object2ObjectOpenHashMap.ValueMapEntry(Object2ObjectLinkedOpenHashMap.this, index);
                    index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
                    continue;
                }
                state = (Object2ObjectMap.Entry)operator.apply(state, new Object2ObjectOpenHashMap.ValueMapEntry(Object2ObjectLinkedOpenHashMap.this, index));
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return state;
        }

        @Override
        public Object2ObjectMap.Entry<T, V> findFirst(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            Object2ObjectOpenHashMap.MapEntry entry = new Object2ObjectOpenHashMap.MapEntry(Object2ObjectLinkedOpenHashMap.this);
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(index);
                if (filter.test(entry)) {
                    return entry;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return null;
        }

        @Override
        public int count(Predicate<Object2ObjectMap.Entry<T, V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            int result = 0;
            Object2ObjectOpenHashMap.MapEntry entry = new Object2ObjectOpenHashMap.MapEntry(Object2ObjectLinkedOpenHashMap.this);
            int index = Object2ObjectLinkedOpenHashMap.this.firstIndex;
            while (index != -1) {
                entry.set(index);
                if (filter.test(entry)) {
                    ++result;
                }
                index = (int)Object2ObjectLinkedOpenHashMap.this.links[index];
            }
            return result;
        }

        @Override
        @Deprecated
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                if (o instanceof Object2ObjectMap.Entry) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)o;
                    int index = Object2ObjectLinkedOpenHashMap.this.findIndex(entry.getKey());
                    if (index >= 0) {
                        return Objects.equals(entry.getValue(), Object2ObjectLinkedOpenHashMap.this.values[index]);
                    }
                } else {
                    Map.Entry entry = (Map.Entry)o;
                    int index = Object2ObjectLinkedOpenHashMap.this.findIndex(entry.getKey());
                    if (index >= 0) {
                        return Objects.equals(entry.getValue(), Object2ObjectLinkedOpenHashMap.this.values[index]);
                    }
                }
            }
            return false;
        }

        @Override
        @Deprecated
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                if (o instanceof Object2ObjectMap.Entry) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)o;
                    return Object2ObjectLinkedOpenHashMap.this.remove(entry.getKey(), entry.getValue());
                }
                Map.Entry entry = (Map.Entry)o;
                return Object2ObjectLinkedOpenHashMap.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public int size() {
            return Object2ObjectLinkedOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2ObjectLinkedOpenHashMap.this.clear();
        }
    }
}

