/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.utils;

import java.util.NoSuchElementException;
import java.util.Set;
import speiger.src.collections.objects.collections.ObjectBidirectionalIterator;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.sets.AbstractObjectSet;
import speiger.src.collections.objects.sets.ObjectOrderedSet;
import speiger.src.collections.objects.sets.ObjectSet;
import speiger.src.collections.objects.utils.ObjectCollections;
import speiger.src.collections.objects.utils.ObjectIterators;
import speiger.src.collections.utils.ITrimmable;

public class ObjectSets {
    private static final ObjectSet<?> EMPTY = new EmptySet();

    public static <T> ObjectSet<T> empty() {
        return EMPTY;
    }

    public static <T> ObjectSet<T> synchronize(ObjectSet<T> s) {
        return s instanceof SynchronizedSet ? s : (s instanceof ITrimmable ? new SynchronizedTrimSet(s) : new SynchronizedSet(s));
    }

    public static <T> ObjectSet<T> synchronize(ObjectSet<T> s, Object mutex) {
        return s instanceof SynchronizedSet ? s : (s instanceof ITrimmable ? new SynchronizedTrimSet(s, mutex) : new SynchronizedSet(s, mutex));
    }

    public static <T> ObjectOrderedSet<T> synchronize(ObjectOrderedSet<T> s) {
        return s instanceof SynchronizedOrderedSet ? s : (s instanceof ITrimmable ? new SynchronizedOrderedTrimSet(s) : new SynchronizedOrderedSet(s));
    }

    public static <T> ObjectOrderedSet<T> synchronize(ObjectOrderedSet<T> s, Object mutex) {
        return s instanceof SynchronizedOrderedSet ? s : (s instanceof ITrimmable ? new SynchronizedOrderedTrimSet(s, mutex) : new SynchronizedOrderedSet(s, mutex));
    }

    public static <T> ObjectSet<T> unmodifiable(ObjectSet<T> s) {
        return s instanceof UnmodifiableSet ? s : new UnmodifiableSet(s);
    }

    public static <T> ObjectOrderedSet<T> unmodifiable(ObjectOrderedSet<T> s) {
        return s instanceof UnmodifiableOrderedSet ? s : new UnmodifiableOrderedSet(s);
    }

    public static <T> ObjectSet<T> singleton(T element) {
        return new SingletonSet<T>(element);
    }

    private static class SynchronizedSet<T>
    extends ObjectCollections.SynchronizedCollection<T>
    implements ObjectSet<T> {
        ObjectSet<T> s;

        SynchronizedSet(ObjectSet<T> c) {
            super(c);
            this.s = c;
        }

        SynchronizedSet(ObjectSet<T> c, Object mutex) {
            super(c, mutex);
            this.s = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T addOrGet(T o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.addOrGet(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectSet<T> copy() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.copy();
            }
        }
    }

    private static class SynchronizedTrimSet<T>
    extends SynchronizedSet<T>
    implements ITrimmable {
        ITrimmable trim;

        SynchronizedTrimSet(ObjectSet<T> c) {
            super(c);
            this.trim = (ITrimmable)((Object)c);
        }

        SynchronizedTrimSet(ObjectSet<T> c, Object mutex) {
            super(c, mutex);
            this.trim = (ITrimmable)((Object)c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean trim(int size) {
            Object object = this.mutex;
            synchronized (object) {
                return this.trim.trim(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearAndTrim(int size) {
            Object object = this.mutex;
            synchronized (object) {
                this.trim.clearAndTrim(size);
            }
        }
    }

    private static class SynchronizedOrderedSet<T>
    extends SynchronizedSet<T>
    implements ObjectOrderedSet<T> {
        ObjectOrderedSet<T> s;

        SynchronizedOrderedSet(ObjectOrderedSet<T> c) {
            super(c);
            this.s = c;
        }

        SynchronizedOrderedSet(ObjectOrderedSet<T> c, Object mutex) {
            super(c, mutex);
            this.s = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAndMoveToFirst(T o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.addAndMoveToFirst(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAndMoveToLast(T o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.addAndMoveToLast(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveToFirst(T o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.moveToFirst(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveToLast(T o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.moveToLast(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectBidirectionalIterator<T> iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectBidirectionalIterator<T> iterator(T fromElement) {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.iterator(fromElement);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectOrderedSet<T> copy() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.copy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T pollFirst() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.pollFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T pollLast() {
            Object object = this.mutex;
            synchronized (object) {
                return this.s.pollLast();
            }
        }
    }

    private static class SynchronizedOrderedTrimSet<T>
    extends SynchronizedOrderedSet<T>
    implements ITrimmable {
        ITrimmable trim;

        SynchronizedOrderedTrimSet(ObjectOrderedSet<T> c) {
            super(c);
            this.trim = (ITrimmable)((Object)c);
        }

        SynchronizedOrderedTrimSet(ObjectOrderedSet<T> c, Object mutex) {
            super(c, mutex);
            this.trim = (ITrimmable)((Object)c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean trim(int size) {
            Object object = this.mutex;
            synchronized (object) {
                return this.trim.trim(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearAndTrim(int size) {
            Object object = this.mutex;
            synchronized (object) {
                this.trim.clearAndTrim(size);
            }
        }
    }

    public static class UnmodifiableSet<T>
    extends ObjectCollections.UnmodifiableCollection<T>
    implements ObjectSet<T> {
        ObjectSet<T> s;

        protected UnmodifiableSet(ObjectSet<T> c) {
            super(c);
            this.s = c;
        }

        @Override
        public T addOrGet(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSet<T> copy() {
            return this.s.copy();
        }
    }

    private static class UnmodifiableOrderedSet<T>
    extends UnmodifiableSet<T>
    implements ObjectOrderedSet<T> {
        ObjectOrderedSet<T> s;

        UnmodifiableOrderedSet(ObjectOrderedSet<T> c) {
            super(c);
            this.s = c;
        }

        @Override
        public boolean addAndMoveToFirst(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAndMoveToLast(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToFirst(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean moveToLast(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectBidirectionalIterator<T> iterator() {
            return ObjectIterators.unmodifiable(this.s.iterator());
        }

        @Override
        public ObjectBidirectionalIterator<T> iterator(T fromElement) {
            return ObjectIterators.unmodifiable(this.s.iterator(fromElement));
        }

        @Override
        public ObjectOrderedSet<T> copy() {
            return this.s.copy();
        }

        @Override
        public T first() {
            return this.s.first();
        }

        @Override
        public T pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T last() {
            return this.s.last();
        }

        @Override
        public T pollLast() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptySet<T>
    extends ObjectCollections.EmptyCollection<T>
    implements ObjectSet<T> {
        private EmptySet() {
        }

        @Override
        public T addOrGet(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            return ((Set)o).isEmpty();
        }

        @Override
        public EmptySet<T> copy() {
            return this;
        }
    }

    private static class SingletonSet<T>
    extends AbstractObjectSet<T> {
        T element;

        SingletonSet(T element) {
            this.element = element;
        }

        @Override
        public boolean add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T addOrGet(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectIterator<T> iterator() {
            return new ObjectIterator<T>(){
                boolean next = true;

                @Override
                public boolean hasNext() {
                    return this.next;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.next = false;
                    return element;
                }
            };
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public SingletonSet<T> copy() {
            return new SingletonSet<T>(this.element);
        }
    }
}

