/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.gui;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.base.impl.gui.base.IInteractable;
import pregenerator.base.impl.gui.base.IInteractableContainer;
import pregenerator.base.impl.gui.base.IRenderable;
import pregenerator.base.impl.gui.base.IWidget;
import pregenerator.base.impl.gui.comp.CycleButton;
import pregenerator.base.impl.gui.comp.PregenButton;
import pregenerator.base.impl.gui.comp.PregenCheckBox;
import pregenerator.base.impl.gui.comp.PregenList;
import pregenerator.base.impl.gui.comp.PregenSlider;
import pregenerator.base.impl.gui.comp.PregenText;
import pregenerator.base.impl.gui.comp.PregenTreeList;

public abstract class BasePregenScreen
extends GuiScreen
implements IInteractableContainer {
    private static final float U_SCALE = 0.00390625f;
    private static final float V_SCALE = 0.00390625f;
    public static final DecimalFormat NUMBERS = TextUtil.NUMBERS;
    public static final DecimalFormat FLOATING_NUMBERS = TextUtil.FLOATING_NUMBERS;
    public static final DecimalFormat FLOATING_NUMBERS_EXTENDED = TextUtil.FLOATING_NUMBERS_EXTENDED;
    private static final ScissorsStack STACK = new ScissorsStack();
    List<IInteractable> interactables = new ObjectArrayList();
    List<IRenderable> renderable = new ObjectArrayList();
    private IInteractable focused;
    private boolean isDragging;
    protected int centerX;
    protected int centerY;
    protected int tick;
    int lastMouseX = 0;
    int lastMouseY = 0;
    long lastCheck = 0L;
    int lastDrawnToolTipAmount = 0;
    boolean renderTooltip = false;

    public void func_73866_w_() {
        super.func_73866_w_();
        this.centerX = this.field_146294_l / 2;
        this.centerY = this.field_146295_m / 2;
        this.interactables.clear();
        this.renderable.clear();
    }

    public void func_146269_k() throws IOException {
        double weel = (double)Mouse.getDWheel() / 120.0;
        if ((int)weel != 0) {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.mouseScroll(mouseX, mouseY, weel);
        }
        super.func_146269_k();
        this.tick();
    }

    public void tick() {
        ++this.tick;
    }

    public <T extends IWidget> T addWidget(T widget) {
        this.interactables.add(widget);
        this.renderable.add(widget);
        return widget;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(mouseX, mouseY, partialTicks);
        this.renderWidgets(mouseX, mouseY, partialTicks);
        this.renderForeground(mouseX, mouseY, partialTicks);
        this.renderTooltips(mouseX, mouseY, partialTicks);
    }

    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
    }

    public void renderWidgets(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (IRenderable render : this.renderable) {
            render.render(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
    }

    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
    }

    public void collectTooltips(int mouseX, int mouseY, float partialTicks, Consumer<ITextComponent> tooltips) {
    }

    public void renderTooltips(int mouseX, int mouseY, float partialTicks) {
        ObjectArrayList tooltips = new ObjectArrayList();
        if (mouseX != Integer.MAX_VALUE && mouseY != Integer.MAX_VALUE) {
            for (IInteractable iInteractable : this.children()) {
                if (!(iInteractable instanceof ITooltipProvider)) continue;
                ((ITooltipProvider)((Object)iInteractable)).provideTooltips(arg_0 -> this.lambda$renderTooltips$0((List)tooltips, mouseX, arg_0));
            }
            this.collectTooltips(mouseX, mouseY, partialTicks, arg_0 -> this.lambda$renderTooltips$1((List)tooltips, mouseX, arg_0));
        }
        if (!this.renderTooltip && (this.lastMouseX != mouseX || this.lastMouseY != mouseY) || tooltips.isEmpty()) {
            this.lastCheck = System.currentTimeMillis();
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.lastDrawnToolTipAmount = 0;
            if (tooltips.isEmpty()) {
                this.renderTooltip = false;
            }
            return;
        }
        if (System.currentTimeMillis() - this.lastCheck < (long)PregenConfig.INSTANCE.tooltipDelay.get()) {
            this.lastDrawnToolTipAmount = 0;
            return;
        }
        this.renderTooltip = true;
        this.lastDrawnToolTipAmount = 0;
        this.func_146283_a((List)tooltips, mouseX, mouseY);
        this.lastDrawnToolTipAmount = tooltips.size();
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public final boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public final void setDragging(boolean value) {
        this.isDragging = value;
    }

    @Override
    public IInteractable getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(IInteractable interact) {
        this.focused = interact;
    }

    @Override
    public List<? extends IInteractable> children() {
        return this.interactables;
    }

    protected boolean shouldCloseOnEsc() {
        return true;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.charTyped(typedChar, keyCode)) {
            return;
        }
        if (keyCode == 1 && this.shouldCloseOnEsc()) {
            this.onClose();
        }
    }

    protected void onClose() {
        this.field_146297_k.func_147108_a((GuiScreen)null);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (this.mouseClick(mouseX, mouseY, mouseButton)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.mouseRelease(mouseX, mouseY, state)) {
            return;
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        double diffX = mouseX - this.lastMouseX;
        double diffY = mouseY - this.lastMouseY;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (this.mouseDrag(mouseX, mouseY, clickedMouseButton, diffX, diffY)) {
            return;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public PregenButton button(int x, int y, int width, int height, ITextComponent text, Consumer<GuiButton> press) {
        return this.addWidget(new PregenButton(x, y, width, height, text, press));
    }

    public PregenButton button(int x, int y, int width, int height, Align horizontal, Align vertical, ITextComponent text, Consumer<GuiButton> press) {
        return this.addWidget(new PregenButton(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, text, press));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, List<T> values, T initial, Function<T, ITextComponent> displayFunction, Consumer<CycleButton<T>> result) {
        return this.addWidget(new CycleButton<T>(x, y, width, height, values, initial, displayFunction, result));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, Align horizontal, Align vertical, List<T> values, T initial, Function<T, ITextComponent> displayFunction, Consumer<CycleButton<T>> result) {
        return this.addWidget(new CycleButton<T>(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, values, initial, displayFunction, result));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, CycleButton.CycleState<T> state, Consumer<CycleButton<T>> result) {
        return this.addWidget(new CycleButton<T>(x, y, width, height, state, result));
    }

    public <T> CycleButton<T> cycleButton(int x, int y, int width, int height, Align horizontal, Align vertical, CycleButton.CycleState<T> state, Consumer<CycleButton<T>> result) {
        return this.addWidget(new CycleButton<T>(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state, result));
    }

    public <T extends PregenTreeList.TreeEntry<T>> PregenTreeList<T> tree(int width, int height, int startY, int endY, PregenTreeList.TreeState<T> state) {
        return this.addWidget(new PregenTreeList<T>(width, height, startY, endY, state));
    }

    public <T extends PregenTreeList.TreeEntry<T>> PregenTreeList<T> tree(PregenTreeList.TreeState<T> state) {
        return this.addWidget(new PregenTreeList<T>(this, state));
    }

    public <T extends PregenList.ListEntry<T>> PregenList<T> list(int width, int height, int startY, int endY, PregenList.ListState<T> state) {
        return this.addWidget(new PregenList<T>(width, height, startY, endY, state));
    }

    public <T extends PregenList.ListEntry<T>> PregenList<T> list(PregenList.ListState<T> state) {
        return this.addWidget(new PregenList<T>(this, state));
    }

    public PregenCheckBox checkbox(int x, int y, int width, int height, PregenCheckBox.CheckboxState state) {
        return this.addWidget(new PregenCheckBox(x, y, width, height, state));
    }

    public PregenCheckBox checkbox(int x, int y, int width, int height, Align horizontal, Align vertical, PregenCheckBox.CheckboxState state) {
        return this.addWidget(new PregenCheckBox(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state));
    }

    public PregenText text(int x, int y, int width, int height, PregenText.TextState state) {
        return this.addWidget(new PregenText(this.field_146289_q, x, y, width, height, state));
    }

    public PregenText text(int x, int y, int width, int height, Align horizontal, Align vertical, PregenText.TextState state) {
        return this.addWidget(new PregenText(this.field_146289_q, this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state));
    }

    public PregenSlider slider(int x, int y, int width, int height, PregenSlider.SliderState state) {
        return this.addWidget(new PregenSlider(x, y, width, height, state));
    }

    public PregenSlider slider(int x, int y, int width, int height, Align horizontal, Align vertical, PregenSlider.SliderState state) {
        return this.addWidget(new PregenSlider(this.getAlignedX(horizontal) + x, this.getAlignedY(vertical) + y, width, height, state));
    }

    public GuiScreen createChoice(ITextComponent mainline, ITextComponent description, GuiYesNoCallback result) {
        return new GuiYesNo(result, mainline.func_150254_d(), description.func_150254_d(), 0);
    }

    public GuiScreen createChoice(ITextComponent mainline, ITextComponent description, ITextComponent yesButton, ITextComponent noButton, GuiYesNoCallback result) {
        return new GuiYesNo(result, mainline.func_150254_d(), description.func_150254_d(), yesButton.func_150254_d(), noButton.func_150254_d(), 0);
    }

    protected <T> Consumer<T> emptyAction() {
        return T -> {};
    }

    protected List<Integer> dimensions() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.addAll(Arrays.asList(DimensionManager.getStaticDimensionIDs()));
        return list;
    }

    protected int defaultDimension() {
        return Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
    }

    protected void displayGuiScreen(GuiScreen screen) {
        Minecraft.func_71410_x().func_147108_a(screen);
    }

    protected GameSettings getSettings() {
        return Minecraft.func_71410_x().field_71474_y;
    }

    protected int getAlignedX(Align align) {
        switch (align) {
            case CENTER: {
                return this.centerX;
            }
            case END: {
                return this.field_146294_l;
            }
            case START: {
                return 0;
            }
        }
        return 0;
    }

    protected int getAlignedY(Align align) {
        switch (align) {
            case CENTER: {
                return this.centerY;
            }
            case END: {
                return this.field_146295_m;
            }
            case START: {
                return 0;
            }
        }
        return 0;
    }

    public void drawText(ITextComponent component, float x, float y, Align align, int color) {
        String text = component.func_150254_d();
        float offset = align.align(this.field_146289_q.func_78256_a(text));
        this.field_146289_q.func_175065_a(text, (float)this.centerX + x + offset, (float)this.centerY + y, color, false);
    }

    public void drawSplitText(ITextComponent component, float x, float y, Align align, int color, int maxLength) {
        for (String line : this.field_146289_q.func_78271_c(component.func_150254_d(), maxLength)) {
            float offset = align.align(this.field_146289_q.func_78256_a(line));
            this.field_146289_q.func_175065_a(line, (float)this.centerX + x + offset, (float)this.centerY + y, color, false);
            y += (float)this.field_146289_q.field_78288_b;
        }
    }

    public void drawUnalignedText(ITextComponent component, float x, float y, Align align, int color) {
        String text = component.func_150254_d();
        float offset = align.align(this.field_146289_q.func_78256_a(text));
        this.field_146289_q.func_175065_a(text, x + offset, y, color, false);
    }

    public void drawScrollText(ITextComponent text, float x, float y, float width, float height, Align align, int color, int seed) {
        BasePregenScreen.drawScrollingString(this.field_146289_q, text.func_150254_d(), x + (float)this.centerX, y + (float)this.centerY, width, height, align, color, seed);
    }

    public void drawUnalignedScrollText(ITextComponent text, float x, float y, float width, float height, Align align, int color, int seed) {
        BasePregenScreen.drawScrollingString(this.field_146289_q, text.func_150254_d(), x, y, width, height, align, color, seed);
    }

    public static void drawScrollingString(FontRenderer fontRenderer, String text, float x, float y, float width, float height, Align align, int color, int seed) {
        int textWidth = fontRenderer.func_78256_a(text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(System.currentTimeMillis() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            BasePregenScreen.pushScissors((int)x, (int)y, (int)width, (int)height);
            fontRenderer.func_175065_a(text, x - align.align(width) + align.align(textWidth) + (float)BasePregenScreen.lerp(offset, 0.0, diff), y + height / 2.0f - (float)(fontRenderer.field_78288_b / 3), color, false);
            BasePregenScreen.popScissors();
            return;
        }
        float offset = align.align(textWidth);
        fontRenderer.func_175065_a(text, x - align.align(width) + offset, y + height / 2.0f - (float)(fontRenderer.field_78288_b / 3), color, false);
    }

    public static void drawScrollingShadowString(FontRenderer fontRenderer, String text, float x, float y, float width, float height, Align align, int color, int seed) {
        int textWidth = fontRenderer.func_78256_a(text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(System.currentTimeMillis() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            BasePregenScreen.pushScissors((int)x, (int)y, (int)width, (int)height);
            fontRenderer.func_175063_a(text, x - align.align(width) + align.align(textWidth) + (float)BasePregenScreen.lerp(offset, 0.0, diff), y + height / 2.0f - (float)(fontRenderer.field_78288_b / 3), color);
            BasePregenScreen.popScissors();
            return;
        }
        float offset = align.align(textWidth);
        fontRenderer.func_175063_a(text, x - align.align(width) + offset, y + height / 2.0f - (float)(fontRenderer.field_78288_b / 3), color);
    }

    private static double lerp(double value, double min, double max) {
        return min + value * (max - min);
    }

    public static void pushScissors(float x, float y, float width, float height) {
        BasePregenScreen.pushScissors(new Rect(x, y, width, height));
    }

    public static void pushScissors(Rect rect) {
        STACK.push(rect);
        BasePregenScreen.applyScissors(rect);
    }

    public static void popScissors() {
        BasePregenScreen.applyScissors(STACK.pop());
    }

    private static void applyScissors(Rect rect) {
        if (rect == null) {
            GL11.glDisable((int)3089);
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        int bottom = (int)rect.maxY;
        double scaledHeight = (double)mc.field_71440_d / res.func_78324_d();
        double scaledWidth = (double)mc.field_71443_c / res.func_78327_c();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)rect.getX() * scaledWidth)), (int)((int)((double)mc.field_71440_d - (double)bottom * scaledHeight)), (int)((int)((double)rect.getWidth() * scaledWidth)), (int)((int)((double)rect.getHeigth() * scaledHeight)));
    }

    public static void renderEntityInGui(Entity entity, int xPos, int yPos, float scale, float rotation) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(xPos + 8), (float)(yPos + 26), (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (rotation != 0.0f) {
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(rotation)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        RenderHelper.func_74520_c();
        if (!(entity instanceof EntityPlayer)) {
            entity.field_70125_A = 0.0f;
            entity.field_70127_C = 0.0f;
            entity.field_70177_z = 0.0f;
            entity.field_70126_B = 0.0f;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)entity;
                living.field_70760_ar = 0.0f;
                living.field_70761_aq = 0.0f;
                living.field_70759_as = 0.0f;
                living.field_70758_at = 0.0f;
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)((entity.func_184187_bx() == null ? 0.0f : (float)entity.func_70042_X()) + (entity instanceof EntityHanging ? 0.5f : 0.0f)), (float)0.0f);
        RenderManager dispatcher = Minecraft.func_71410_x().func_175598_ae();
        try {
            float value = 1.0f;
            float yOff = 0.5f;
            if (entity instanceof EntityItem) {
                EntityItem item = (EntityItem)entity;
                value = -((float)item.func_174872_o() + item.field_70290_d * 10.0f) - 25.0f;
                yOff = 0.25f;
            }
            dispatcher.func_178633_a(false);
            dispatcher.func_188391_a(entity, 0.0, (double)yOff, 0.0, 0.0f, value, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dispatcher.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public void renderTextureWithOffset(float x, float y, float width, float height) {
        this.renderTexture(x + (float)this.centerX, y + (float)this.centerY, width, height);
    }

    public void renderTexture(float x, float y, float width, float height, TextureAtlasSprite texture, BufferBuilder builder) {
        if (texture == null) {
            return;
        }
        builder.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a((double)texture.func_94209_e(), (double)texture.func_94210_h()).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)texture.func_94212_f(), (double)texture.func_94210_h()).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)texture.func_94212_f(), (double)texture.func_94206_g()).func_181675_d();
        builder.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a((double)texture.func_94209_e(), (double)texture.func_94206_g()).func_181675_d();
    }

    public static void drawTextureRegion(float x, float y, float texX, float texY, float width, float height, float texWidth, float texHeight, float textureWidth, float textureHeight) {
        float maxX = x + width;
        float maxY = y + height;
        float t_minX = texX / textureWidth;
        float t_minY = texY / textureHeight;
        float t_maxX = (texX + texWidth) / textureWidth;
        float t_maxY = (texY + texHeight) / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)maxY, 0.0).func_187315_a((double)t_minX, (double)t_maxY).func_181675_d();
        bufferbuilder.func_181662_b((double)maxX, (double)maxY, 0.0).func_187315_a((double)t_maxX, (double)t_maxY).func_181675_d();
        bufferbuilder.func_181662_b((double)maxX, (double)y, 0.0).func_187315_a((double)t_maxX, (double)t_minY).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)t_minX, (double)t_minY).func_181675_d();
        tessellator.func_78381_a();
    }

    public void renderTexture(float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawFrame(float minX, float minY, float maxX, float maxY, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        BasePregenScreen.drawQuadArea(minX, minY, maxX, minY + 1.0f, bufferbuilder, color);
        BasePregenScreen.drawQuadArea(minX, maxY, maxX, maxY + 1.0f, bufferbuilder, color);
        BasePregenScreen.drawQuadArea(minX, minY, minX + 1.0f, maxY, bufferbuilder, color);
        BasePregenScreen.drawQuadArea(maxX, minY, maxX + 1.0f, maxY, bufferbuilder, color);
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public void drawSimpleRect(int minX, int minY, int maxX, int maxY, int color, boolean drop) {
        if (drop) {
            Gui.func_73734_a((int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-13158601);
            Gui.func_73734_a((int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-1);
        } else {
            Gui.func_73734_a((int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-13158601);
            Gui.func_73734_a((int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-1);
        }
        Gui.func_73734_a((int)minX, (int)minY, (int)maxX, (int)maxY, (int)color);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawRectangle(int xSize, int ySize, int xOffset, int yOffset, int color, boolean drop) {
        int minX = this.centerX - xSize + xOffset;
        int minY = this.centerY - ySize + yOffset;
        int maxX = this.centerX + xSize + xOffset;
        int maxY = this.centerY + ySize + yOffset;
        if (drop) {
            Gui.func_73734_a((int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-13158601);
            Gui.func_73734_a((int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-1);
        } else {
            Gui.func_73734_a((int)minX, (int)minY, (int)(maxX + 1), (int)(maxY + 1), (int)-13158601);
            Gui.func_73734_a((int)(minX - 1), (int)(minY - 1), (int)maxX, (int)maxY, (int)-1);
        }
        Gui.func_73734_a((int)minX, (int)minY, (int)maxX, (int)maxY, (int)color);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean isInsideBox(int mouseX, int mouseY, int minX, int minY, int maxX, int maxY) {
        return mouseX >= this.centerX + minX && mouseX < this.centerX + maxX && mouseY >= this.centerY + minY && mouseY <= this.centerY + maxY;
    }

    public void drawColorRegion(float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)minX, (double)maxY, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_181662_b((double)maxX, (double)maxY, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_181662_b((double)maxX, (double)minY, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_181662_b((double)minX, (double)minY, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawQuadArea(float left, float top, float right, float bottom, BufferBuilder builder, int color) {
        if (left < right) {
            float i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            float j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        builder.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        builder.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        builder.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        builder.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
    }

    public static void drawTextureWithBorder(ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
        BasePregenScreen.drawTexture(x, y, u, v, width, height, textureWidth, textureHeight, topBorder, bottomBorder, leftBorder, rightBorder, zLevel);
    }

    private static void drawTexture(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        BasePregenScreen.drawTextured(x, y, u, v, leftBorder, topBorder, zLevel, builder);
        BasePregenScreen.drawTextured(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel, builder);
        BasePregenScreen.drawTextured(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel, builder);
        BasePregenScreen.drawTextured(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel, builder);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            BasePregenScreen.drawTextured(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel, builder);
            BasePregenScreen.drawTextured(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel, builder);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                BasePregenScreen.drawTextured(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel, builder);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            BasePregenScreen.drawTextured(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel, builder);
            BasePregenScreen.drawTextured(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel, builder);
        }
        tessellator.func_78381_a();
    }

    private static void drawTextured(int x, int y, int u, int v, int width, int height, float zLevel, BufferBuilder builder) {
        builder.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a((double)((float)u * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(u + width) * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a((double)((float)(u + width) * 0.00390625f), (double)((float)v * 0.00390625f)).func_181675_d();
        builder.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a((double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f)).func_181675_d();
    }

    public void sendToServer(IPregenPacket packet) {
        ChunkPregenerator.NETWORKING.sendToServer(packet);
    }

    private /* synthetic */ void lambda$renderTooltips$1(List tooltips, int mouseX, ITextComponent T) {
        tooltips.addAll(this.field_146289_q.func_78271_c(T.func_150254_d(), Math.max(mouseX, this.field_146294_l - mouseX) - 20));
    }

    private /* synthetic */ void lambda$renderTooltips$0(List tooltips, int mouseX, ITextComponent T) {
        tooltips.addAll(this.field_146289_q.func_78271_c(T.func_150254_d(), Math.max(mouseX, this.field_146294_l - mouseX) - 20));
    }

    public static class ScissorsStack {
        Deque<Rect> stack = new ArrayDeque<Rect>();

        public void push(Rect owner) {
            if (this.stack.isEmpty()) {
                this.stack.push(owner);
                return;
            }
            owner.limit(this.stack.peek());
            this.stack.push(owner);
        }

        public Rect pop() {
            this.stack.pop();
            return this.stack.peek();
        }
    }

    public static class Rect {
        float minX;
        float minY;
        float maxX;
        float maxY;

        public Rect(float x, float y, float width, float heigth) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + width;
            this.maxY = y + heigth;
        }

        public void limit(Rect rect) {
            this.minX = Math.max(0.0f, Math.max(rect.minX, this.minX));
            this.minY = Math.max(0.0f, Math.max(rect.minY, this.minY));
            this.maxX = Math.max(this.minX, Math.min(rect.maxX, this.maxX));
            this.maxY = Math.max(this.minY, Math.min(rect.maxY, this.maxY));
        }

        public float getX() {
            return this.minX;
        }

        public float getY() {
            return this.minY;
        }

        public float getWidth() {
            return this.maxX - this.minX;
        }

        public float getHeigth() {
            return this.maxY - this.minY;
        }
    }

    public static interface ITooltipProvider {
        public void provideTooltips(Consumer<ITextComponent> var1);
    }
}

