/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.gui.comp;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.MathHelper;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.base.AbstractScrollList;
import pregenerator.base.impl.gui.base.IInteractable;

public class DynamicPregenList<E extends DynamicEntry<E>>
extends AbstractScrollList<E> {
    protected boolean scrolling;
    protected boolean renderSelection = true;
    protected E hovered;

    public DynamicPregenList(int width, int height, int startY, int endY, int itemHeight) {
        super(width, height, startY, endY, itemHeight);
    }

    protected E getEntryAtPos(double mouseX, double mouseY) {
        int index;
        int height;
        int centerWidth = this.getRowWidth() / 2;
        int centerX = this.x0 + this.width / 2;
        int minX = centerX - centerWidth;
        int maxX = centerX + centerWidth;
        int position = MathHelper.func_76128_c((double)(mouseY - (double)this.y0)) - this.headerHeight + (int)this.getScrollAmount() - 4;
        for (index = 0; index < this.children().size() && (height = ((DynamicEntry)this.children().get(index)).getItemHeight()) <= position; position -= height, ++index) {
        }
        return (E)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && index >= 0 && position >= 0 && index < this.getItemCount() ? (DynamicEntry)this.children().get(index) : null);
    }

    @Override
    protected int getMaxPosition() {
        int max = 0;
        int m = this.getItemCount();
        for (int i = 0; i < m; ++i) {
            max += ((DynamicEntry)this.children().get(i)).getItemHeight();
        }
        return max;
    }

    protected void scroll(int value) {
        this.setScrollAmount(this.getScrollAmount() + (double)value);
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    @Override
    protected void centerScrollOn(E element) {
        int index = this.children().indexOf(element);
        if (index <= 0) {
            this.setScrollAmount(0.0);
            return;
        }
        int value = 0;
        for (int i = 0; i < index; ++i) {
            value += ((DynamicEntry)this.children().get(i)).getItemHeight();
        }
        this.setScrollAmount((value += ((DynamicEntry)this.children().get(index)).getItemHeight() / 2) - (this.y1 - this.y0) / 2);
    }

    @Override
    protected void ensureVisible(E element) {
        int k;
        int itemHeight;
        int index = this.children().indexOf(element);
        int minY = this.getRowTop(index);
        int maxY = minY - this.y0 - 4 - (itemHeight = index < 0 ? this.itemHeight : ((DynamicEntry)this.children().get(index)).getItemHeight());
        if (maxY < 0) {
            this.scroll(maxY);
        }
        if ((k = this.y1 - minY - itemHeight - itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    @Override
    protected int getRowTop(int p_93512_) {
        int max = this.y0 + 4 - (int)this.getScrollAmount();
        int m = this.getItemCount();
        for (int i = 0; i < m; ++i) {
            max += ((DynamicEntry)this.children().get(i)).getItemHeight();
        }
        return max + this.headerHeight;
    }

    @Override
    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        super.updateScrollingState(mouseX, mouseY, button);
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        E element = this.getEntryAtPos(mouseX, mouseY);
        if (element != null) {
            if (element.mouseClick(mouseX, mouseY, button)) {
                this.setFocused((IInteractable)element);
                this.setDragging(true);
                return true;
            }
        } else if (button == 0) {
            return true;
        }
        return this.scrolling;
    }

    @Override
    public boolean mouseRelease(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.mouseRelease(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scroll) {
        this.scrolling = false;
        this.setScrollAmount(this.getScrollAmount() - scroll * (double)this.itemHeight * 2.0);
        return true;
    }

    public boolean isScrolling() {
        return this.scrolling;
    }

    @Override
    protected E getHovered() {
        return this.hovered;
    }

    @Override
    protected void renderList(int mouseX, int mouseY, float partialTicks) {
        this.hovered = this.isMouseOver(mouseX, mouseY) ? this.getEntryAtPos(mouseX, mouseY) : null;
        int minX = this.getRowLeft();
        int width = this.getRowWidth();
        int size = this.getItemCount();
        int yOff = this.y0 + 4 - (int)this.getScrollAmount() + this.headerHeight;
        int yOffset = 0;
        boolean hasRendered = false;
        BasePregenScreen.pushScissors(new BasePregenScreen.Rect(minX, this.y0 + this.headerHeight, width, this.y1 - this.y0));
        for (int i = 0; i < size; ++i) {
            int minY = yOffset + yOff;
            DynamicEntry entry = (DynamicEntry)this.getEntry(i);
            int height = entry.getItemHeight();
            int maxY = minY + height;
            if (maxY >= this.y0 && minY <= this.y1) {
                hasRendered = true;
                this.renderItem(mouseX, mouseY, partialTicks, i, minX, minY, width, height - 4);
            } else if (hasRendered) break;
            yOffset += height;
        }
        BasePregenScreen.popScissors();
    }

    @Override
    protected void renderItem(int mouseX, int mouseY, float particalTicks, int index, int left, int top, int width, int height) {
        DynamicEntry e = (DynamicEntry)this.getEntry(index);
        if (this.renderSelection && this.isSelectedItem(index)) {
            int color = this.isFocused() ? -1 : -8355712;
            this.renderSelection(left, top, width, height, color, -16777216);
        }
        e.render(index, top, left, width, height, mouseX, mouseY, Objects.equals(this.getHovered(), e), particalTicks);
    }

    protected void renderSelection(int left, int top, int width, int height, int frameColor, int backgroundColor) {
        Gui.func_73734_a((int)left, (int)(top - 2), (int)(left + width), (int)(top + height + 2), (int)frameColor);
        Gui.func_73734_a((int)(left + 1), (int)(top - 1), (int)(left + width - 1), (int)(top + height + 1), (int)backgroundColor);
    }

    @Override
    protected void replaceEntries(Collection<E> elements) {
        elements.forEach(this::bindToSelf);
        super.replaceEntries(elements);
    }

    protected void addEntries(List<E> elements) {
        elements.forEach(this::addEntry);
    }

    protected void addEntries(int index, List<E> elements) {
        elements.forEach(this::bindToSelf);
        this.children().addAll(index, elements);
    }

    protected void addEntry(int index, E element) {
        this.bindToSelf(element);
        this.children().add(index, element);
    }

    @Override
    protected int addEntry(E element) {
        this.bindToSelf(element);
        return super.addEntry(element);
    }

    protected void bindToSelf(E element) {
        ((DynamicEntry)element).itemheight = this.itemHeight;
        ((DynamicEntry)element).owner = this;
    }

    public static abstract class DynamicEntry<E extends DynamicEntry<E>>
    extends AbstractScrollList.ContainerEntry<E> {
        int itemheight;
        DynamicPregenList<E> owner;
        protected FontRenderer fontRenderer;

        public DynamicEntry() {
            this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        }

        protected boolean isVisible(int mouseX, int mouseY) {
            return ((DynamicPregenList)this.owner).y0 <= mouseY && ((DynamicPregenList)this.owner).y1 >= mouseY;
        }

        public int getItemHeight() {
            return this.itemheight;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
        }
    }
}

