/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.gui.comp;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.comp.PregenButton;

public class PregenSlider
extends PregenButton {
    SliderState state;

    public PregenSlider(int xPos, int yPos, int width, int height, SliderState state) {
        super(xPos, yPos, width, height, state.getCurrentDisplayText(), null);
        state.owner = this;
        this.state = state;
    }

    protected void onValueChanged() {
        if (this.state.listener != null) {
            this.state.listener.accept(this);
        }
    }

    public void updateMessage() {
        this.setDisplayText(this.state.getCurrentDisplayText());
    }

    public SliderState getState() {
        return this.state;
    }

    public int get() {
        return this.state.get();
    }

    public double getProgress() {
        return (double)(this.state.get() - this.state.getMin()) / (double)this.state.getRange();
    }

    protected void setFromMouse(double mouseX) {
        double progress = Math.max(0.0, Math.min(1.0, (mouseX - ((double)this.field_146128_h + 4.0)) / ((double)this.field_146120_f - 8.0)));
        this.state.set((int)((double)this.state.getMin() + (double)this.state.getRange() * progress));
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        this.setFromMouse(mouseX);
    }

    @Override
    public boolean mouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.setFromMouse(mouseX);
        return super.mouseDrag(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scroll) {
        if (this.state.stepSize != 0 && this.field_146124_l && this.field_146125_m) {
            this.state.set(this.get() + (int)((double)this.state.stepSize * scroll * (double)(GuiScreen.func_146272_n() ? 10 : 1) * (double)(GuiScreen.func_146272_n() ? 100 : 1)));
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char character, int keyCode) {
        if (this.state.stepSize != 0 && this.field_146124_l && this.field_146125_m && (keyCode == 203 || keyCode == 205)) {
            this.state.set(this.get() + this.state.stepSize * ((keyCode == 203 ? -1 : 0) + (keyCode == 205 ? 1 : 0)) * (GuiScreen.func_146272_n() ? 10 : 1) * (GuiScreen.func_146272_n() ? 100 : 1));
            return true;
        }
        return false;
    }

    protected int func_146114_a(boolean hovered) {
        return 0;
    }

    @Override
    public void render(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        super.render(mc, mouseX, mouseY, partialTicks);
        if (!this.field_146125_m) {
            return;
        }
        this.field_146123_n = this.func_146116_c(mc, mouseX, mouseY);
        mc.func_110434_K().func_110577_a(field_146122_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.isHovered() ? 2 : 1) * 20;
        double range = this.getProgress();
        BasePregenScreen.drawTextureWithBorder(field_146122_a, this.field_146128_h + (int)(range * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 46 + i, 8, this.field_146121_g, 200, 20, 2, 3, 2, 2, this.field_73735_i);
    }

    public static class SliderState {
        int minValue;
        int maxValue;
        int value;
        int stepSize = 1;
        IntFunction<ITextComponent> displayText = T -> TextUtil.literal(BasePregenScreen.NUMBERS.format(T));
        ITextComponent prefix = TextUtil.empty();
        ITextComponent suffix = TextUtil.empty();
        Consumer<PregenSlider> listener;
        PregenSlider owner;

        public SliderState(int value, int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
        }

        public SliderState(int value, int minValue, int maxValue, IntFunction<ITextComponent> displayText) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
            this.displayText = Objects.requireNonNull(displayText);
        }

        public SliderState(int value, int minValue, int maxValue, ITextComponent prefix, ITextComponent suffix) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
            this.prefix = Objects.requireNonNull(prefix);
            this.suffix = Objects.requireNonNull(suffix);
        }

        public SliderState(int value, int minValue, int maxValue, IntFunction<ITextComponent> displayText, ITextComponent prefix, ITextComponent suffix) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.value = value;
            this.displayText = Objects.requireNonNull(displayText);
            this.prefix = Objects.requireNonNull(prefix);
            this.suffix = Objects.requireNonNull(suffix);
        }

        public SliderState setListener(Consumer<PregenSlider> listener) {
            this.listener = listener;
            return this;
        }

        public SliderState setStepSize(int value) {
            this.stepSize = value;
            return this;
        }

        public SliderState setMaxValue(int maxValue) {
            if (maxValue < this.minValue) {
                return this;
            }
            this.maxValue = maxValue;
            int oldValue = this.value;
            this.value = Math.min(maxValue, this.value);
            if (this.owner != null) {
                if (oldValue != this.value) {
                    this.owner.onValueChanged();
                }
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState setMinValue(int minValue) {
            if (this.maxValue < minValue) {
                return this;
            }
            this.minValue = minValue;
            int oldValue = this.value;
            this.value = Math.max(minValue, this.value);
            if (this.owner != null) {
                if (oldValue != this.value) {
                    this.owner.onValueChanged();
                }
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState set(int value) {
            int newValue = Math.max(this.minValue, Math.min(this.maxValue, value));
            if (this.value != newValue) {
                this.value = newValue;
                if (this.owner != null) {
                    this.owner.onValueChanged();
                }
            }
            if (this.owner != null) {
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState increaseOnce() {
            return this.set(this.value + 1);
        }

        public SliderState decreaseOnce() {
            return this.set(this.value - 1);
        }

        public SliderState setPrefix(ITextComponent prefix) {
            this.prefix = Objects.requireNonNull(prefix);
            if (this.owner != null) {
                this.owner.updateMessage();
            }
            return this;
        }

        public SliderState setSuffix(ITextComponent suffix) {
            this.suffix = Objects.requireNonNull(suffix);
            if (this.owner != null) {
                this.owner.updateMessage();
            }
            return this;
        }

        public ITextComponent getCurrentDisplayText() {
            return TextUtil.empty().func_150257_a(this.prefix).func_150257_a(this.displayText.apply(this.value)).func_150257_a(this.suffix);
        }

        public int getMin() {
            return this.minValue;
        }

        public int getMax() {
            return this.maxValue;
        }

        public int getRange() {
            return this.maxValue - this.minValue;
        }

        public int get() {
            return this.value;
        }

        public PregenSlider getOwner() {
            return this.owner;
        }
    }
}

