/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import pregenerator.base.api.Align;
import pregenerator.base.api.misc.IRenderHelper;

@SideOnly(value=Side.CLIENT)
public class RenderManager
implements IRenderHelper {
    Minecraft mc;
    FontRenderer render;
    float width;

    @Override
    public void init() {
        this.mc = Minecraft.func_71410_x();
        this.render = this.mc.field_71466_p;
    }

    @Override
    public void setupCanvasSize(float width) {
        this.width = width;
    }

    @Override
    public void drawText(float x, float y, Align align, ITextComponent component) {
        float textScale = 0.5f;
        float invScale = 1.0f / textScale;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(x - align.align(this.width)), (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
        String text = component.func_150254_d();
        this.render.func_175063_a(text, align.align(this.render.func_78256_a(text)), y * invScale, 0xFFFFFF);
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawArea(float x, float y, float width, float height) {
        GL11.glPushMatrix();
        float minX = 4.0f + x;
        float maxX = minX + width;
        float minY = 4.0f + y;
        float maxY = minY + height;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.fillGradient(minX - 3.0f, minY - 4.0f, maxX + 3.0f, minY - 3.0f, -267386864, buffer);
        this.fillGradient(minX - 3.0f, maxY + 3.0f, maxX + 3.0f, maxY + 4.0f, -267386864, buffer);
        this.fillGradient(minX - 3.0f, minY - 3.0f, maxX + 3.0f, maxY + 3.0f, -267386864, buffer);
        this.fillGradient(minX - 4.0f, minY - 3.0f, minX - 3.0f, maxY + 3.0f, -267386864, buffer);
        this.fillGradient(maxX + 3.0f, minY - 3.0f, maxX + 4.0f, maxY + 3.0f, -267386864, buffer);
        this.fillGradient(minX - 3.0f, minY - 3.0f + 1.0f, minX - 3.0f + 1.0f, maxY + 3.0f - 1.0f, 0x505000FF, buffer);
        this.fillGradient(maxX + 2.0f, minY - 3.0f + 1.0f, maxX + 3.0f, maxY + 3.0f - 1.0f, 0x505000FF, buffer);
        this.fillGradient(minX - 3.0f, minY - 3.0f, maxX + 3.0f, minY - 3.0f + 1.0f, 0x505000FF, buffer);
        this.fillGradient(minX - 3.0f, maxY + 2.0f, maxX + 3.0f, maxY + 3.0f, 1344798847, buffer);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
    }

    protected void fillGradient(float left, float top, float right, float bottom, int color, BufferBuilder buffer) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        buffer.func_181662_b((double)right, (double)top, -10.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, -10.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, -10.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, -10.0).func_181666_a(r, g, b, a).func_181675_d();
    }

    @Override
    public void drawProgressBar(float x, float y, float width, float height, float progress, ITextComponent text) {
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        this.drawTexturedModalRect(x, y, 0.0f, 74.0f, width, 182.0f, 5.0f, 0);
        this.drawTexturedModalRect(x, y, 0.0f, 74.0f, width, 182.0f, 5.0f, 0);
        if (progress > 0.0f) {
            this.drawTexturedModalRect(x, y, 0.0f, 79.0f, width * progress, 182.0f * progress, 5.0f, 0);
        }
        this.drawText(x, y + 0.5f, Align.CENTER, text);
    }

    @Override
    public void drawTexture(float x, float y, float width, float height, float maxU, float maxV) {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder builder = tes.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        this.drawTexture(x, y, 0.0f, 0.0f, 256.0f * maxU, 256.0f * maxV, width, height, builder);
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        tes.func_78381_a();
        GlStateManager.func_179097_i();
    }

    public void drawTexture(float x, float y, float u, float v, float uWidth, float vHeight, float width, float height, BufferBuilder builder) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        builder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)(u * f), (double)((v + vHeight) * f1)).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((u + uWidth) * f), (double)((v + vHeight) * f1)).func_181675_d();
        builder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((u + uWidth) * f), (double)(v * f1)).func_181675_d();
        builder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
    }

    private void drawTexturedModalRect(float x, float y, float textureX, float textureY, float width, float texWidth, float height, int zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), (double)zLevel).func_187315_a((double)((textureX + 0.0f) * f), (double)((textureY + height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((textureX + texWidth) * f), (double)((textureY + height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((textureX + texWidth) * f), (double)((textureY + 0.0f) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((textureX + 0.0f) * f), (double)((textureY + 0.0f) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

