/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.comp.PregenCheckBox;
import pregenerator.base.impl.gui.comp.PregenTreeList;
import pregenerator.impl.network.DiskPacket;
import pregenerator.impl.tracking.DiskTracker;

public class DiskScreen
extends BasePregenScreen {
    GuiScreen parent;
    PregenTreeList.TreeState<DiskNode> elements = new PregenTreeList.TreeState(24).setRowWidth(320).setTopPadding(30);
    PregenCheckBox.CheckboxState showFrame = new PregenCheckBox.CheckboxState(true, false, TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_frame")).withStateListener(this.elements::setFrame);
    ITextComponent header = TextUtil.translate("gui.chunk_pregen.disk_screen.header");

    public DiskScreen(GuiScreen parent) {
        this.parent = parent;
        this.sendToServer(new DiskPacket.Request());
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.tree(this.elements);
        this.checkbox(70, -25, 14, 14, Align.CENTER, Align.END, this.showFrame);
        this.button(-60, -28, 120, 20, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.onClose());
    }

    @Override
    public void onClose() {
        this.displayGuiScreen(this.parent);
    }

    public void acceptData(DiskTracker.DiskEntry entry) {
        Comparator<DiskTracker.DiskEntry> result = Comparator.comparingLong(T -> T.getResult().getBytes());
        entry.sort(result.reversed());
        this.elements.replaceNodes(Collections.singletonList(new DiskNode(entry)));
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.drawText(TextUtil.translate("gui.chunk_pregen.disk_screen.header"), 0.0f, -this.centerY + 10, Align.CENTER, -1);
    }

    public class DiskNode
    extends PregenTreeList.TreeEntry<DiskNode> {
        DiskTracker.DiskEntry entry;
        ITextComponent files;
        ITextComponent size;
        ITextComponent progress;
        ITextComponent totalProgress;

        public DiskNode(DiskTracker.DiskEntry entry) {
            this.entry = entry;
            for (DiskTracker.DiskEntry child : entry.getChildren()) {
                this.addChildNode(new DiskNode(child));
            }
            this.files = TextUtil.translate("gui.chunk_pregen.disk_screen.files", entry.getFiles());
            this.size = TextUtil.literal(TextUtil.findBestMemory(entry.getResult().getBytes(), 5120));
            float progress = (float)entry.getPercentage() * 100.0f;
            this.progress = TextUtil.literal(this.getFormat(progress).format(progress) + "%");
            progress = (float)(entry.getTotalPercentage() * 100.0);
            this.totalProgress = TextUtil.translate("gui.chunk_pregen.disk_screen.overall", this.getFormat(progress).format(progress));
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return false;
        }

        private DecimalFormat getFormat(double value) {
            int result = (int)(value * 100.0);
            return result == 0 ? BasePregenScreen.FLOATING_NUMBERS_EXTENDED : BasePregenScreen.FLOATING_NUMBERS;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            DiskScreen.this.drawSimpleRect(left + width - 102, top + 1, left + width - 2, top + height - 1, -7631989, true);
            DiskScreen.this.drawUnalignedScrollText(this.entry.getName(), left + 20, top, width - 180, height, Align.START, -2105377, this.entry.hashCode());
            float progress = (float)(this.entry.getPercentage() * 100.0);
            DiskScreen.this.drawColorRegion(left + width - 102, top + 1, (float)(left + width - 102) + progress, top + height - 1, 0x5500FF00);
            float totalProgress = (float)(this.entry.getTotalPercentage() * 100.0);
            DiskScreen.this.drawColorRegion(left + width - 102, top + 1, (float)(left + width - 102) + totalProgress, top + height - 1, 0x550000FF);
            DiskScreen.this.drawUnalignedText(this.size, left + width - 102 - this.fontRenderer.func_78256_a(this.size.func_150254_d()) - 2, top + height / 2 - 8, Align.START, -2105377);
            DiskScreen.this.drawUnalignedText(this.files, left + width - 102 - this.fontRenderer.func_78256_a(this.files.func_150254_d()) - 2, top + height / 2 + 2, Align.START, -2105377);
            DiskScreen.this.drawUnalignedText(this.progress, left + width - 100, top + height / 2 - 8, Align.START, -2105377);
            DiskScreen.this.drawUnalignedText(this.totalProgress, left + width - 100, top + height / 2 + 1, Align.START, -2105377);
        }
    }
}

