/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.impl.client.gui.DimensionScreen;
import pregenerator.impl.client.helpers.IProgressListener;
import pregenerator.impl.network.ProgressPacket;

public class ProgressScreen
extends BasePregenScreen
implements IProgressListener {
    GuiScreen parent;
    ITextComponent header;
    long current = 0L;
    long max;
    UUID taskId;
    long lastPacket = System.currentTimeMillis();

    public ProgressScreen(GuiScreen parent, UUID taskId, long max, ITextComponent message) {
        this.parent = parent;
        this.taskId = taskId;
        this.max = max;
        this.header = message;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.button(-60, 25, 120, 18, Align.CENTER, Align.CENTER, TextUtil.literal("Cancel"), T -> this.sendToServer(new ProgressPacket.Cancel(this.taskId)));
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    protected boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(-1);
        this.drawRectangle(80, 7, 0, 0, -7631989, true);
        float progress = Math.max(Math.min((float)this.current / (float)this.max, 1.0f), 0.0f);
        this.drawColorRegion(this.centerX - 80, this.centerY - 7, (float)(this.centerX - 80) + progress * 160.0f, this.centerY + 7, Color.GREEN.darker().getRGB());
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.drawText(this.header, 0.0f, -25.0f, Align.CENTER, -1);
        this.drawText(TextUtil.literal(NUMBERS.format(this.current) + " / " + NUMBERS.format(this.max)), 0.0f, -4.0f, Align.CENTER, -1);
    }

    @Override
    public void onClose() {
        this.displayGuiScreen(this.parent);
        if (this.parent instanceof DimensionScreen) {
            ((DimensionScreen)this.parent).updateDimension();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (System.currentTimeMillis() - this.lastPacket > 100000L) {
            this.onClose();
        }
    }

    @Override
    public void updateProgress(long current, long max) {
        this.current = current;
        this.max = max;
        this.lastPacket = System.currentTimeMillis();
    }

    @Override
    public void onCompleted() {
        this.onClose();
    }
}

