/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui.chat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketTabComplete;
import net.minecraft.util.TabCompleter;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ClientCommandHandler;

public abstract class AdvancedTabCompleter
extends TabCompleter {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    protected Minecraft mc = Minecraft.func_71410_x();
    protected ClickBox box = new ClickBox(0, 0, -1, -1);
    protected int offset;
    protected boolean cycle = false;
    protected boolean keepSuggestions = false;
    protected boolean wasFirst = false;

    public AdvancedTabCompleter(GuiTextField textField, boolean hasTargetBlock) {
        super(textField, hasTargetBlock);
    }

    public boolean onKeyPress(int key) {
        if (this.hasSuggestions()) {
            if (key == 15) {
                this.func_186841_a();
                return true;
            }
            if (key == 200) {
                this.previous();
                return true;
            }
            if (key == 208) {
                this.next();
                return true;
            }
        }
        return false;
    }

    public boolean onClick(int mouseX, int mouseY) {
        if (this.box.isInsideBox(mouseX, mouseY)) {
            this.select(this.offset + (mouseY - this.box.getY()) / 12);
            return true;
        }
        return false;
    }

    public boolean onScroll(int mouseX, int mouseY, int scroll) {
        if (this.box.isInsideBox(mouseX, mouseY)) {
            this.offset += scroll;
            if (this.offset < 0) {
                this.offset = 0;
            } else if (this.offset + 10 > this.field_186849_f.size()) {
                this.offset = Math.max(0, this.field_186849_f.size() - 10);
            }
            return true;
        }
        return false;
    }

    public void render(int mouseX, int mouseY, FontRenderer font) {
        int limit = Math.min(this.field_186849_f.size() - this.offset, 10);
        if (limit > 0) {
            String s = this.field_186844_a.func_146179_b();
            int x = Math.min(s.length() <= 0 ? 0 : font.func_78256_a(s.substring(0, Math.max(0, this.field_186844_a.func_146179_b().lastIndexOf(" ")) + 1)), this.field_186844_a.func_146200_o()) + this.field_186844_a.field_146209_f - 0;
            int width = 0;
            int m = this.field_186849_f.size();
            for (int i = 0; i < m; ++i) {
                width = Math.max(width, font.func_78256_a((String)this.field_186849_f.get(i)));
            }
            int baseY = this.field_186844_a.field_146210_g - 12 * limit - 3;
            int index = mouseX >= x && mouseX <= x + width ? (mouseY - baseY) / 12 : -1;
            Gui.func_73734_a((int)x, (int)baseY, (int)(x + width + 5), (int)(this.field_186844_a.field_146210_g - 3), (int)-805306368);
            for (int i = 0; i < limit; ++i) {
                font.func_175063_a((String)this.field_186849_f.get(i + this.offset), (float)(x + 2), (float)(baseY + i * 12 + 2), i == index || i + this.offset == this.field_186848_e ? -256 : -5592406);
            }
            this.box.set(x, baseY, width, this.field_186844_a.field_146210_g - 3 - baseY);
        }
    }

    public int getWordIndex(String text) {
        if (text != null && text.length() > 0) {
            int i = 0;
            Matcher matcher = WHITESPACE_PATTERN.matcher(text);
            while (matcher.find()) {
                i = matcher.end();
            }
            return i;
        }
        return 0;
    }

    public boolean hasSuggestions() {
        return this.field_186849_f.size() > 0;
    }

    public void func_186841_a() {
        if (this.field_186849_f.isEmpty()) {
            return;
        }
        if (this.wasFirst) {
            this.select(this.field_186848_e);
            this.wasFirst = false;
            return;
        }
        if (GuiScreen.func_146272_n()) {
            this.previous();
        } else {
            this.next();
        }
    }

    public void previous() {
        this.select(this.field_186848_e == 0 ? this.field_186849_f.size() - 1 : this.field_186848_e - 1);
    }

    public void next() {
        this.select(++this.field_186848_e % this.field_186849_f.size());
    }

    public void select(int index) {
        if (index < 0 || index >= this.field_186849_f.size()) {
            return;
        }
        this.setSelection(index);
        this.updateWord((String)this.field_186849_f.get(this.field_186848_e));
    }

    protected void setSelection(int index) {
        this.field_186848_e = index;
        if (index - 9 >= this.offset) {
            this.offset = index - 9;
        } else if (index < this.offset) {
            this.offset = index;
        }
    }

    public void updateWord(String value) {
        this.field_186844_a.func_146175_b(0);
        int end = this.field_186844_a.func_146198_h();
        String text = this.field_186844_a.func_146179_b().substring(0, end);
        int start = this.getWordIndex(text);
        if (start == 0) {
            start = 1;
        }
        this.cycle = true;
        StringBuilder builder = new StringBuilder(this.field_186844_a.func_146179_b());
        builder.replace(start, end, value);
        value = builder.toString();
        this.keepSuggestions = true;
        this.field_186844_a.func_146180_a(TextFormatting.func_110646_a((String)value));
        this.field_186844_a.func_146190_e(start + value.length());
        this.keepSuggestions = false;
    }

    public void requestUpdate() {
        if (this.field_186844_a.func_146179_b().isEmpty() || this.field_186844_a.func_146198_h() == 0) {
            this.field_186848_e = 0;
            this.field_186849_f.clear();
            return;
        }
        String prefix = this.field_186844_a.func_146179_b().substring(0, this.field_186844_a.func_146198_h());
        if (prefix.isEmpty()) {
            prefix = "/";
        }
        ClientCommandHandler.instance.autoComplete(prefix);
        Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a((Packet)new CPacketTabComplete(prefix, this.func_186839_b(), this.field_186845_b));
        this.cycle = false;
    }

    public void func_186840_a(String ... newCompl) {
        int i;
        boolean allStart = true;
        int m = newCompl.length;
        for (i = 0; i < m; ++i) {
            if (newCompl[i].isEmpty() || newCompl[i].startsWith("/")) continue;
            allStart = false;
            break;
        }
        if (allStart) {
            m = newCompl.length;
            for (i = 0; i < m; ++i) {
                if (newCompl[i].isEmpty()) continue;
                newCompl[i] = newCompl[i].substring(1);
            }
        }
        this.wasFirst = !this.cycle || this.field_186849_f.isEmpty();
        this.field_186849_f.clear();
        this.field_186848_e = 0;
        String currentWord = "";
        if (!this.field_186844_a.func_146179_b().isEmpty()) {
            int end = this.field_186844_a.func_146198_h();
            currentWord = this.field_186844_a.func_146179_b().substring(0, end);
            int start = this.getWordIndex(currentWord);
            if (start == 0) {
                start = 1;
            }
            currentWord = currentWord.substring(start);
        }
        for (String value : newCompl) {
            if (value.isEmpty() || value.equals(currentWord)) continue;
            this.field_186849_f.add(value);
        }
        this.offset = 0;
    }

    public static class ClickBox {
        int x;
        int y;
        int width;
        int height;

        public ClickBox(int x, int y, int width, int height) {
            this.set(x, y, width, height);
        }

        public void set(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public boolean isInsideBox(int xPos, int yPos) {
            return xPos >= this.x && xPos <= this.x + this.width && yPos >= this.y && yPos <= this.y + this.height;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

