/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui.commands;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.mutable.MutableLong;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.gui.BasePregenScreen;
import pregenerator.base.impl.gui.comp.PregenButton;
import pregenerator.base.impl.gui.comp.PregenCheckBox;
import pregenerator.base.impl.gui.comp.PregenText;
import pregenerator.base.impl.gui.comp.PregenTreeList;
import pregenerator.impl.misc.Area;
import pregenerator.impl.misc.GenShape;
import pregenerator.impl.network.MemoryPacket;
import pregenerator.impl.network.TaskPacket;
import pregenerator.impl.processor.deleter.tasks.DeletionExcess;
import pregenerator.impl.processor.deleter.tasks.DeletionTimeout;
import pregenerator.impl.processor.deleter.tasks.IDeletionTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public class TaskScreen
extends BasePregenScreen
implements MemoryPacket.IMemoryReceiver,
TaskPacket.ISpeedReceiver {
    public static final ITextComponent[][] TYPES = new ITextComponent[][]{{TextUtil.translate("gui.chunk_pregen.task_screen.nodes.pause"), TextUtil.translate("gui.chunk_pregen.task_screen.nodes.resume")}, {TextUtil.translate("gui.chunk_pregen.task_screen.nodes.start"), TextUtil.translate("gui.chunk_pregen.task_screen.nodes.stop")}, {TextUtil.translate("gui.chunk_pregen.task_screen.nodes.delete")}};
    GuiScreen parent;
    PregenTreeList.TreeState<TaskNode> elements = new PregenTreeList.TreeState().setRowWidth(320).setTopPadding(43);
    PregenCheckBox.CheckboxState showFrame = new PregenCheckBox.CheckboxState(true, false, TextUtil.translate("gui.chunk_pregen.retrogen_selector.show_frame")).withStateListener(this.elements::setFrame);
    PregenText.TextState search = new PregenText.TextState("").setCallback(this.elements::search);
    Map<Integer, Float> speeds = new LinkedHashMap<Integer, Float>();
    UUID activeTask;
    boolean activePaused;
    Set<Integer> activeLevels = new ObjectOpenHashSet();
    Map<Integer, Long> usedMemory = new LinkedHashMap<Integer, Long>();
    long maxMemory = 1L;
    ITextComponent header = TextUtil.translate("gui.chunk_pregen.task_screen.header");

    public TaskScreen(GuiScreen parent) {
        this.parent = parent;
        this.elements.add(new TaskNode[]{new RootNode(TextUtil.translate("gui.chunk_pregen.task_screen.gen_tasks"), false)});
        this.elements.add(new TaskNode[]{new RootNode(TextUtil.translate("gui.chunk_pregen.task_screen.deletion_tasks"), true)});
        this.updateMemory();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.tree(this.elements);
        this.text(-96, 20, 188, 14, Align.CENTER, Align.START, this.search);
        this.checkbox(96, 20, 14, 14, Align.CENTER, Align.START, this.showFrame);
        this.button(-60, -28, 120, 20, Align.CENTER, Align.END, TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.onClose());
    }

    private void updateMemory() {
        this.sendToServer(new MemoryPacket.RequestFree());
        for (int key : this.dimensions()) {
            this.sendToServer(new MemoryPacket.RequestUsed(key));
        }
        this.sendToServer(new TaskPacket.RequestSpeeds());
        this.sendToServer(new TaskPacket.RequestTasks());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tick % 40 == 0) {
            this.updateMemory();
        }
    }

    @Override
    public void onClose() {
        this.displayGuiScreen(this.parent);
    }

    @Override
    public void receivedMemory(int dimension, long value, boolean free) {
        if (free) {
            this.maxMemory = value;
        } else {
            this.usedMemory.put(dimension, value);
        }
    }

    public void acceptTasks(List<ITask> tasks, List<IDeletionTask> deletionTasks, UUID activeTasks, boolean activePaused) {
        this.activeTask = activeTasks;
        this.activePaused = activePaused;
        TaskNode node = this.elements.getNodes().get(0);
        node.clear();
        for (ITask iTask : tasks) {
            node.addChildNode(new GenNode(iTask));
        }
        node = this.elements.getNodes().get(1);
        node.clear();
        for (IDeletionTask iDeletionTask : deletionTasks) {
            node.addChildNode(new DeletionNode(iDeletionTask));
        }
        this.elements.updateSearch();
    }

    @Override
    public void acceptSpeedData(Map<Integer, Float> speeds) {
        this.speeds.clear();
        this.speeds.putAll(speeds);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.drawText(this.header, 0.0f, -this.centerY + 5, Align.CENTER, -2105377);
    }

    public class DeletionNode
    extends TaskNode
    implements ITaskNode {
        IDeletionTask task;
        PregenButton[] actions;

        public DeletionNode(IDeletionTask task) {
            this.actions = new PregenButton[]{this.addChild(new PregenButton(0, 0, 60, 14, TYPES[0][0], this::pauseResume)), this.addChild(new PregenButton(0, 0, 60, 14, TYPES[1][1], this::startStop)).setTooltip(this::getFailure), this.addChild(new PregenButton(0, 0, 60, 14, TYPES[2][0], this::remove))};
            this.task = task;
        }

        private void startStop(GuiButton button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(this.task.getTaskId().equals(TaskScreen.this.activeTask) ? 2 : 3, this.task.getName()));
        }

        private void pauseResume(GuiButton button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(this.task.getTaskId().equals(TaskScreen.this.activeTask) && TaskScreen.this.activePaused ? 1 : 0, this.task.getName()));
        }

        private void remove(GuiButton button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(4, this.task.getName()));
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return this.task.getName().toLowerCase().startsWith(searchString) || this.searchIds(searchString, TextUtil.dimension(this.task.getDimension()).func_150254_d());
        }

        @Override
        public long getUsedMemory() {
            if (this.task instanceof DeletionExcess || this.task instanceof DeletionTimeout) {
                long chunks = GenShape.SQUARE.calculateRadius(this.task.getMaxRadius());
                return Math.max(0L, TaskScreen.this.usedMemory.getOrDefault(this.task.getDimension(), 0L) - TextUtil.getWorldSize(chunks, this.task.getDimension()));
            }
            return TextUtil.getWorldSize(this.task.getTaskSize(), this.task.getDimension());
        }

        @Override
        public int dimension() {
            return this.task.getDimension();
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            long chunks = this.task.getTaskSize();
            long used = TaskScreen.this.usedMemory.getOrDefault(this.task.getDimension(), 0L);
            long deletion = Math.min(this.getUsedMemory(), used);
            TaskScreen.this.drawSimpleRect(left + width - 97, top + 1, left + width - 2, top + 10, -7631989, true);
            float progress = Math.min((float)deletion / (float)used * 95.0f, 95.0f);
            TaskScreen.this.drawColorRegion(left + width - 97, top + 1, (float)(left + width - 97) + progress, top + 10, -12683373);
            int size = 95;
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.name", this.task.getName()), TextFormatting.RED), left + 2, top - 1, width - 102, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.dim", TextUtil.dimension(this.task.getDimension())), TextFormatting.GOLD), left + 2, top + 10, width - 102, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
            if (!(this.task instanceof DeletionExcess) && !(this.task instanceof DeletionTimeout)) {
                Area area = this.task.getArea();
                TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.from", BasePregenScreen.NUMBERS.format(area.getMinX()), BasePregenScreen.NUMBERS.format(area.getMinZ())), TextFormatting.DARK_AQUA), left + 2, top + 21, width - 102, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
                TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.to", BasePregenScreen.NUMBERS.format(area.getMaxX()), BasePregenScreen.NUMBERS.format(area.getMaxZ())), TextFormatting.DARK_AQUA), left + 2, top + 32, width - 102, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
            }
            TaskScreen.this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.task_screen.memory", TextUtil.findBestMemory(deletion), TextUtil.findBestMemory(used)), left + width - size - 2, top, size, 10.0f, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.chunks", BasePregenScreen.NUMBERS.format(chunks)), TextFormatting.BLUE), left + width - size - 2, top + 10, size, 12.0f, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(this.task.getShapeName().func_150259_f(), TextFormatting.GOLD), left + width - size - 2, top + 21, size, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
            if (this.task.getTaskId().equals(TaskScreen.this.activeTask)) {
                TaskScreen.this.drawUnalignedScrollText(TextUtil.translateStyled("gui.chunk_pregen.task_screen.nodes.active", TextFormatting.RED), left + width - size - 2, top + 30, size, 12.0f, Align.START, -2105377, this.task.hashCode());
                this.actions[0].field_146125_m = true;
                this.actions[0].setDisplayText(TYPES[0][TaskScreen.this.activePaused ? 1 : 0]);
                this.actions[1].setDisplayText(TYPES[1][1]);
                this.actions[1].field_146124_l = true;
            } else {
                this.actions[0].field_146125_m = false;
                this.actions[1].setDisplayText(TYPES[1][0]);
                this.actions[1].field_146124_l = !TaskScreen.this.activeLevels.contains(this.task.getDimension());
            }
            int offset = left + 1;
            for (PregenButton button : this.actions) {
                if (!button.field_146125_m) continue;
                button.field_146128_h = offset;
                button.field_146129_i = top + height - button.getWidgetHeight() + 1;
                button.render(this.mc, mouseX, mouseY, partialTicks);
                offset += 61;
            }
        }

        private ITextComponent getFailure(PregenButton button) {
            return button.field_146124_l ? null : TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.already_running", TextUtil.dimension(this.task.getDimension())), TextFormatting.RED);
        }

        @Override
        public int getItemHeight() {
            return 59;
        }
    }

    public class GenNode
    extends TaskNode
    implements ITaskNode {
        ITask task;
        PregenButton[] actions;

        public GenNode(ITask task) {
            this.actions = new PregenButton[]{this.addChild(new PregenButton(0, 0, 60, 14, TYPES[0][0], this::pauseResume)), this.addChild(new PregenButton(0, 0, 60, 14, TYPES[1][1], this::startStop)).setTooltip(this::getFailure), this.addChild(new PregenButton(0, 0, 60, 14, TYPES[2][0], this::remove))};
            this.task = task;
        }

        private void startStop(GuiButton button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(this.task.getTaskId().equals(TaskScreen.this.activeTask) ? 2 : 3, this.task.getName()));
        }

        private void pauseResume(GuiButton button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(this.task.getTaskId().equals(TaskScreen.this.activeTask) && TaskScreen.this.activePaused ? 1 : 0, this.task.getName()));
        }

        private void remove(GuiButton button) {
            TaskScreen.this.sendToServer(new TaskPacket.Action(4, this.task.getName()));
        }

        @Override
        protected boolean containsSearch(String searchString) {
            return this.task.getName().toLowerCase().startsWith(searchString) || this.searchIds(searchString, TextUtil.dimension(this.task.getDimension()).func_150254_d());
        }

        @Override
        public int dimension() {
            return this.task.getDimension();
        }

        @Override
        public long getUsedMemory() {
            return TextUtil.getWorldSize(this.task.getTaskSize(), this.task.getDimension());
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            long chunks = this.task.getTaskSize();
            long usage = TextUtil.getWorldSize(chunks, this.task.getDimension());
            float speed = TaskScreen.this.speeds.getOrDefault(this.task.getDimension(), Float.valueOf(1.0f)).floatValue();
            long time = (long)((float)chunks / speed * 50.0f);
            TaskScreen.this.drawSimpleRect(left + width - 97, top + 1, left + width - 2, top + 10, -7631989, true);
            float progress = (float)usage / (float)TaskScreen.this.maxMemory * 95.0f;
            TaskScreen.this.drawColorRegion(left + width - 97, top + 1, (float)(left + width - 97) + progress, top + 10, -12683373);
            int size = 95;
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.name", this.task.getName()), TextFormatting.RED), left + 2, top - 1, width - 102, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.dim", TextUtil.dimension(this.task.getDimension())), TextFormatting.GOLD), left + 2, top + 10, width - 102, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
            Area area = this.task.getArea();
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.from", BasePregenScreen.NUMBERS.format(area.getMinX()), BasePregenScreen.NUMBERS.format(area.getMinZ())), TextFormatting.DARK_AQUA), left + 2, top + 21, width - 102, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.to", BasePregenScreen.NUMBERS.format(area.getMaxX()), BasePregenScreen.NUMBERS.format(area.getMaxZ())), TextFormatting.DARK_AQUA), left + 2, top + 32, width - 102, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.eta", TextUtil.getTime(time), BasePregenScreen.FLOATING_NUMBERS.format(speed)), TextFormatting.DARK_GREEN), left + 2, top + 43, width - 102, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(TextUtil.translate("gui.chunk_pregen.task_screen.memory", TextUtil.findBestMemory(usage), TextUtil.findBestMemory(TaskScreen.this.maxMemory)), left + width - size - 2, top, size, 10.0f, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.chunks", BasePregenScreen.NUMBERS.format(chunks)), TextFormatting.BLUE), left + width - size - 2, top + 10, size, 12.0f, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(this.task.getShapeName().func_150259_f(), TextFormatting.GOLD), left + width - size - 2, top + 21, size, this.fontRenderer.field_78288_b, Align.START, -2105377, this.task.hashCode());
            TaskScreen.this.drawUnalignedScrollText(TextUtil.applyTextStyle(this.task.getType().createText().func_150259_f(), TextFormatting.DARK_AQUA), left + width - size - 2, top + 30, size, 12.0f, Align.START, -2105377, this.task.hashCode());
            if (this.task.getTaskId().equals(TaskScreen.this.activeTask)) {
                TaskScreen.this.drawUnalignedScrollText(TextUtil.translateStyled("gui.chunk_pregen.task_screen.nodes.active", TextFormatting.RED), left + width - size - 2, top + 40, size, 12.0f, Align.START, -2105377, this.task.hashCode());
                this.actions[0].field_146125_m = true;
                this.actions[0].setDisplayText(TYPES[0][TaskScreen.this.activePaused ? 1 : 0]);
                this.actions[1].setDisplayText(TYPES[1][1]);
                this.actions[1].field_146124_l = true;
            } else {
                this.actions[0].field_146125_m = false;
                this.actions[1].setDisplayText(TYPES[1][0]);
                this.actions[1].field_146124_l = !TaskScreen.this.activeLevels.contains(this.task.getDimension());
            }
            int offset = left + 1;
            for (PregenButton button : this.actions) {
                if (!button.field_146125_m) continue;
                button.field_146128_h = offset;
                button.field_146129_i = top + height - button.getWidgetHeight() + 1;
                button.render(this.mc, mouseX, mouseY, partialTicks);
                offset += 61;
            }
        }

        private ITextComponent getFailure(PregenButton button) {
            return button.field_146124_l ? null : TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.task_screen.nodes.already_running", TextUtil.dimension(this.task.getDimension())), TextFormatting.RED);
        }

        @Override
        public int getItemHeight() {
            return 70;
        }
    }

    public static interface ITaskNode {
        public long getUsedMemory();

        public int dimension();
    }

    public class RootNode
    extends TaskNode {
        ITextComponent text;
        boolean delete;

        public RootNode(ITextComponent text, boolean delete) {
            this.text = text;
            this.delete = delete;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
            long current = this.getCurrent();
            long max = this.getMax();
            float progress = Math.max((float)current / (float)max * 95.0f, 0.0f);
            TaskScreen.this.drawSimpleRect(left + width - 97, top + 1, left + width - 2, top + 10, -7631989, true);
            TaskScreen.this.drawColorRegion(left + width - 97, top + 1, (float)(left + width - 97) + progress, top + 10, -12683373);
            TaskScreen.this.drawUnalignedText(this.text, left + 20, top + height / 2 - this.fontRenderer.field_78288_b / 2, Align.START, -1);
            ITextComponent memory = TextUtil.translate("gui.chunk_pregen.task_screen.memory", TextUtil.findBestMemory(current), TextUtil.findBestMemory(max));
            TaskScreen.this.drawUnalignedScrollText(memory, left + width - 97, top, 95.0f, 10.0f, Align.START, -2105377, this.hashCode());
            TaskScreen.this.drawUnalignedText(TextUtil.translate("gui.chunk_pregen.task_screen.tasks", this.childNodes().size()), left + width - 96, top + 13, Align.START, -2105377);
        }

        public long getMax() {
            if (this.delete) {
                long total = 0L;
                Iterator<Long> iter = TaskScreen.this.usedMemory.values().iterator();
                while (iter.hasNext()) {
                    total += iter.next().longValue();
                }
                return total;
            }
            return TaskScreen.this.maxMemory;
        }

        public long getCurrent() {
            if (this.delete) {
                LinkedHashMap<Integer, MutableLong> dimensions = new LinkedHashMap<Integer, MutableLong>();
                for (TaskNode child : this.childNodes()) {
                    if (!(child instanceof ITaskNode)) continue;
                    ITaskNode node = (ITaskNode)((Object)child);
                    dimensions.computeIfAbsent(node.dimension(), T -> new MutableLong()).add(node.getUsedMemory());
                }
                long total = 0L;
                for (Map.Entry entry : TaskScreen.this.usedMemory.entrySet()) {
                    total += Math.min((Long)entry.getValue(), dimensions.getOrDefault(entry.getKey(), new MutableLong()).longValue());
                }
                return total;
            }
            long total = 0L;
            for (TaskNode child : this.childNodes()) {
                if (!(child instanceof ITaskNode)) continue;
                total += ((ITaskNode)((Object)child)).getUsedMemory();
            }
            return total;
        }

        @Override
        public int getItemHeight() {
            return 25;
        }
    }

    public class TaskNode
    extends PregenTreeList.TreeEntry<TaskNode> {
        @Override
        protected boolean containsSearch(String searchString) {
            return false;
        }

        public void clear() {
            this.childNodes().clear();
        }
    }
}

