/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.world.chunk.Chunk;
import pregenerator.impl.client.preview.world.data.ChunkData;
import pregenerator.impl.client.preview.world.data.IChunkData;

public interface IFileProvider {
    public boolean hasIndex(int var1, int var2);

    public long getIndex(int var1, int var2, FileType var3);

    public long getOrCreateIndex(int var1, int var2, FileType var3);

    public long getTotalOffset(FileType var1);

    public int getStored();

    public void setFinished(int var1, int var2, boolean var3);

    public static enum FileType {
        CHUNK_DATA(1300L, 1000000L),
        HEIGHT_DATA(260L, 4000000L);

        long offset;
        long buffer;

        private FileType(long offset, long instances) {
            this.offset = offset;
            this.buffer = offset * instances;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getBufferLimit() {
            return this.buffer;
        }

        public IChunkData createData(Chunk chunk, boolean isFinished) {
            return new ChunkData(chunk, isFinished);
        }

        public IChunkData createData(ByteBuffer chunkBuffer, ByteBuffer heightData) throws IOException {
            return ChunkData.createDataFromBuffer(chunkBuffer, heightData);
        }
    }
}

