/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import pregenerator.impl.client.preview.data.IFileProvider;
import pregenerator.impl.client.preview.data.ITask;
import pregenerator.impl.client.preview.data.Tasks;
import pregenerator.impl.client.preview.world.IHeightMap;
import pregenerator.impl.client.preview.world.data.IChunkData;

public class ChunkCache
implements IFileProvider,
IHeightMap {
    Cache<Integer, int[]> cachedHeights = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    Deque<ITask> tasks = new ConcurrentLinkedDeque<ITask>();
    BitSet terrainOnly = new BitSet(4000000);
    BitSet fullyGenerated = new BitSet(4000000);
    int[] dataIndexes = new int[4000000];
    int currentIndex = 0;
    boolean closing = false;
    FileChannel chunkData;
    FileChannel heightData;
    Path chunkFile;
    Path heightFile;

    public ChunkCache(Path chunk, Path height) throws Exception {
        this.chunkFile = chunk;
        this.heightFile = height;
        this.chunkData = FileChannel.open(chunk, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.heightData = FileChannel.open(height, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        Arrays.fill(this.dataIndexes, -1);
    }

    public FileChannel getChunkData() {
        return this.chunkData;
    }

    public FileChannel getHeightData() {
        return this.heightData;
    }

    public boolean isFullyFinished() {
        return this.terrainOnly.equals(this.fullyGenerated);
    }

    public int getChunksToFinish() {
        return this.terrainOnly.cardinality() - this.fullyGenerated.cardinality();
    }

    public boolean reset() {
        this.awaitFinish();
        this.close();
        this.closing = false;
        try {
            Files.deleteIfExists(this.chunkFile);
            Files.deleteIfExists(this.heightFile);
            this.chunkData = FileChannel.open(this.chunkFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            this.heightData = FileChannel.open(this.heightFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            Arrays.fill(this.dataIndexes, -1);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void awaitFinish() {
        this.closing = true;
        while (!this.tasks.isEmpty()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    public void shutdown() {
        this.awaitFinish();
        this.close();
        this.closing = false;
    }

    private void close() {
        try {
            if (this.chunkData != null) {
                this.chunkData.close();
                this.chunkData = null;
            }
            if (this.heightData != null) {
                this.heightData.close();
                this.heightData = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update() {
        try {
            while (!this.tasks.isEmpty() && !this.closing) {
                this.tasks.removeFirst().handleTask(this.chunkData, this.heightData, this);
            }
            if (this.closing) {
                this.tasks.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addTask(ITask task) {
        if (this.closing) {
            return;
        }
        this.tasks.add(task);
    }

    @Override
    public void setFinished(int x, int z, boolean fullyGen) {
        int index = this.index(x, z);
        this.terrainOnly.set(index);
        if (fullyGen) {
            this.fullyGenerated.set(index);
        }
    }

    public IChunkData getChunk(int x, int z, Cache<Long, IChunkData> cache) {
        Tasks.FetchChunkTask data = new Tasks.FetchChunkTask(x, z, cache);
        this.addTask(data);
        int tries = 0;
        while (!data.isDone()) {
            if (++tries >= 5) {
                return null;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        return data.getData();
    }

    @Override
    public boolean hasIndex(int x, int y) {
        int index = this.index(x, y);
        return index < 0 || index >= 4000000 ? false : this.dataIndexes[index] != -1;
    }

    @Override
    public long getIndex(int x, int y, IFileProvider.FileType type) {
        int index = this.index(x, y);
        if (index < 0 || index >= 4000000) {
            return -1L;
        }
        return (long)this.dataIndexes[index] * type.getOffset();
    }

    @Override
    public long getOrCreateIndex(int x, int y, IFileProvider.FileType type) {
        int index = this.index(x, y);
        if (index < 0 || index >= 4000000) {
            return -1L;
        }
        if (this.dataIndexes[index] == -1) {
            this.dataIndexes[index] = this.currentIndex++;
        }
        return (long)this.dataIndexes[index] * type.getOffset();
    }

    @Override
    public long getTotalOffset(IFileProvider.FileType type) {
        return (long)this.currentIndex * type.getOffset();
    }

    @Override
    public int getStored() {
        return this.currentIndex;
    }

    private int index(int x, int y) {
        return (y + 1000) * 2000 + (x + 1000);
    }

    @Override
    public void storeHeightData(int x, int y, int[] heights) {
        int index = this.index(x, y);
        if (index < 0 || index >= 4000000) {
            return;
        }
        this.cachedHeights.put((Object)index, (Object)heights);
    }

    @Override
    public int getHeight(int x, int y) {
        return this.getHeight(x, y, 0);
    }

    @Override
    public int getHeight(int x, int y, int defaultValue) {
        int[] height = this.getHeightData(x >> 4, y >> 4);
        if (height.length <= 0) {
            return defaultValue;
        }
        return height[(y & 0xF) * 16 + (x & 0xF)];
    }

    @Override
    public int[] getHeightData(int x, int y) {
        if (!this.hasHeightsStored(x, y)) {
            return new int[0];
        }
        int index = this.index(x, y);
        int[] data = (int[])this.cachedHeights.getIfPresent((Object)index);
        if (data == null) {
            data = this.loadDataFromDisk(x, y);
            this.cachedHeights.put((Object)index, (Object)data);
        }
        return data;
    }

    @Override
    public boolean hasHeightsStored(int x, int y) {
        return this.getIndex(x, y, IFileProvider.FileType.HEIGHT_DATA) >= 0L;
    }

    private int[] loadDataFromDisk(int x, int y) {
        Tasks.FetchHeightData data = new Tasks.FetchHeightData(x, y);
        this.addTask(data);
        while (!data.isDone()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                return new int[256];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data.getHeightData();
    }
}

