/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.world;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ReportedException;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.StringUtils;
import pregenerator.impl.client.preview.world.CustomServer;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.storage.PregenTaskStorage;

public class WorldSeed {
    static boolean init = false;
    GuiTextField seedField;
    GuiCreateWorld prevGui;
    GuiScreen mainMenu;
    WorldSettings settings;
    String name;
    String folderName;
    long seed;

    public WorldSeed(GuiCreateWorld gui) {
        this.prevGui = gui;
        this.seedField = (GuiTextField)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"worldSeedField", "field_146335_h"});
        this.name = ((GuiTextField)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"worldNameField", "field_146333_g"})).func_146179_b().trim();
        this.folderName = (String)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"saveDirName", "field_146336_i"});
        this.mainMenu = (GuiScreen)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"parentScreen", "field_146332_f"});
        this.readSeed();
    }

    private void readSeed() {
        long textSeed = WorldSeed.makeSeed(this.seedField.func_146179_b());
        this.seed = textSeed == 0L ? new Random().nextLong() : textSeed;
        this.seedField.func_146180_a(Long.toString(this.seed));
        if (this.settings == null) {
            this.createSettings();
            return;
        }
        this.settings.func_77165_h().onGUICreateWorldPress();
        WorldSettings newSettings = new WorldSettings(this.seed, this.settings.func_77162_e(), this.settings.func_77164_g(), this.settings.func_77158_f(), this.settings.func_77165_h());
        if (this.settings.func_77167_c()) {
            newSettings.func_77159_a();
        }
        if (this.settings.func_77163_i()) {
            newSettings.func_77166_b();
        }
        this.settings = newSettings;
    }

    private void createSettings() {
        int selectedIndex = (Integer)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"selectedIndex", "field_146331_K"});
        WorldType.field_77139_a[selectedIndex].onGUICreateWorldPress();
        WorldSettings worldsettings = new WorldSettings(this.seed, GameType.func_77142_a((String)((String)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"gameMode", "field_146342_r"}))), ((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"generateStructuresEnabled", "field_146341_s"})).booleanValue(), ((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"hardCoreMode", "field_146337_w"})).booleanValue(), WorldType.field_77139_a[selectedIndex]);
        worldsettings.func_82750_a(this.prevGui.field_146334_a);
        if (((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"bonusChestEnabled", "field_146338_v"})).booleanValue() && !((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"hardCoreMode", "field_146337_w"})).booleanValue()) {
            worldsettings.func_77159_a();
        }
        if (((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"allowCheats", "field_146340_t"})).booleanValue() && !((Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (String[])new String[]{"hardCoreMode", "field_146337_w"})).booleanValue()) {
            worldsettings.func_77166_b();
        }
        this.settings = worldsettings;
    }

    public WorldSettings getSettings() {
        return this.settings;
    }

    public String getWorldName() {
        return this.name;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public GuiScreen getMainMenu() {
        return this.mainMenu;
    }

    public GuiCreateWorld getPrevGui() {
        return this.prevGui;
    }

    public long getSeed() {
        return this.seed;
    }

    public String getTextSeed() {
        return this.seedField.func_146179_b();
    }

    public void setSeed(String seed) {
        ReflectionHelper.setPrivateValue(GuiCreateWorld.class, (Object)this.prevGui, (Object)seed, (String[])new String[]{"worldSeed", "field_146329_I"});
        this.seedField.func_146180_a(seed);
        this.readSeed();
    }

    public CustomServer createServer() {
        String folderName = "Preview";
        FMLClientHandler.instance().startIntegratedServer(folderName, this.name, this.settings);
        System.gc();
        Minecraft mc = Minecraft.func_71410_x();
        try {
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(mc.func_110437_J(), UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(mc.field_71412_D, MinecraftServer.field_152367_a.getName()));
            TileEntitySkull.func_184293_a((PlayerProfileCache)playerprofilecache);
            TileEntitySkull.func_184294_a((MinecraftSessionService)minecraftsessionservice);
            PlayerProfileCache.func_187320_a((boolean)false);
            CustomServer server = new CustomServer(mc, folderName, this.name, this.settings, yggdrasilauthenticationservice, minecraftsessionservice, gameprofilerepository, playerprofilecache);
            Field field = this.findServer();
            field.setAccessible(true);
            field.set(mc, (Object)server);
            return server;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Starting integrated server");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Starting integrated server");
            crashreportcategory.func_71507_a("Level ID", (Object)folderName);
            crashreportcategory.func_71507_a("Level Name", (Object)this.name);
            throw new ReportedException(crashreport);
        }
    }

    public void destroyServer(final CustomServer server) {
        server.func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (ChunkProcessor.INSTANCE.isRunning()) {
                    ChunkProcessor.INSTANCE.interruptTask(false, true);
                    PregenTaskStorage.getFromServer((MinecraftServer)server).clearAll();
                }
            }
        });
        if (server.func_71241_aa()) {
            return;
        }
        server.func_71263_m();
        while (!server.func_71241_aa()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        try {
            ThreadedFileIOBase.func_178779_a().func_75734_a();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        RegionFileCache.func_76551_a();
        try {
            Field field = this.findServer();
            field.setAccessible(true);
            field.set(Minecraft.func_71410_x(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Field findServer() {
        Minecraft mc = Minecraft.func_71410_x();
        for (Field field : mc.getClass().getDeclaredFields()) {
            if (!IntegratedServer.class.isAssignableFrom(field.getType())) continue;
            return field;
        }
        return null;
    }

    public void removePreview(boolean fully) {
        WorldSeed.removeFile(WorldSeed.getPreviewFolder().toFile(), fully);
    }

    public void createPaths() {
        try {
            Files.createDirectories(WorldSeed.getMapFolder(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static long makeSeed(String input) {
        if (!StringUtils.isEmpty((CharSequence)input)) {
            try {
                return Long.parseLong(input);
            }
            catch (NumberFormatException var7) {
                return input.hashCode();
            }
        }
        return 0L;
    }

    public static String getDimensionName(int id) {
        try {
            StringBuilder builder = new StringBuilder();
            for (String s : DimensionManager.getProviderType((int)id).func_186065_b().replace("_", " ").split(" ")) {
                builder.append(StringUtils.capitalize((String)s)).append(" ");
            }
            builder.setLength(builder.length() - 1);
            return builder.toString();
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    public static Path getPreviewFolder() {
        return Minecraft.func_71410_x().field_71412_D.toPath().resolve("saves/Preview");
    }

    public static Path getMapFolder() {
        return WorldSeed.getPreviewFolder().resolve("previewData");
    }

    public static void removeFile(File file, boolean itself) {
        if (!file.exists()) {
            return;
        }
        for (File sub : file.listFiles()) {
            try {
                if (sub.isDirectory()) {
                    WorldSeed.removeFile(sub, true);
                    continue;
                }
                sub.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (itself) {
            try {
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static long[] getData() {
        long first = Runtime.getRuntime().totalMemory();
        long second = Runtime.getRuntime().freeMemory();
        long last = Runtime.getRuntime().maxMemory();
        return new long[]{first - second, first, last};
    }

    public static long value(long input) {
        return input / 1024L / 1024L;
    }
}

