/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands;

import net.minecraftforge.common.DimensionManager;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.CommandBuilder;
import pregenerator.impl.commands.base.CommandNode;
import pregenerator.impl.commands.base.PregenCommand;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.DimensionArgument;
import pregenerator.impl.commands.base.args.EnumArgument;
import pregenerator.impl.processor.generator.BenchmarkManager;
import pregenerator.impl.processor.generator.tasks.BenchmarkTask;

public class BenchmarkCommands {
    public static CommandNode createBenchmarkCommands() {
        CommandBuilder builder = new CommandBuilder("benchmark");
        builder.literal("info", BenchmarkCommands::info).popTop();
        PregenCommand benchmark = BenchmarkCommands::runBenchmark;
        builder.literal("start", benchmark);
        builder.arg("Task-Size", EnumArgument.value(BenchmarkManager.BenchmarkSize.class), benchmark).popTop();
        PregenCommand singleCommand = BenchmarkCommands::runSingleBenchmark;
        builder.literal("start_single").arg("dimension", DimensionArgument.any(), singleCommand).arg("Task-Size", EnumArgument.value(BenchmarkManager.BenchmarkSize.class), singleCommand).popTop();
        return builder.build();
    }

    private static void info(PregenCommands.CommandContext context) {
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.benchmark.info"));
    }

    private static void runSingleBenchmark(PregenCommands.CommandContext context) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.benchmark.active"));
            return;
        }
        if (context.getSenderId() == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.benchmark.player"));
            return;
        }
        int dimension = context.getDimension("dimension");
        if (context.getWorld(dimension) == null) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        BenchmarkManager.BenchmarkSize size = context.getArgumentOrDefault("Task-Size", BenchmarkManager.BenchmarkSize.class, BenchmarkManager.BenchmarkSize.SMALL_TASK);
        context.startTask(new BenchmarkTask("SingleBenchmarkTest", dimension, size.isSmall()));
        BenchmarkManager.INSTANCE.startBenchmark(context.getSenderId());
    }

    private static void runBenchmark(PregenCommands.CommandContext context) {
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.benchmark.active"));
            return;
        }
        if (context.getSenderId() == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.benchmark.player"));
            return;
        }
        BenchmarkManager.BenchmarkSize size = context.getArgumentOrDefault("Task-Size", BenchmarkManager.BenchmarkSize.class, BenchmarkManager.BenchmarkSize.SMALL_TASK);
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dimId = integerArray[i];
            context.startTask(new BenchmarkTask("BenchmarkTest_" + dimId, dimId, size.isSmall()));
        }
        BenchmarkManager.INSTANCE.startBenchmark(context.getSenderId());
    }
}

