/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands;

import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.CommandBuilder;
import pregenerator.impl.commands.base.CommandNode;
import pregenerator.impl.commands.base.PregenCommand;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.DimensionArgument;
import pregenerator.impl.commands.base.args.EnumArgument;
import pregenerator.impl.commands.base.args.PositionArgument;
import pregenerator.impl.commands.base.args.RangeArgument;
import pregenerator.impl.commands.base.args.StringArgument;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.GenShape;
import pregenerator.impl.processor.generator.BenchmarkManager;
import pregenerator.impl.processor.generator.GenerationType;
import pregenerator.impl.processor.generator.tasks.ITask;
import pregenerator.impl.processor.generator.tasks.SquareTask;

public class GenCommands {
    public static CommandNode createGenCommand() {
        CommandBuilder builder = new CommandBuilder("gen");
        PregenCommand radius = GenCommands::executeRadius;
        builder.literal("radius");
        builder.arg("Task Name", StringArgument.text());
        builder.arg("Shape", EnumArgument.value(GenShape.class));
        builder.arg("Center", PositionArgument.chunkPos());
        builder.arg("Radius", RangeArgument.chunkRange(1, 25000), radius);
        builder.arg("Dimension", DimensionArgument.any(), radius);
        builder.arg("Generation Type", EnumArgument.value(GenerationType.class), radius).popTop();
        PregenCommand expansion = GenCommands::executeExpansion;
        builder.literal("expansion");
        builder.arg("Task Name", StringArgument.text());
        builder.arg("Shape", EnumArgument.value(GenShape.class));
        builder.arg("Center", PositionArgument.chunkPos());
        builder.arg("Min Radius", RangeArgument.chunkRange(1, 25000));
        builder.arg("Max Radius", RangeArgument.chunkRange(1, 25000), expansion);
        builder.arg("Dimension", DimensionArgument.any(), expansion);
        builder.arg("Generation Type", EnumArgument.value(GenerationType.class), expansion).popTop();
        PregenCommand area = GenCommands::executeAreas;
        builder.literal("area");
        builder.arg("Task Name", StringArgument.text());
        builder.arg("Shape", EnumArgument.value(GenShape.class));
        builder.arg("From", PositionArgument.chunkPos());
        builder.arg("To", PositionArgument.chunkPos(), area);
        builder.arg("Dimension", DimensionArgument.any(), area);
        builder.arg("Generation Type", EnumArgument.value(GenerationType.class), area).popTop();
        PregenCommand border = GenCommands::executeBorder;
        builder.literal("worldborder");
        builder.arg("Task Name", StringArgument.text(), border);
        builder.arg("Dimension", DimensionArgument.any(), border);
        builder.arg("Generation Type", EnumArgument.value(GenerationType.class), border).popTop();
        return builder.build();
    }

    private static void executeBorder(PregenCommands.CommandContext context) {
        String name = context.getArgument("Task Name", String.class);
        int dimension = context.getDimension("Dimension");
        GenerationType type = context.getArgumentOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        WorldServer server = context.getWorld(dimension);
        if (server == null) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        WorldBorder border = server.func_175723_af();
        int size = (int)(border.func_177741_h() / 2.0) >> 4;
        int memoryError = GenCommands.validateDiskUsage(GenShape.SQUARE.calculateRadius(size), dimension);
        if (memoryError == 3) {
            context.sendFailure(TextUtil.taskOverflow(TextUtil.getWorldSize(GenShape.SQUARE.calculateRadius(size), dimension)));
            return;
        }
        if (memoryError == 1) {
            context.sendSuccess(TextUtil.taskInfo(TextUtil.getWorldSize(GenShape.SQUARE.calculateRadius(size), dimension)));
        }
        SquareTask task = new SquareTask(name, dimension, type, new FilePos((int)border.func_177731_f() >> 4, (int)border.func_177721_g() >> 4), size);
        if (memoryError == 2) {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                context.sendFailure(TextUtil.translate("command.chunk_pregen.benchmark.active_queue"));
                return;
            }
            if (context.storeTask(task)) {
                context.sendSuccess(TextUtil.taskWarning(TextUtil.getWorldSize(GenShape.SQUARE.calculateRadius(size), dimension), task.getName()));
            }
            return;
        }
        context.startTask(task);
    }

    private static void executeAreas(PregenCommands.CommandContext context) {
        FilePos maxPos;
        String name = context.getArgument("Task Name", String.class);
        GenShape shape = context.getArgument("Shape", GenShape.class);
        FilePos min = context.getArgument("From", FilePos.class);
        FilePos max = context.getArgument("To", FilePos.class);
        int dimension = context.getDimension("Dimension");
        GenerationType type = context.getArgumentOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        if (context.getWorld(dimension) == null) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        FilePos minPos = new FilePos(min.x < max.x ? min.x : max.x, min.z < max.z ? min.z : max.z);
        int memoryError = GenCommands.validateDiskUsage(shape.calculateRadius(minPos, maxPos = new FilePos(min.x > max.x ? min.x : max.x, min.z > max.z ? min.z : max.z)), dimension);
        if (memoryError == 3) {
            context.sendFailure(TextUtil.taskOverflow(TextUtil.getWorldSize(shape.calculateRadius(minPos, maxPos), dimension)));
            return;
        }
        if (memoryError == 1) {
            context.sendSuccess(TextUtil.taskInfo(TextUtil.getWorldSize(shape.calculateRadius(minPos, maxPos), dimension)));
        }
        ITask task = shape.createAreaGenTask(name, minPos, maxPos, type, dimension);
        if (memoryError == 2) {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                context.sendFailure(TextUtil.translate("command.chunk_pregen.benchmark.active_queue"));
                return;
            }
            if (context.storeTask(task)) {
                context.sendSuccess(TextUtil.taskWarning(TextUtil.getWorldSize(shape.calculateRadius(minPos, maxPos), dimension), task.getName()));
            }
            return;
        }
        context.startTask(task);
    }

    private static void executeExpansion(PregenCommands.CommandContext context) {
        String name = context.getArgument("Task Name", String.class);
        GenShape shape = context.getArgument("Shape", GenShape.class);
        FilePos center = context.getArgument("Center", FilePos.class);
        int minRadius = context.getArgument("Min Radius", Integer.class);
        int maxRadius = context.getArgument("Max Radius", Integer.class);
        int dimension = context.getDimension("Dimension");
        GenerationType type = context.getArgumentOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        if (minRadius > maxRadius) {
            context.sendFailure(TextUtil.minBiggerThenMax());
            return;
        }
        if (context.getWorld(dimension) == null) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        int memoryError = GenCommands.validateDiskUsage(shape.calculateRadius(minRadius, maxRadius), dimension);
        if (memoryError == 3) {
            context.sendFailure(TextUtil.taskOverflow(TextUtil.getWorldSize(shape.calculateRadius(minRadius, maxRadius), dimension)));
            return;
        }
        if (memoryError == 1) {
            context.sendSuccess(TextUtil.taskInfo(TextUtil.getWorldSize(shape.calculateRadius(minRadius, maxRadius), dimension)));
        }
        ITask task = shape.createExpansionGenTask(name, center.x, center.z, minRadius, maxRadius, type, dimension);
        if (memoryError == 2) {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                context.sendFailure(TextUtil.translate("command.chunk_pregen.benchmark.active_queue"));
                return;
            }
            if (context.storeTask(task)) {
                context.sendSuccess(TextUtil.taskWarning(TextUtil.getWorldSize(shape.calculateRadius(minRadius, maxRadius), dimension), task.getName()));
            }
            return;
        }
        context.startTask(task);
    }

    private static void executeRadius(PregenCommands.CommandContext context) {
        String name = context.getArgument("Task Name", String.class);
        GenShape shape = context.getArgument("Shape", GenShape.class);
        FilePos center = context.getArgument("Center", FilePos.class);
        int radius = context.getArgument("Radius", Integer.class);
        int dimension = context.getDimension("Dimension");
        GenerationType type = context.getArgumentOrDefault("Generation Type", GenerationType.class, GenerationType.FAST_CHECK_GEN);
        if (context.getWorld(dimension) == null) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        int memoryError = GenCommands.validateDiskUsage(shape.calculateRadius(radius), dimension);
        if (memoryError == 3) {
            context.sendFailure(TextUtil.taskOverflow(TextUtil.getWorldSize(shape.calculateRadius(radius), dimension)));
            return;
        }
        if (memoryError == 1) {
            context.sendSuccess(TextUtil.taskInfo(TextUtil.getWorldSize(shape.calculateRadius(radius), dimension)));
        }
        ITask task = shape.createRadiusGenTask(name, center.x, center.z, radius, type, dimension);
        if (memoryError == 2) {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                context.sendFailure(TextUtil.translate("command.chunk_pregen.benchmark.active_queue"));
                return;
            }
            if (context.storeTask(task)) {
                context.sendSuccess(TextUtil.taskWarning(TextUtil.getWorldSize(shape.calculateRadius(radius), dimension), task.getName()));
            }
            return;
        }
        context.startTask(task);
    }

    public static int validateDiskUsage(long chunks, int dimensionId) {
        double usage = (double)TextUtil.getWorldSize(chunks, dimensionId) / (double)TextUtil.getFreeMemory();
        if (usage < 0.3) {
            return 0;
        }
        if (usage < 0.8) {
            return 1;
        }
        if (usage < 1.0) {
            return 2;
        }
        return 3;
    }
}

