/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.command.CommandException;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.CommandNode;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.IArgument;
import pregenerator.impl.commands.base.args.StringWalker;

public class ArgumentNode<T>
extends CommandNode {
    String name;
    IArgument<T> argument;
    SuggestionProvider customSuggestions;

    public ArgumentNode(String name, IArgument<T> argument) {
        this.name = name;
        this.argument = argument;
    }

    public ArgumentNode<T> withSuggestion(SuggestionProvider customSuggestions) {
        this.customSuggestions = customSuggestions;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isValid(StringWalker walker, PregenCommands.CommandContext context) {
        try {
            T arg = this.argument.parse(walker, context);
            if (arg != null) {
                return context.addArgument(this.name, arg);
            }
        }
        catch (CommandException e) {
            context.setException(this.name, TextUtil.translate(e.getMessage(), e.func_74844_a()));
        }
        return false;
    }

    public int getArgumentElements() {
        return this.argument.getArgumentElements();
    }

    @Override
    public List<String> getExamples(PregenCommands.CommandContext context, int argumentIndex) {
        if (this.customSuggestions != null) {
            ObjectArrayList result = new ObjectArrayList();
            this.customSuggestions.collectSuggestions(context, argumentIndex, ((List)result)::add);
            return result;
        }
        return this.argument.getExamples(context, argumentIndex);
    }

    public static interface SuggestionProvider {
        public void collectSuggestions(PregenCommands.CommandContext var1, int var2, Consumer<String> var3);
    }
}

