/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base;

import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import pregenerator.impl.commands.base.ArgumentNode;
import pregenerator.impl.commands.base.CommandNode;
import pregenerator.impl.commands.base.LiteralNode;
import pregenerator.impl.commands.base.PregenCommand;
import pregenerator.impl.commands.base.args.IArgument;

public class CommandBuilder {
    Stack<CommandNode> queue = new ObjectArrayList();
    CommandNode current;

    public CommandBuilder(String literal) {
        this.current = new LiteralNode(literal);
    }

    public CommandBuilder(String name, IArgument<?> argument) {
        this.current = new ArgumentNode(name, argument);
    }

    public CommandBuilder literal(String literal) {
        return this.push(new LiteralNode(literal));
    }

    public CommandBuilder literal(String literal, PregenCommand command) {
        return this.push(new LiteralNode(literal).withCommand(command));
    }

    public CommandBuilder arg(String name, IArgument<?> type) {
        return this.push(new ArgumentNode(name, type));
    }

    public CommandBuilder arg(String name, IArgument<?> type, PregenCommand command) {
        return this.push(new ArgumentNode(name, type).withCommand(command));
    }

    public CommandBuilder arg(String name, IArgument<?> type, ArgumentNode.SuggestionProvider suggestion) {
        return this.push(new ArgumentNode(name, type).withSuggestion(suggestion));
    }

    public CommandBuilder arg(String name, IArgument<?> type, ArgumentNode.SuggestionProvider suggestion, PregenCommand command) {
        return this.push(new ArgumentNode(name, type).withSuggestion(suggestion).withCommand(command));
    }

    private CommandBuilder push(CommandNode command) {
        this.current.addChild(command);
        this.queue.push((Object)this.current);
        this.current = command;
        return this;
    }

    public CommandBuilder popTop() {
        while (!this.queue.isEmpty()) {
            this.current = (CommandNode)this.queue.pop();
        }
        return this;
    }

    public CommandBuilder pop() {
        this.current = (CommandNode)this.queue.pop();
        return this;
    }

    public CommandBuilder pop(int layers) {
        while (layers > 0) {
            this.current = (CommandNode)this.queue.pop();
            --layers;
        }
        return this;
    }

    public CommandNode build() {
        while (!this.queue.isEmpty()) {
            this.current = (CommandNode)this.queue.pop();
        }
        return this.current;
    }
}

