/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base.args;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.IArgument;
import pregenerator.impl.commands.base.args.StringWalker;

public class DoubleArgument
implements IArgument<Double> {
    private static final List<String> EXAMPLES = ObjectArrayList.wrap((Object[])new String[]{"0", "1.2", ".5", "-1", "-.5", "-1234.56"});
    double min;
    double max;

    protected DoubleArgument(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public static DoubleArgument value() {
        return new DoubleArgument(-1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static DoubleArgument max(double max) {
        return new DoubleArgument(-1.7976931348623157E308, max);
    }

    public static DoubleArgument min(double min) {
        return new DoubleArgument(min, Double.MAX_VALUE);
    }

    public static DoubleArgument range(double min, double max) {
        return new DoubleArgument(min, max);
    }

    @Override
    public Double parse(StringWalker args, PregenCommands.CommandContext context) throws CommandException {
        double value = args.readDouble();
        if (value < this.min) {
            throw new CommandException("commands.chunk_pregen.error.parse.to_small", new Object[]{TextUtil.FLOATING_NUMBERS.format(value), TextUtil.FLOATING_NUMBERS.format(this.min)});
        }
        if (value > this.max) {
            throw new CommandException("commands.chunk_pregen.error.parse.to_big", new Object[]{TextUtil.FLOATING_NUMBERS.format(value), TextUtil.FLOATING_NUMBERS.format(this.max)});
        }
        return value;
    }

    @Override
    public List<String> getExamples(PregenCommands.CommandContext context, int argumentIndex) {
        return EXAMPLES;
    }
}

