/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base.args;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.IArgument;
import pregenerator.impl.commands.base.args.StringWalker;

public class IntegerArgument
implements IArgument<Integer> {
    private static final List<String> EXAMPLES = ObjectArrayList.wrap((Object[])new String[]{"0", "123", "-123"});
    int min;
    int max;

    protected IntegerArgument(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public static IntegerArgument value() {
        return new IntegerArgument(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static IntegerArgument max(int max) {
        return new IntegerArgument(Integer.MIN_VALUE, max);
    }

    public static IntegerArgument min(int min) {
        return new IntegerArgument(min, Integer.MAX_VALUE);
    }

    public static IntegerArgument range(int min, int max) {
        return new IntegerArgument(min, max);
    }

    @Override
    public Integer parse(StringWalker args, PregenCommands.CommandContext context) throws CommandException {
        int value = args.readInt();
        if (value < this.min) {
            throw new CommandException("commands.chunk_pregen.error.parse.to_small", new Object[]{TextUtil.NUMBERS.format(value), TextUtil.NUMBERS.format(this.min)});
        }
        if (value > this.max) {
            throw new CommandException("commands.chunk_pregen.error.parse.to_big", new Object[]{TextUtil.NUMBERS.format(value), TextUtil.NUMBERS.format(this.max)});
        }
        return value;
    }

    @Override
    public List<String> getExamples(PregenCommands.CommandContext context, int argumentIndex) {
        return EXAMPLES;
    }
}

