/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base.args;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.IArgument;
import pregenerator.impl.commands.base.args.StringWalker;
import pregenerator.impl.misc.FilePos;

public class PositionArgument
implements IArgument<FilePos> {
    private static final List<String> FIRST = ObjectArrayList.wrap((Object[])new String[]{"0", "~", "^", "^1", "~1", "b2"});
    private static final List<String> SECOND = ObjectArrayList.wrap((Object[])new String[]{"0", "~", "^", "^-5", "~-5", "b-5"});
    boolean chunkPos;

    protected PositionArgument(boolean chunkPos) {
        this.chunkPos = chunkPos;
    }

    public static PositionArgument blockPos() {
        return new PositionArgument(false);
    }

    public static PositionArgument chunkPos() {
        return new PositionArgument(true);
    }

    @Override
    public FilePos parse(StringWalker args, PregenCommands.CommandContext context) throws CommandException {
        FilePos player = context.getSenderPosition();
        FilePos spawn = context.getSpawnPosition();
        if (!this.chunkPos) {
            player = player.toChunkPos();
            spawn = spawn.toChunkPos();
        }
        return new FilePos(args.parsePosition(player.x, spawn.x, this.chunkPos), args.parsePosition(player.z, spawn.z, this.chunkPos));
    }

    @Override
    public int getArgumentElements() {
        return 2;
    }

    @Override
    public List<String> getExamples(PregenCommands.CommandContext context, int argumentIndex) {
        return argumentIndex == 0 ? FIRST : SECOND;
    }
}

