/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.config;

import carbonconfiglib.api.IConfigSerializer;
import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.api.buffer.IReadBuffer;
import carbonconfiglib.api.buffer.IWriteBuffer;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.ParsedCollections;
import carbonconfiglib.utils.structure.IStructuredData;
import carbonconfiglib.utils.structure.StructureCompound;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import pregenerator.impl.config.DimensionSuggestion;

public class SpeedEntry {
    int dim;
    float speed;

    public SpeedEntry() {
        this(0, 1.0f);
    }

    public SpeedEntry(int dim, float speed) {
        this.dim = dim;
        this.speed = speed;
    }

    public int getDimension() {
        return this.dim;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpeedEntry) {
            SpeedEntry entry = (SpeedEntry)obj;
            return Float.compare(this.speed, entry.speed) == 0 && Objects.equals(this.dim, entry.dim);
        }
        return false;
    }

    public ParsedCollections.ParsedMap serialize() {
        ParsedCollections.ParsedMap map = new ParsedCollections.ParsedMap();
        map.put("dimension", (Object)this.dim);
        map.put("speed", (Object)this.speed);
        return map;
    }

    public static List<SpeedEntry> getDefaultValues() {
        ObjectArrayList list = new ObjectArrayList();
        list.add(new SpeedEntry(0, 1.0f));
        list.add(new SpeedEntry(-1, 1.0f));
        list.add(new SpeedEntry(1, 1.0f));
        return list;
    }

    private static ParseResult<SpeedEntry> parse(ParsedCollections.ParsedMap map) {
        ParseResult dimension = map.getOrError("dimension", Integer.class);
        if (dimension.hasError()) {
            return dimension.onlyError();
        }
        ParseResult speed = map.getOrError("speed", Double.class);
        if (speed.hasError()) {
            return speed.onlyError();
        }
        return ParseResult.success((Object)new SpeedEntry((Integer)dimension.getValue(), ((Double)speed.getValue()).floatValue()));
    }

    private static void write(IWriteBuffer buffer, SpeedEntry entry) {
        buffer.writeInt(entry.getDimension());
        buffer.writeFloat(entry.getSpeed());
    }

    private static SpeedEntry read(IReadBuffer buffer) {
        return new SpeedEntry(buffer.readInt(), buffer.readFloat());
    }

    public static IConfigSerializer<SpeedEntry> getSerializer() {
        StructureCompound.CompoundBuilder builder = new StructureCompound.CompoundBuilder();
        builder.simple("dimension", IStructuredData.EntryDataType.INTEGER).addSuggestions(new ISuggestionProvider[]{DimensionSuggestion.INSTANCE}).finish();
        builder.simple("speed", IStructuredData.EntryDataType.DOUBLE).finish();
        return IConfigSerializer.withSync((StructureCompound.CompoundData)builder.build(), (Object)new SpeedEntry(), SpeedEntry::parse, SpeedEntry::serialize, SpeedEntry::read, SpeedEntry::write);
    }
}

