/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.misc;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import pregenerator.base.api.TextUtil;

public class SaveZone {
    String name;
    int minX;
    int minZ;
    int maxX;
    int maxZ;

    public SaveZone(String name, int x, int z, int width, int height) {
        this.name = name;
        this.minX = x - width / 2;
        this.minZ = z - height / 2;
        this.maxX = x + width / 2;
        this.maxZ = z + height / 2;
    }

    public SaveZone(NBTTagCompound compound) {
        this.name = compound.func_74779_i("name");
        this.minX = compound.func_74762_e("minX");
        this.minZ = compound.func_74762_e("minZ");
        this.maxX = compound.func_74762_e("maxX");
        this.maxZ = compound.func_74762_e("maxZ");
    }

    public NBTTagCompound write() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("minX", this.minX);
        nbt.func_74768_a("minZ", this.minZ);
        nbt.func_74768_a("maxX", this.maxX);
        nbt.func_74768_a("maxZ", this.maxZ);
        return nbt;
    }

    public boolean isInsideBox(int xPos, int zPos) {
        return xPos >= this.minX && xPos <= this.maxX && zPos >= this.minZ && zPos <= this.maxZ;
    }

    public String getName() {
        return this.name;
    }

    public int getCenterX() {
        return this.minX + (this.maxX - this.minX) / 2;
    }

    public int getCenterZ() {
        return this.minZ + (this.maxZ - this.minZ) / 2;
    }

    public int getRadius() {
        return (this.maxX - this.minX) / 2;
    }

    public ITextComponent createCommand(int dimension, String type) {
        Style style = new Style().func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pregen structure savezone remove " + dimension + " " + type + " " + this.name));
        ITextComponent text = TextUtil.translate("commands.chunk_pregen.structure.delete").func_150255_a(style);
        return TextUtil.translate("commands.chunk_pregen.savezone.entry", TextUtil.NUMBERS.format(this.minX), TextUtil.NUMBERS.format(this.minZ), TextUtil.NUMBERS.format(this.maxX), TextUtil.NUMBERS.format(this.maxZ), text);
    }
}

