/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.impl.misc.PregenAction;
import pregenerator.impl.retrogen.RetrogenManager;

public class RetrogenPacket {

    public static class Sync
    implements IPregenPacket {
        String id;
        boolean enable;

        public Sync() {
        }

        public Sync(String id, boolean enable) {
            this.id = id;
            this.enable = enable;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_180714_a(this.id);
            buffer.writeBoolean(this.enable);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.id = buffer.func_150789_c(Short.MAX_VALUE);
            this.enable = buffer.readBoolean();
        }

        @Override
        public void process(EntityPlayer player) {
            RetrogenManager.INSTANCE.toggleClient(this.id, this.enable);
        }
    }

    public static class Change
    implements IPregenPacket {
        String id;
        boolean enable;

        public Change() {
        }

        public Change(String id, boolean enable) {
            this.id = id;
            this.enable = enable;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_180714_a(this.id);
            buffer.writeBoolean(this.enable);
        }

        @Override
        public void read(PacketBuffer buffer) {
            this.id = buffer.func_150789_c(Short.MAX_VALUE);
            this.enable = buffer.readBoolean();
        }

        @Override
        public void process(EntityPlayer player) {
            if (ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                if (this.enable) {
                    RetrogenManager.INSTANCE.enableGenerator(this.id);
                } else {
                    RetrogenManager.INSTANCE.disableGenerator(this.id);
                }
                ChunkPregenerator.NETWORKING.sendToAllPlayers(new Sync(this.id, RetrogenManager.INSTANCE.isActive(this.id)));
                return;
            }
            player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
            ChunkPregenerator.NETWORKING.sendToPlayer(new Sync(this.id, RetrogenManager.INSTANCE.isActive(this.id)), player);
        }
    }

    public static class Answer
    implements IPregenPacket {
        Set<String> active = new LinkedHashSet<String>();

        public Answer() {
        }

        public Answer(Set<String> active) {
            this.active.addAll(active);
        }

        @Override
        public void write(PacketBuffer buffer) {
            IPregenPacket.writeCollectionReverse(buffer, this.active, PacketBuffer::func_180714_a);
        }

        @Override
        public void read(PacketBuffer buffer) {
            IPregenPacket.readCollection(buffer, this.active, T -> T.func_150789_c(Short.MAX_VALUE));
        }

        @Override
        public void process(EntityPlayer player) {
            RetrogenManager.INSTANCE.updateActiveGenerators(new ArrayList<String>(this.active));
        }
    }

    public static class Request
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(EntityPlayer player) {
            ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(RetrogenManager.INSTANCE.getActiveGenerators()), player);
        }
    }
}

