/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.impl.client.gui.StructureScreen;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.PregenAction;
import pregenerator.impl.misc.Tuple;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.TaskActions;
import pregenerator.impl.processor.deleter.tasks.DeletionSquareArea;
import pregenerator.impl.structure.MapGenStructureDataPregen;
import pregenerator.impl.structure.StructureData;
import pregenerator.impl.structure.StructureManager;

public class StructurePacket {

    public static class Delete
    implements IPregenPacket {
        int dimension;
        boolean fromWorld;
        StructureData data;

        public Delete() {
        }

        public Delete(int dimension, boolean fromWorld, StructureData data) {
            this.dimension = dimension;
            this.fromWorld = fromWorld;
            this.data = data;
        }

        @Override
        public void write(PacketBuffer buffer) throws IOException {
            buffer.writeInt(this.dimension);
            buffer.writeBoolean(this.fromWorld);
            this.data.writeToBuffer(buffer);
        }

        @Override
        public void read(PacketBuffer buffer) throws IOException {
            this.dimension = buffer.readInt();
            this.fromWorld = buffer.readBoolean();
            this.data = new StructureData(buffer);
        }

        @Override
        public void process(EntityPlayer player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.ALL_DELETION)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            MapGenStructureDataPregen manager = StructureManager.INSTANCE.getStructure(this.dimension, this.data.getType());
            if (manager == null) {
                player.func_145747_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.structure_screen.no_manager", this.data.getType(), TextUtil.dimension(this.dimension)), TextFormatting.RED));
                return;
            }
            Tuple<FilePos, FilePos> result = manager.deleteStructure(this.data.getChunkPos());
            if (result == null) {
                player.func_145747_a(TextUtil.applyTextStyle(TextUtil.translate("gui.chunk_pregen.structure_screen.no_structure", this.data.getType(), TextUtil.NUMBERS.format(this.data.getX()), TextUtil.NUMBERS.format(this.data.getZ())), TextFormatting.RED));
                return;
            }
            player.func_145747_a(TextUtil.translate("gui.chunk_pregen.structure_screen.deleted", this.data.getType(), TextUtil.NUMBERS.format(this.data.getX()), TextUtil.NUMBERS.format(this.data.getZ())));
            if (this.fromWorld) {
                TaskActions.startTask((IBaseTask)new DeletionSquareArea("delete_structure_" + this.data.getX() + "_" + this.data.getZ(), this.dimension, result.getFirst(), result.getSecond()), player, arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
            }
        }
    }

    public static class Answer
    implements IPregenPacket {
        int dimension;
        List<StructureData> data = new ArrayList<StructureData>();

        public Answer() {
        }

        public Answer(int dimension, List<StructureData> data) {
            this.dimension = dimension;
            this.data = data;
        }

        @Override
        public void write(PacketBuffer buffer) throws IOException {
            buffer.writeInt(this.dimension);
            IPregenPacket.writeCollection(buffer, this.data, StructureData::writeToBuffer);
        }

        @Override
        public void read(PacketBuffer buffer) throws IOException {
            this.dimension = buffer.readInt();
            IPregenPacket.readCollection(buffer, this.data, StructureData::new);
        }

        @Override
        public void process(EntityPlayer player) {
            this.processClient();
        }

        @SideOnly(value=Side.CLIENT)
        private void processClient() {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof StructureScreen) {
                ((StructureScreen)screen).acceptData(this.dimension, this.data);
            }
        }
    }

    public static class Request
    implements IPregenPacket {
        int dimension;

        public Request() {
        }

        public Request(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public void write(PacketBuffer buffer) throws IOException {
            buffer.writeInt(this.dimension);
        }

        @Override
        public void read(PacketBuffer buffer) throws IOException {
            this.dimension = buffer.readInt();
        }

        @Override
        public void process(EntityPlayer player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.ALL_SCANNING)) {
                player.func_146105_b(TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(this.dimension, Collections.emptyList()), player);
                return;
            }
            ChunkPregenerator.NETWORKING.sendToPlayer(new Answer(this.dimension, StructureManager.INSTANCE.getStructures(this.dimension, null)), player);
        }
    }
}

