/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IPregenPacket;
import pregenerator.base.hooks.PregenHandler;

public class SyncStatePacket
implements IPregenPacket {
    Side source;
    boolean commands;

    public SyncStatePacket() {
    }

    public SyncStatePacket(Side source, boolean commands) {
        this.source = source;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.source.isClient());
        buffer.writeBoolean(this.commands);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.source = buffer.readBoolean() ? Side.CLIENT : Side.SERVER;
        this.commands = buffer.readBoolean();
    }

    @Override
    public void process(EntityPlayer player) {
        if (this.source.isServer()) {
            ChunkPregenerator.NETWORKING.onPlayerJoined(player, false);
            ChunkPregenerator.NETWORKING.setPermissions(this.commands);
        } else {
            PregenHandler.INSTANCE.onServerJoinPacket(player);
        }
    }
}

