/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.deleter;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.gen.ChunkProviderServer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.RegionFileHelper;

public class DeleteProcess {
    LinkedList<DeleteFile> positions = new LinkedList();
    boolean loaded;
    WorldServer server;
    ChunkProviderServer prov;
    Path regionFolder;
    int total;

    public DeleteProcess(Path regionFolder, Map<Long, BitSet> data) {
        this.regionFolder = regionFolder;
        for (Map.Entry<Long, BitSet> entry : data.entrySet()) {
            DeleteFile file = new DeleteFile(this, new FilePos(entry.getKey()), entry.getValue());
            if (!file.isValid()) continue;
            this.positions.add(file);
            this.total += file.getCount();
        }
    }

    public DeleteProcess setChunkHost(WorldServer world) {
        if (world == null) {
            this.server = null;
            this.prov = null;
            return this;
        }
        this.server = world;
        this.prov = world.func_72863_F();
        return this;
    }

    public boolean hasWork() {
        return this.positions.size() > 0;
    }

    public DeleteFile getEntry() {
        return this.positions.poll();
    }

    public int getTotalWork() {
        return this.total;
    }

    public boolean loaded(FilePos pos) {
        if (this.prov == null) {
            return false;
        }
        if (this.prov.func_73149_a(pos.x, pos.z)) {
            return true;
        }
        return this.server.func_184164_w().func_187301_b(pos.x, pos.z) != null;
    }

    public static class DeleteFile {
        DeleteProcess process;
        FilePos pos;
        Path file;
        RegionFileHelper helper;
        BitSet positions;
        int tasks = 0;

        public DeleteFile(DeleteProcess process, FilePos entry, BitSet positions) {
            this.process = process;
            this.pos = entry;
            this.positions = positions;
            this.tasks = positions.cardinality();
            this.file = process.regionFolder.resolve("r." + this.pos.x + "." + this.pos.z + ".mca");
        }

        public boolean isValid() {
            return Files.exists(this.file, new LinkOption[0]);
        }

        public int getCount() {
            return this.tasks;
        }

        public void update() {
            this.helper = new RegionFileHelper(this.file.toFile());
            for (int i = 0; i < 1024; ++i) {
                if (!this.positions.get(i)) continue;
                this.helper.deleteChunk(i % 32, i / 32);
            }
            this.cleanup();
        }

        public void cleanup() {
            try {
                if (this.helper.close()) {
                    List<FilePos> filePos = this.helper.getInstalledChunks();
                    File temp = new File("Temp.mca");
                    File file = this.helper.getFile();
                    file.renameTo(temp);
                    RegionFile from = new RegionFile(temp);
                    RegionFile to = new RegionFile(file);
                    for (FilePos pos : filePos) {
                        DataInputStream read;
                        if (!from.func_76709_c(pos.x & 0x1F, pos.z & 0x1F) || (read = from.func_76704_a(pos.x & 0x1F, pos.z & 0x1F)) == null) continue;
                        DataOutputStream write = to.func_76710_b(pos.x & 0x1F, pos.z & 0x1F);
                        CompressedStreamTools.func_74800_a((NBTTagCompound)CompressedStreamTools.func_74794_a((DataInputStream)read), (DataOutput)write);
                        read.close();
                        write.close();
                    }
                    from.func_76708_c();
                    to.func_76708_c();
                    temp.delete();
                } else {
                    this.helper.getFile().delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

