/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.deleter;

import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Future;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.ThreadedFileIOBase;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.PregenConfig;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.DeltaTimer;
import pregenerator.impl.misc.FileCounter;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.IProcessor;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.ServerManager;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.tasks.IDeletionTask;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.PregenTaskStorage;

public class DeleteProcessor
implements IProcessor {
    public static final DecimalFormat format = new DecimalFormat("#.#");
    public static final DeleteProcessor INSTANCE = new DeleteProcessor();
    PrepareProgress progress = new PrepareProgress();
    IDeletionTask task;
    Future<DeleteProcess> future;
    DeleteProcess process;
    DeltaTimer timer = new DeltaTimer();
    FileCounter counter = new FileCounter();
    Instant start;
    int deleted = 0;
    int failed = 0;
    int ticker = 0;
    boolean paused;

    @Override
    public void onTickStart() {
        if (this.task == null || this.isStopped() || this.isPaused() || this.process == null) {
            return;
        }
        this.timer.start();
    }

    @Override
    public void onTickEnd() {
        if (this.task == null || this.isStopped() || this.isPaused()) {
            return;
        }
        if (this.future != null) {
            int newTime = this.getTicker();
            if (this.ticker != newTime) {
                this.ticker = newTime;
                double prog = (double)this.progress.getCurrent() / (double)this.progress.getMax() * 100.0;
                this.sendMessage(TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.prepare", this.progress.getCurrent(), this.progress.getMax(), TextUtil.FLOATING_NUMBERS.format(prog)), TextFormatting.AQUA));
            }
            if (this.future.isDone()) {
                try {
                    this.process = this.future.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.future = null;
            }
            return;
        }
        if (this.process == null) {
            return;
        }
        try {
            ThreadedFileIOBase.func_178779_a().func_75734_a();
            RegionFileCache.func_76551_a();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int max = PregenConfig.INSTANCE.timePerTick.get();
        long deltaTime = this.timer.averageDelta();
        if (deltaTime >= (long)max) {
            return;
        }
        while (deltaTime + this.timer.getDeltaTime() < (long)max && this.process.hasWork()) {
            DeleteProcess.DeleteFile file = this.process.getEntry();
            file.update();
            this.deleted += file.getCount();
            this.counter.add(file.getCount());
        }
        int newTime = this.getTicker();
        if (this.ticker != newTime) {
            this.ticker = newTime;
            ITextComponent text = TextUtil.translate("process.chunk_pregen.stuck.split").func_150259_f();
            text.func_150257_a(TextUtil.wrap(TextUtil.applyTextStyle(TextUtil.translate("task.chunk_pregen.name", this.task.getName()), TextFormatting.RED))).func_150257_a(TextUtil.translate("process.chunk_pregen.stuck.split"));
            text.func_150257_a(TextUtil.wrap(TextUtil.applyTextStyle(TextUtil.translate("task.chunk_pregen.dimension", TextUtil.dimension(this.process.server.field_73011_w.getDimension())), TextFormatting.GREEN))).func_150257_a(TextUtil.translate("process.chunk_pregen.stuck.split"));
            text.func_150257_a(TextUtil.wrap(TextUtil.applyTextStyle(TextUtil.translate("deleter.chunk_pregen.progress", TextUtil.NUMBERS.format(this.deleted), TextUtil.NUMBERS.format(this.failed), TextUtil.NUMBERS.format(this.process.getTotalWork())), TextFormatting.BLUE))).func_150257_a(TextUtil.translate("process.chunk_pregen.stuck.split"));
            text.func_150257_a(TextUtil.wrap(TextUtil.applyTextStyle(TextUtil.ram(), TextFormatting.LIGHT_PURPLE)));
            this.sendMessage(text);
        }
        this.counter.onChunkProcessed();
        if (!this.process.hasWork()) {
            this.onFinished();
            this.timer.reset();
        } else {
            this.timer.finishDeltaTime();
        }
    }

    public void startTask(IDeletionTask task) {
        if (this.task != null) {
            return;
        }
        this.start = Instant.now();
        this.task = task;
        this.progress.reset();
        this.future = task.createTask(this.progress);
        ServerManager.INSTANCE.setActiveTask(this);
    }

    @Override
    public void stop(boolean notify) {
        this.interruptTask(notify);
    }

    public void interruptTask(boolean notify) {
        this.process = null;
        this.task = null;
        if (notify) {
            this.sendMessage(TextUtil.translate("process.chunk_pregen.interrupt"));
            this.sendMessage(TextUtil.translate("process.chunk_pregen.finish.cleanup"));
        }
        this.cleanup();
        ServerManager.INSTANCE.onTaskCompleted();
    }

    public void onFinished() {
        this.sendMessage(TextUtil.translate("deleter.chunk_pregen.finish", this.getTime(), this.process.getTotalWork()));
        PregenTaskStorage storage = PregenTaskStorage.getStorage();
        storage.onTaskFinished(this.task);
        this.task = null;
        this.process = null;
        this.sendMessage(TextUtil.translate("process.chunk_pregen.finish.cleanup"));
        this.cleanup();
        IBaseTask next = storage.getNextTask();
        if (next != null) {
            this.sendMessage(TextUtil.translate("process.chunk_pregen.start_next", next.getName()));
            next.start();
        } else {
            this.sendMessage(TextUtil.translate("process.chunk_pregen.finished"));
            ServerManager.INSTANCE.onTaskCompleted();
        }
    }

    @Override
    public void pauseTask() {
        if (this.process == null || this.paused) {
            return;
        }
        this.paused = true;
        this.task.addActiveTime(Duration.between(Instant.now(), this.start).toMillis());
    }

    @Override
    public void resumeTask() {
        if (this.process == null || !this.paused) {
            return;
        }
        this.paused = false;
        this.start = Instant.now();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    private void cleanup() {
        System.gc();
        this.deleted = 0;
        this.failed = 0;
        this.counter.reset();
    }

    public void sendMessage(ITextComponent component) {
        GlobalListeners.INSTANCE.sendMessage(component);
    }

    public boolean isStopped() {
        return this.task == null;
    }

    public boolean isRunning() {
        return this.task != null;
    }

    protected String getTime() {
        return DurationFormatUtils.formatDuration((long)this.getWorkTime().toMillis(), (String)"HH:mm:ss");
    }

    protected Duration getWorkTime() {
        Duration duration = Duration.between(Instant.now(), this.start).abs();
        return this.task == null ? duration : duration.plusMillis(this.task.getActiveTime());
    }

    private int getTicker() {
        return (int)(Duration.between(this.start, Instant.now()).toMillis() / 1000L);
    }

    @Override
    public IDeletionTask getTask() {
        return this.task;
    }

    @Override
    public String getTaskName() {
        return this.task == null ? "" : this.task.getName();
    }

    @Override
    public long getExpectedTime() {
        if (this.process == null) {
            return 0L;
        }
        float value = this.counter.getAverage();
        if (value <= 0.0f) {
            return 0L;
        }
        return (long)((float)(this.process.getTotalWork() - (this.deleted + this.failed)) / value) * 50L;
    }

    @Override
    public byte getClientDataId() {
        return 2;
    }

    @Override
    public void sendClientData(PacketBuffer buffer) {
        buffer.func_180714_a(this.getTaskName());
        buffer.writeBoolean(this.future != null || this.task == null || this.process == null);
        Runtime runtime = Runtime.getRuntime();
        buffer.writeLong(runtime.totalMemory());
        buffer.writeLong(runtime.maxMemory());
        buffer.writeLong(runtime.freeMemory());
        if (this.future != null || this.task == null || this.process == null) {
            buffer.writeLong(this.progress == null ? 0L : this.progress.getCurrent());
            buffer.writeLong(this.progress == null ? 0L : this.progress.getMax());
            return;
        }
        buffer.writeBoolean(this.paused);
        buffer.writeLong(this.getWorkTime().toMillis());
        buffer.writeLong((long)this.process.getTotalWork());
        buffer.writeLong((long)this.deleted);
        buffer.writeLong((long)this.failed);
    }
}

